/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.packageview;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IParent;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.packageview.PackageFragmentRootContainer;

public class NamespaceGroup
implements IAdaptable {
    String fNamePrefix;
    int fNamePrefixLength;
    private IPackageFragmentRoot fPackageFragmentRoot;
    private PackageFragmentRootContainer fPackageFragmentRootContainer;
    private IJavaScriptUnit fJavaScriptUnit;

    public NamespaceGroup(IPackageFragmentRoot root, String prefix) {
        this.fPackageFragmentRoot = root;
        this.fNamePrefix = prefix;
        this.fNamePrefixLength = this.fNamePrefix.length();
        this.fJavaScriptUnit = null;
    }

    public NamespaceGroup(PackageFragmentRootContainer root, String prefix) {
        this.fPackageFragmentRootContainer = root;
        this.fNamePrefix = prefix;
        this.fNamePrefixLength = this.fNamePrefix.length();
        this.fJavaScriptUnit = null;
    }

    public NamespaceGroup(IJavaScriptUnit unit, String prefix) {
        this.fNamePrefix = prefix;
        this.fNamePrefixLength = this.fNamePrefix.length();
        this.fJavaScriptUnit = unit;
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this.fPackageFragmentRoot;
    }

    public PackageFragmentRootContainer getPackageFragmentRootContainer() {
        return this.fPackageFragmentRootContainer;
    }

    public IJavaScriptUnit getJavaScriptUnit() {
        return this.fJavaScriptUnit;
    }

    Object getParent() {
        if (this.fPackageFragmentRoot != null) {
            return this.fPackageFragmentRoot;
        }
        if (this.fPackageFragmentRootContainer != null) {
            return this.fPackageFragmentRootContainer;
        }
        if (this.fJavaScriptUnit != null) {
            return this.fJavaScriptUnit;
        }
        return null;
    }

    private int computeParentHash() {
        if (this.fPackageFragmentRoot != null) {
            return this.fPackageFragmentRoot.hashCode();
        }
        if (this.fPackageFragmentRootContainer != null) {
            return this.fPackageFragmentRootContainer.hashCode();
        }
        return 0;
    }

    public String getText() {
        return this.fNamePrefix;
    }

    public boolean equals(Object obj) {
        if (obj instanceof NamespaceGroup && this.getParent() != null) {
            return this.fNamePrefix.equals(((NamespaceGroup)obj).fNamePrefix) && this.getParent().equals(((NamespaceGroup)obj).getParent());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.computeParentHash() + super.hashCode();
    }

    protected IJavaScriptElement[] filter(IJavaScriptElement[] children) {
        boolean initializers = false;
        int i = 0;
        while (i < children.length) {
            if (this.matches(children[i])) {
                initializers = true;
                break;
            }
            ++i;
        }
        if (!initializers) {
            return children;
        }
        ArrayList<IJavaScriptElement> v = new ArrayList<IJavaScriptElement>();
        int i2 = 0;
        while (i2 < children.length) {
            if (!this.matches(children[i2])) {
                v.add(children[i2]);
            }
            ++i2;
        }
        IJavaScriptElement[] result = v.toArray(new IJavaScriptElement[v.size()]);
        return result;
    }

    protected boolean matches(IJavaScriptElement element) {
        if (element.getElementType() == 7 && (element.getParent().getElementType() == 5 || element.getParent().getElementType() == 6)) {
            IType type = (IType)element;
            try {
                return type.isAnonymous();
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public Object[] getChildren() {
        Object[] children = null;
        try {
            children = ((IParent)this.getParent()).getChildren();
        }
        catch (JavaScriptModelException ex1) {
            ex1.printStackTrace();
        }
        if (children == null) {
            return null;
        }
        ArrayList<IJavaScriptElement> allChildren = new ArrayList<IJavaScriptElement>();
        boolean unique = false;
        try {
            while (!unique && children != null && children.length > 0) {
                int i = 0;
                while (i < children.length) {
                    String display2;
                    String display1 = children[0].getDisplayName();
                    if (display1 != (display2 = children[i].getDisplayName()) && (display1 == null || display1.compareTo(display2) != 0)) {
                        allChildren.addAll(Arrays.asList(children));
                        unique = true;
                        break;
                    }
                    ++i;
                }
                ArrayList<IJavaScriptElement> more = new ArrayList<IJavaScriptElement>();
                int i2 = 0;
                while (!unique && i2 < children.length) {
                    if (children[i2] instanceof IPackageFragment) {
                        more.addAll(Arrays.asList(((IPackageFragment)children[i2]).getChildren()));
                    } else if (children[i2] instanceof IPackageFragmentRoot) {
                        more.addAll(Arrays.asList(((IPackageFragmentRoot)children[i2]).getChildren()));
                    } else if (children[i2] instanceof IClassFile) {
                        more.addAll(Arrays.asList(this.filter(((IClassFile)children[i2]).getChildren())));
                    } else if (children[i2] instanceof IJavaScriptUnit) {
                        more.addAll(Arrays.asList(this.filter(((IJavaScriptUnit)children[i2]).getChildren())));
                    } else {
                        unique = true;
                        break;
                    }
                    ++i2;
                }
                if (unique) continue;
                children = more.toArray();
            }
        }
        catch (JavaScriptModelException ex) {
            ex.printStackTrace();
        }
        return allChildren.toArray();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IWorkbenchAdapter.class) {
            return new WorkBenchAdapter();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String toString() {
        return "Namespacegroup: " + this.fNamePrefix;
    }

    public static final class WorkBenchAdapter
    implements IWorkbenchAdapter {
        private static final String EMPTY_STRING = "";

        public Object[] getChildren(Object o) {
            if (o instanceof NamespaceGroup) {
                return ((NamespaceGroup)o).getChildren();
            }
            return new Object[0];
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return JavaPluginImages.DESC_OBJS_LOGICAL_PACKAGE;
        }

        public String getLabel(Object o) {
            if (o instanceof NamespaceGroup) {
                return ((NamespaceGroup)o).fNamePrefix;
            }
            return EMPTY_STRING;
        }

        public Object getParent(Object o) {
            System.out.println("Unimplemented method:WorkBenchAdapter.getParent");
            return null;
        }
    }
}

