/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRemover;

public final class ImportRewriteUtil {
    public static void addImports(CompilationUnitRewrite rewrite, ASTNode node, Map typeImports, Map staticImports, boolean declarations) {
        ImportRewriteUtil.addImports(rewrite, node, typeImports, staticImports, null, declarations);
    }

    public static void addImports(CompilationUnitRewrite rewrite, ASTNode node, Map typeImports, Map staticImports, Collection excludeBindings, final boolean declarations) {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)typeImports);
        Assert.isNotNull((Object)staticImports);
        HashSet types = new HashSet();
        HashSet members = new HashSet();
        ImportReferencesCollector collector = new ImportReferencesCollector(rewrite.getCu().getJavaScriptProject(), null, types, members){

            @Override
            public final boolean visit(Block block) {
                Assert.isNotNull((Object)block);
                if (declarations && block.getParent() instanceof FunctionDeclaration) {
                    return false;
                }
                return super.visit(block);
            }
        };
        node.accept((ASTVisitor)collector);
        ImportRewrite rewriter = rewrite.getImportRewrite();
        ImportRemover remover = rewrite.getImportRemover();
        Name name2 = null;
        IBinding binding = null;
        for (Name name2 : types) {
            binding = name2.resolveBinding();
            if (!(binding instanceof ITypeBinding)) continue;
            ITypeBinding type = (ITypeBinding)binding;
            if (excludeBindings != null && excludeBindings.contains(type)) continue;
            typeImports.put(name2, rewriter.addImport(type));
            remover.registerAddedImport(type.getQualifiedName());
        }
        for (Name name2 : members) {
            IFunctionBinding method;
            ITypeBinding declaring;
            binding = name2.resolveBinding();
            if (binding instanceof IVariableBinding) {
                IVariableBinding variable = (IVariableBinding)binding;
                declaring = variable.getDeclaringClass();
                if (declaring == null || excludeBindings != null && excludeBindings.contains(variable)) continue;
                staticImports.put(name2, rewriter.addStaticImport((IBinding)variable));
                remover.registerAddedStaticImport(declaring.getQualifiedName(), variable.getName(), true);
                continue;
            }
            if (!(binding instanceof IFunctionBinding) || (declaring = (method = (IFunctionBinding)binding).getDeclaringClass()) == null || excludeBindings != null && excludeBindings.contains(method)) continue;
            staticImports.put(name2, rewriter.addStaticImport((IBinding)method));
            remover.registerAddedStaticImport(declaring.getQualifiedName(), method.getName(), false);
        }
    }

    public static void collectImports(IJavaScriptProject project, ASTNode node, Collection typeBindings, Collection staticBindings, boolean declarations) {
        ImportRewriteUtil.collectImports(project, node, typeBindings, staticBindings, null, declarations);
    }

    public static void collectImports(IJavaScriptProject project, ASTNode node, Collection typeBindings, Collection staticBindings, Collection excludeBindings, final boolean declarations) {
        Assert.isNotNull((Object)project);
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)typeBindings);
        Assert.isNotNull((Object)staticBindings);
        HashSet types = new HashSet();
        HashSet members = new HashSet();
        ImportReferencesCollector collector = new ImportReferencesCollector(project, null, types, members){

            @Override
            public final boolean visit(Block block) {
                Assert.isNotNull((Object)block);
                if (declarations && block.getParent() instanceof FunctionDeclaration) {
                    return false;
                }
                return super.visit(block);
            }
        };
        node.accept((ASTVisitor)collector);
        Name name2 = null;
        IBinding binding = null;
        for (Name name2 : types) {
            binding = name2.resolveBinding();
            if (!(binding instanceof ITypeBinding)) continue;
            ITypeBinding type = (ITypeBinding)binding;
            if (excludeBindings != null && excludeBindings.contains(type)) continue;
            typeBindings.add(type);
        }
        for (Name name2 : members) {
            binding = name2.resolveBinding();
            if (binding == null || excludeBindings != null && excludeBindings.contains(binding)) continue;
            staticBindings.add(binding);
        }
    }

    private ImportRewriteUtil() {
    }
}

