/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.DoStatement;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.IfStatement;
import org.eclipse.wst.jsdt.core.dom.InfixExpression;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Message;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.WhileStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTFlattener;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.MembersOrderPreferenceCache;

public class ASTNodes {
    public static final int NODE_ONLY = 0;
    public static final int INCLUDE_FIRST_PARENT = 1;
    public static final int INCLUDE_ALL_PARENTS = 2;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int PROBLEMS = 3;
    private static final Message[] EMPTY_MESSAGES = new Message[0];
    private static final IProblem[] EMPTY_PROBLEMS = new IProblem[0];
    private static final int CLEAR_VISIBILITY = -8;

    private ASTNodes() {
    }

    public static String asString(ASTNode node) {
        ASTFlattener flattener = new ASTFlattener();
        node.accept((ASTVisitor)flattener);
        return flattener.getResult();
    }

    public static String asFormattedString(ASTNode node, int indent, String lineDelim, Map options) {
        String unformatted = ASTNodes.asString(node);
        TextEdit edit = CodeFormatterUtil.format2(node, unformatted, indent, lineDelim, options);
        if (edit != null) {
            return CodeFormatterUtil.evaluateFormatterEdit(unformatted, edit, null);
        }
        return unformatted;
    }

    public static List getContainingList(ASTNode node) {
        StructuralPropertyDescriptor locationInParent = node.getLocationInParent();
        if (locationInParent != null && locationInParent.isChildListProperty()) {
            return (List)node.getParent().getStructuralProperty(locationInParent);
        }
        return null;
    }

    public static List getChildren(ASTNode node) {
        ChildrenCollector visitor = new ChildrenCollector();
        node.accept((ASTVisitor)visitor);
        return visitor.result;
    }

    public static boolean isExistingNode(ASTNode node) {
        return node.getStartPosition() != -1;
    }

    public static Type getElementType(Type type) {
        if (!type.isArrayType()) {
            return type;
        }
        return ((ArrayType)type).getElementType();
    }

    public static ASTNode findDeclaration(IBinding binding, ASTNode root) {
        if ((root = root.getRoot()) instanceof JavaScriptUnit) {
            return ((JavaScriptUnit)root).findDeclaringNode(binding);
        }
        return null;
    }

    public static VariableDeclaration findVariableDeclaration(IVariableBinding binding, ASTNode root) {
        if (binding.isField()) {
            return null;
        }
        ASTNode result = ASTNodes.findDeclaration((IBinding)binding, root);
        if (result instanceof VariableDeclaration) {
            return (VariableDeclaration)result;
        }
        return null;
    }

    public static Type getType(VariableDeclaration declaration) {
        if (declaration instanceof SingleVariableDeclaration) {
            return ((SingleVariableDeclaration)declaration).getType();
        }
        if (declaration instanceof VariableDeclarationFragment) {
            ASTNode parent = ((VariableDeclarationFragment)declaration).getParent();
            if (parent instanceof VariableDeclarationExpression) {
                return ((VariableDeclarationExpression)parent).getType();
            }
            if (parent instanceof VariableDeclarationStatement) {
                return ((VariableDeclarationStatement)parent).getType();
            }
            if (parent instanceof FieldDeclaration) {
                return ((FieldDeclaration)parent).getType();
            }
        }
        Assert.isTrue((boolean)false, (String)"Unknown VariableDeclaration");
        return null;
    }

    public static int getDimensions(VariableDeclaration declaration) {
        int dim = declaration.getExtraDimensions();
        Type type = ASTNodes.getType(declaration);
        if (type instanceof ArrayType) {
            dim += ((ArrayType)type).getDimensions();
        }
        return dim;
    }

    public static List getModifiers(VariableDeclaration declaration) {
        Assert.isNotNull((Object)declaration);
        if (declaration instanceof SingleVariableDeclaration) {
            return ((SingleVariableDeclaration)declaration).modifiers();
        }
        if (declaration instanceof VariableDeclarationFragment) {
            ASTNode parent = declaration.getParent();
            if (parent instanceof VariableDeclarationExpression) {
                return ((VariableDeclarationExpression)parent).modifiers();
            }
            if (parent instanceof VariableDeclarationStatement) {
                return ((VariableDeclarationStatement)parent).modifiers();
            }
        }
        return new ArrayList(0);
    }

    public static boolean isSingleDeclaration(VariableDeclaration declaration) {
        Assert.isNotNull((Object)declaration);
        if (declaration instanceof SingleVariableDeclaration) {
            return true;
        }
        if (declaration instanceof VariableDeclarationFragment) {
            ASTNode parent = declaration.getParent();
            if (parent instanceof VariableDeclarationExpression) {
                return ((VariableDeclarationExpression)parent).fragments().size() == 1;
            }
            if (parent instanceof VariableDeclarationStatement) {
                return ((VariableDeclarationStatement)parent).fragments().size() == 1;
            }
        }
        return false;
    }

    public static boolean isLiteral(Expression expression) {
        int type = expression.getNodeType();
        return type == 9 || type == 13 || type == 33 || type == 34 || type == 45 || type == 57 || type == 87 || type == 85 || type == 88;
    }

    public static boolean isLabel(SimpleName name) {
        int parentType = name.getParent().getNodeType();
        return parentType == 30 || parentType == 10 || parentType != 18;
    }

    public static boolean isStatic(BodyDeclaration declaration) {
        return Modifier.isStatic((int)declaration.getModifiers());
    }

    public static List getBodyDeclarations(ASTNode node) {
        if (node instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)node).bodyDeclarations();
        }
        if (node instanceof AnonymousClassDeclaration) {
            return ((AnonymousClassDeclaration)node).bodyDeclarations();
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static ChildListPropertyDescriptor getBodyDeclarationsProperty(ASTNode node) {
        if (node instanceof JavaScriptUnit) {
            return JavaScriptUnit.STATEMENTS_PROPERTY;
        }
        if (node instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)node).getBodyDeclarationsProperty();
        }
        if (node instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    public static String getTypeName(Type type) {
        final StringBuffer buffer = new StringBuffer();
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(PrimitiveType node) {
                buffer.append(node.getPrimitiveTypeCode().toString());
                return false;
            }

            public boolean visit(SimpleName node) {
                buffer.append(node.getIdentifier());
                return false;
            }

            public boolean visit(QualifiedName node) {
                buffer.append(node.getName().getIdentifier());
                return false;
            }

            public void endVisit(ArrayType node) {
                buffer.append("[]");
            }
        };
        type.accept(visitor);
        return buffer.toString();
    }

    public static InfixExpression.Operator convertToInfixOperator(Assignment.Operator operator) {
        if (operator.equals(Assignment.Operator.PLUS_ASSIGN)) {
            return InfixExpression.Operator.PLUS;
        }
        if (operator.equals(Assignment.Operator.MINUS_ASSIGN)) {
            return InfixExpression.Operator.MINUS;
        }
        if (operator.equals(Assignment.Operator.TIMES_ASSIGN)) {
            return InfixExpression.Operator.TIMES;
        }
        if (operator.equals(Assignment.Operator.DIVIDE_ASSIGN)) {
            return InfixExpression.Operator.DIVIDE;
        }
        if (operator.equals(Assignment.Operator.BIT_AND_ASSIGN)) {
            return InfixExpression.Operator.AND;
        }
        if (operator.equals(Assignment.Operator.BIT_OR_ASSIGN)) {
            return InfixExpression.Operator.OR;
        }
        if (operator.equals(Assignment.Operator.BIT_XOR_ASSIGN)) {
            return InfixExpression.Operator.XOR;
        }
        if (operator.equals(Assignment.Operator.REMAINDER_ASSIGN)) {
            return InfixExpression.Operator.REMAINDER;
        }
        if (operator.equals(Assignment.Operator.LEFT_SHIFT_ASSIGN)) {
            return InfixExpression.Operator.LEFT_SHIFT;
        }
        if (operator.equals(Assignment.Operator.RIGHT_SHIFT_SIGNED_ASSIGN)) {
            return InfixExpression.Operator.RIGHT_SHIFT_SIGNED;
        }
        if (operator.equals(Assignment.Operator.RIGHT_SHIFT_UNSIGNED_ASSIGN)) {
            return InfixExpression.Operator.RIGHT_SHIFT_UNSIGNED;
        }
        Assert.isTrue((boolean)false, (String)"Cannot convert assignment operator");
        return null;
    }

    public static boolean isControlStatementBody(StructuralPropertyDescriptor locationInParent) {
        return locationInParent == IfStatement.THEN_STATEMENT_PROPERTY || locationInParent == IfStatement.ELSE_STATEMENT_PROPERTY || locationInParent == ForStatement.BODY_PROPERTY || locationInParent == ForInStatement.BODY_PROPERTY || locationInParent == EnhancedForStatement.BODY_PROPERTY || locationInParent == WhileStatement.BODY_PROPERTY || locationInParent == DoStatement.BODY_PROPERTY;
    }

    public static boolean needsParentheses(Expression expression) {
        int type = expression.getNodeType();
        return type == 27 || type == 16 || type == 38 || type == 37 || type == 62;
    }

    public static boolean substituteMustBeParenthesized(Expression substitute, Expression location) {
        FunctionInvocation mi;
        VariableDeclarationFragment vdf;
        if (!ASTNodes.needsParentheses(substitute)) {
            return false;
        }
        ASTNode parent = location.getParent();
        return !(parent instanceof VariableDeclarationFragment ? (vdf = (VariableDeclarationFragment)parent).getInitializer().equals((Object)location) : (parent instanceof FunctionInvocation ? (mi = (FunctionInvocation)parent).arguments().contains(location) : parent instanceof ReturnStatement));
    }

    public static ASTNode getParent(ASTNode node, Class parentClass) {
        while ((node = node.getParent()) != null && !parentClass.isInstance(node)) {
        }
        return node;
    }

    public static ASTNode getParent(ASTNode node, int nodeType) {
        while ((node = node.getParent()) != null && node.getNodeType() != nodeType) {
        }
        return node;
    }

    public static ASTNode findParent(ASTNode node, StructuralPropertyDescriptor[][] pathes) {
        int p = 0;
        while (p < pathes.length) {
            StructuralPropertyDescriptor[] path = pathes[p];
            ASTNode current = node;
            int d = path.length - 1;
            while (d >= 0 && current != null) {
                StructuralPropertyDescriptor descriptor = path[d];
                if (!descriptor.equals(current.getLocationInParent())) break;
                current = current.getParent();
                --d;
            }
            if (d < 0) {
                return current;
            }
            ++p;
        }
        return null;
    }

    public static ASTNode getNormalizedNode(ASTNode node) {
        ASTNode current = node;
        if (QualifiedName.NAME_PROPERTY.equals(current.getLocationInParent())) {
            current = current.getParent();
        }
        if (QualifiedType.NAME_PROPERTY.equals(current.getLocationInParent()) || SimpleType.NAME_PROPERTY.equals(current.getLocationInParent())) {
            current = current.getParent();
        }
        return current;
    }

    public static boolean isParent(ASTNode node, ASTNode parent) {
        Assert.isNotNull((Object)parent);
        do {
            if ((node = node.getParent()) != parent) continue;
            return true;
        } while (node != null);
        return false;
    }

    public static int getExclusiveEnd(ASTNode node) {
        return node.getStartPosition() + node.getLength();
    }

    public static int getInclusiveEnd(ASTNode node) {
        return node.getStartPosition() + node.getLength() - 1;
    }

    public static IFunctionBinding getMethodBinding(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IFunctionBinding) {
            return (IFunctionBinding)binding;
        }
        return null;
    }

    public static IVariableBinding getVariableBinding(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof IVariableBinding) {
            return (IVariableBinding)binding;
        }
        return null;
    }

    public static IVariableBinding getLocalVariableBinding(Name node) {
        IVariableBinding result = ASTNodes.getVariableBinding(node);
        if (result == null || result.isField()) {
            return null;
        }
        return result;
    }

    public static IVariableBinding getFieldBinding(Name node) {
        IVariableBinding result = ASTNodes.getVariableBinding(node);
        if (result == null || !result.isField()) {
            return null;
        }
        return result;
    }

    public static ITypeBinding getTypeBinding(Name node) {
        IBinding binding = node.resolveBinding();
        if (binding instanceof ITypeBinding) {
            return (ITypeBinding)binding;
        }
        return null;
    }

    public static ITypeBinding getReceiverTypeBinding(FunctionInvocation invocation) {
        ITypeBinding result = null;
        Expression exp = invocation.getExpression();
        if (exp != null) {
            return exp.resolveTypeBinding();
        }
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)invocation, AbstractTypeDeclaration.class);
        if (type != null) {
            return type.resolveBinding();
        }
        return result;
    }

    public static ITypeBinding getEnclosingType(ASTNode node) {
        while (node != null) {
            if (node instanceof AbstractTypeDeclaration) {
                return ((AbstractTypeDeclaration)node).resolveBinding();
            }
            if (node instanceof AnonymousClassDeclaration) {
                return ((AnonymousClassDeclaration)node).resolveBinding();
            }
            if (node instanceof JavaScriptUnit) {
                return ((JavaScriptUnit)node).resolveBinding();
            }
            node = node.getParent();
        }
        return null;
    }

    public static IProblem[] getProblems(ASTNode node, int scope, int severity) {
        ASTNode root = node.getRoot();
        if (!(root instanceof JavaScriptUnit)) {
            return EMPTY_PROBLEMS;
        }
        IProblem[] problems = ((JavaScriptUnit)root).getProblems();
        if (root == node) {
            return problems;
        }
        int iterations = ASTNodes.computeIterations(scope);
        ArrayList<IProblem> result = new ArrayList<IProblem>(5);
        int i = 0;
        while (i < problems.length) {
            IProblem problem = problems[i];
            boolean consider = false;
            if ((severity & 3) == 3) {
                consider = true;
            } else if ((severity & 1) != 0) {
                consider = problem.isWarning();
            } else if ((severity & 2) != 0) {
                consider = problem.isError();
            }
            if (consider) {
                ASTNode temp = node;
                int count = iterations;
                do {
                    int problemOffset;
                    int nodeOffset;
                    if ((nodeOffset = temp.getStartPosition()) <= (problemOffset = problem.getSourceStart()) && problemOffset < nodeOffset + temp.getLength()) {
                        result.add(problem);
                        count = 0;
                        continue;
                    }
                    --count;
                } while ((temp = temp.getParent()) != null && count > 0);
            }
            ++i;
        }
        return result.toArray(new IProblem[result.size()]);
    }

    public static Message[] getMessages(ASTNode node, int flags) {
        ASTNode root = node.getRoot();
        if (!(root instanceof JavaScriptUnit)) {
            return EMPTY_MESSAGES;
        }
        Message[] messages = ((JavaScriptUnit)root).getMessages();
        if (root == node) {
            return messages;
        }
        int iterations = ASTNodes.computeIterations(flags);
        ArrayList<Message> result = new ArrayList<Message>(5);
        int i = 0;
        while (i < messages.length) {
            Message message = messages[i];
            ASTNode temp = node;
            int count = iterations;
            do {
                int messageOffset;
                int nodeOffset;
                if ((nodeOffset = temp.getStartPosition()) <= (messageOffset = message.getStartPosition()) && messageOffset < nodeOffset + temp.getLength()) {
                    result.add(message);
                    count = 0;
                    continue;
                }
                --count;
            } while ((temp = temp.getParent()) != null && count > 0);
            ++i;
        }
        return result.toArray(new Message[result.size()]);
    }

    private static int computeIterations(int flags) {
        switch (flags) {
            case 0: {
                return 1;
            }
            case 2: {
                return Integer.MAX_VALUE;
            }
            case 1: {
                return 2;
            }
        }
        return 1;
    }

    private static int getOrderPreference(BodyDeclaration member, MembersOrderPreferenceCache store) {
        int memberType = member.getNodeType();
        int modifiers = member.getModifiers();
        switch (memberType) {
            case 55: {
                return store.getCategoryIndex(0) * 2;
            }
            case 23: {
                if (Modifier.isStatic((int)modifiers)) {
                    int index = store.getCategoryIndex(5) * 2;
                    if (Modifier.isFinal((int)modifiers)) {
                        return index;
                    }
                    return index + 1;
                }
                return store.getCategoryIndex(3) * 2;
            }
            case 28: {
                if (Modifier.isStatic((int)modifiers)) {
                    return store.getCategoryIndex(6) * 2;
                }
                return store.getCategoryIndex(4) * 2;
            }
            case 31: {
                if (Modifier.isStatic((int)modifiers)) {
                    return store.getCategoryIndex(7) * 2;
                }
                if (((FunctionDeclaration)member).isConstructor()) {
                    return store.getCategoryIndex(1) * 2;
                }
                return store.getCategoryIndex(2) * 2;
            }
        }
        return 100;
    }

    public static int getInsertionIndex(BodyDeclaration member, List container) {
        int containerSize = container.size();
        MembersOrderPreferenceCache orderStore = JavaScriptPlugin.getDefault().getMemberOrderPreferenceCache();
        int orderIndex = ASTNodes.getOrderPreference(member, orderStore);
        int insertPos = containerSize;
        int insertPosOrderIndex = -1;
        int i = containerSize - 1;
        while (i >= 0) {
            int currOrderIndex = ASTNodes.getOrderPreference((BodyDeclaration)container.get(i), orderStore);
            if (orderIndex == currOrderIndex) {
                if (insertPosOrderIndex != orderIndex) {
                    insertPos = i + 1;
                    insertPosOrderIndex = orderIndex;
                }
            } else if (insertPosOrderIndex != orderIndex) {
                if (currOrderIndex < orderIndex) {
                    if (insertPosOrderIndex == -1) {
                        insertPos = i + 1;
                        insertPosOrderIndex = currOrderIndex;
                    }
                } else {
                    insertPos = i;
                    insertPosOrderIndex = currOrderIndex;
                }
            }
            --i;
        }
        return insertPos;
    }

    public static SimpleName getLeftMostSimpleName(Name name) {
        if (name instanceof SimpleName) {
            return (SimpleName)name;
        }
        final SimpleName[] result = new SimpleName[1];
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(QualifiedName qualifiedName) {
                Name left = qualifiedName.getQualifier();
                if (left instanceof SimpleName) {
                    result[0] = (SimpleName)left;
                } else {
                    left.accept((ASTVisitor)this);
                }
                return false;
            }
        };
        name.accept(visitor);
        return result[0];
    }

    public static SimpleType getLeftMostSimpleType(QualifiedType type) {
        final SimpleType[] result = new SimpleType[1];
        ASTVisitor visitor = new ASTVisitor(){

            public boolean visit(QualifiedType qualifiedType) {
                Type left = qualifiedType.getQualifier();
                if (left instanceof SimpleType) {
                    result[0] = (SimpleType)left;
                } else {
                    left.accept((ASTVisitor)this);
                }
                return false;
            }
        };
        type.accept(visitor);
        return result[0];
    }

    public static Name getTopMostName(Name name) {
        Name result = name;
        while (result.getParent() instanceof Name) {
            result = (Name)result.getParent();
        }
        return result;
    }

    public static Type getTopMostType(Type type) {
        Type result = type;
        while (result.getParent() instanceof Type) {
            result = (Type)result.getParent();
        }
        return result;
    }

    public static int changeVisibility(int modifiers, int visibility) {
        return modifiers & 0xFFFFFFF8 | visibility;
    }

    public static void setFlagsToAST(ASTNode root, final int flags) {
        root.accept((ASTVisitor)new GenericVisitor(true){

            @Override
            protected boolean visitNode(ASTNode node) {
                node.setFlags(node.getFlags() | flags);
                return true;
            }
        });
    }

    public static String getQualifier(Name name) {
        if (name.isQualifiedName()) {
            return ((QualifiedName)name).getQualifier().getFullyQualifiedName();
        }
        return "";
    }

    public static String getSimpleNameIdentifier(Name name) {
        if (name.isQualifiedName()) {
            return ((QualifiedName)name).getName().getIdentifier();
        }
        return ((SimpleName)name).getIdentifier();
    }

    public static boolean isDeclaration(Name name) {
        if (name.isQualifiedName()) {
            return ((QualifiedName)name).getName().isDeclaration();
        }
        return ((SimpleName)name).isDeclaration();
    }

    public static Modifier findModifierNode(int flag, List modifiers) {
        int i = 0;
        while (i < modifiers.size()) {
            Object curr = modifiers.get(i);
            if (curr instanceof Modifier && ((Modifier)curr).getKeyword().toFlagValue() == flag) {
                return (Modifier)curr;
            }
            ++i;
        }
        return null;
    }

    public static ITypeBinding getTypeBinding(JavaScriptUnit root, IType type) throws JavaScriptModelException {
        if (type.isAnonymous()) {
            ClassInstanceCreation creation = (ClassInstanceCreation)ASTNodes.getParent(NodeFinder.perform((ASTNode)root, type.getNameRange()), ClassInstanceCreation.class);
            if (creation != null) {
                return creation.resolveTypeBinding();
            }
        } else {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent(NodeFinder.perform((ASTNode)root, type.getNameRange()), AbstractTypeDeclaration.class);
            if (declaration != null) {
                return declaration.resolveBinding();
            }
        }
        return null;
    }

    private static class ChildrenCollector
    extends GenericVisitor {
        public List result = null;

        public ChildrenCollector() {
            super(true);
        }

        @Override
        protected boolean visitNode(ASTNode node) {
            if (this.result == null) {
                this.result = new ArrayList();
                return true;
            }
            this.result.add(node);
            return false;
        }
    }
}

