/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ejb.provider;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.MethodTransaction;
import org.eclipse.jst.j2ee.ejb.internal.impl.EjbFactoryImpl;
import org.eclipse.jst.j2ee.internal.ejb.provider.AbstractMethodsContentProvider;

public class MethodTransactionContentProvider
extends AbstractMethodsContentProvider {
    private static final EStructuralFeature TRANSACTION_MES_SF = EjbFactoryImpl.getPackage().getMethodTransaction_MethodElements();
    private static final EStructuralFeature AD_MT_SF = EjbFactoryImpl.getPackage().getAssemblyDescriptor_MethodTransactions();

    public MethodTransactionContentProvider(AdapterFactory adapterFactory, boolean root) {
        super(adapterFactory, root);
    }

    public MethodTransactionContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof MethodTransaction) {
            return this.getEnterpriseBeans((MethodTransaction)parentElement);
        }
        return super.getChildren(parentElement);
    }

    protected Object[] getEnterpriseBeans(MethodTransaction mt) {
        EList mes = mt.getMethodElements();
        return this.getEnterpriseBeans((EObject)mt, (List)mes);
    }

    @Override
    protected List getMethodElements(EObject aRefObject, EnterpriseBean anEJB) {
        if (aRefObject == null || !(aRefObject instanceof MethodTransaction)) {
            return Collections.EMPTY_LIST;
        }
        MethodTransaction parentMT = (MethodTransaction)aRefObject;
        return parentMT.getMethodElements(anEJB);
    }

    public Object[] getElements(Object inputElement) {
        EJBJar jar;
        super.getElements(inputElement);
        if (inputElement instanceof EJBJar && (jar = (EJBJar)inputElement).getAssemblyDescriptor() != null) {
            return jar.getAssemblyDescriptor().getMethodTransactions().toArray();
        }
        if (inputElement instanceof AssemblyDescriptor) {
            return ((AssemblyDescriptor)inputElement).getMethodTransactions().toArray();
        }
        return new Object[0];
    }

    @Override
    public boolean hasChildren(Object element) {
        if (element instanceof MethodTransaction) {
            return !((MethodTransaction)element).getMethodElements().isEmpty();
        }
        return super.hasChildren(element);
    }

    @Override
    protected EStructuralFeature getMethodElementsReference() {
        return TRANSACTION_MES_SF;
    }

    @Override
    protected EStructuralFeature getMethodElementsContainerReference() {
        return AD_MT_SF;
    }
}

