/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.ByPathWarningsGuard;
import com.google.javascript.jscomp.CheckLevel;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.WarningsGuard;
import java.util.List;

public final class ShowByPathWarningsGuard
extends WarningsGuard {
    private static final long serialVersionUID = 1L;
    private final ByPathWarningsGuard warningsGuard;

    public ShowByPathWarningsGuard(String checkWarningsOnlyForPath) {
        this(checkWarningsOnlyForPath, ShowType.INCLUDE);
    }

    public ShowByPathWarningsGuard(String[] checkWarningsOnlyForPath) {
        this(checkWarningsOnlyForPath, ShowType.INCLUDE);
    }

    public ShowByPathWarningsGuard(String path, ShowType showType) {
        this(new String[]{path}, showType);
    }

    public ShowByPathWarningsGuard(String[] paths, ShowType showType) {
        Preconditions.checkArgument((paths != null ? 1 : 0) != 0);
        Preconditions.checkArgument((showType != null ? 1 : 0) != 0);
        ImmutableList pathList = ImmutableList.copyOf((Object[])paths);
        this.warningsGuard = showType == ShowType.INCLUDE ? ByPathWarningsGuard.exceptPath((List<String>)pathList, CheckLevel.OFF) : ByPathWarningsGuard.forPath((List<String>)pathList, CheckLevel.OFF);
    }

    @Override
    public CheckLevel level(JSError error) {
        return this.warningsGuard.level(error);
    }

    @Override
    protected int getPriority() {
        return this.warningsGuard.getPriority();
    }

    public static enum ShowType {
        INCLUDE,
        EXCLUDE;

    }
}

