/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.JSError;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PolymerClassDefinition;
import com.google.javascript.jscomp.PolymerPass;
import com.google.javascript.jscomp.PolymerPassErrors;
import com.google.javascript.jscomp.parsing.parser.util.format.SimpleFormat;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.JSTypeExpression;
import com.google.javascript.rhino.Node;

final class PolymerPassStaticUtils {
    PolymerPassStaticUtils() {
    }

    static void switchDollarSignPropsToBrackets(Node objLit, final AbstractCompiler compiler) {
        Preconditions.checkState((boolean)objLit.isObjectLit());
        for (Node keyNode : objLit.children()) {
            Node value = keyNode.getFirstChild();
            if (value == null || !value.isFunction()) continue;
            NodeUtil.visitPostOrder(value.getLastChild(), new NodeUtil.Visitor(){

                @Override
                public void visit(Node n) {
                    if (n.isString() && n.getString().equals("$") && n.getParent().isGetProp() && n.getGrandparent().isGetProp()) {
                        Node dollarChildProp = n.getGrandparent();
                        dollarChildProp.setType(35);
                        compiler.reportCodeChange();
                    }
                }
            }, (Predicate<Node>)Predicates.alwaysTrue());
        }
    }

    static void quoteListenerAndHostAttributeKeys(Node objLit) {
        Preconditions.checkState((boolean)objLit.isObjectLit());
        for (Node keyNode : objLit.children()) {
            if (keyNode.isComputedProp() || !keyNode.getString().equals("listeners") && !keyNode.getString().equals("hostAttributes")) continue;
            for (Node keyToQuote : keyNode.getFirstChild().children()) {
                keyToQuote.setQuotedString();
            }
        }
    }

    static ImmutableList<PolymerPass.MemberDefinition> extractProperties(Node descriptor) {
        Node properties = NodeUtil.getFirstPropMatchingKey(descriptor, "properties");
        if (properties == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder members = ImmutableList.builder();
        for (Node keyNode : properties.children()) {
            members.add((Object)new PolymerPass.MemberDefinition(NodeUtil.getBestJSDocInfo(keyNode), keyNode, keyNode.getFirstChild()));
        }
        return members.build();
    }

    static JSTypeExpression getTypeFromProperty(PolymerPass.MemberDefinition property, AbstractCompiler compiler) {
        Node typeNode;
        String typeString;
        if (property.info != null && property.info.hasType()) {
            return property.info.getType();
        }
        if (property.value.isObjectLit()) {
            Node typeValue = NodeUtil.getFirstPropMatchingKey(property.value, "type");
            if (typeValue == null || !typeValue.isName()) {
                compiler.report(JSError.make(property.name, PolymerPassErrors.POLYMER_INVALID_PROPERTY, new String[0]));
                return null;
            }
            typeString = typeValue.getString();
        } else {
            typeString = property.value.isName() ? property.value.getString() : "";
        }
        switch (typeString) {
            case "Boolean": 
            case "String": 
            case "Number": {
                typeNode = IR.string(typeString.toLowerCase());
                break;
            }
            case "Array": 
            case "Function": 
            case "Object": 
            case "Date": {
                typeNode = new Node(306, IR.string(typeString));
                break;
            }
            default: {
                compiler.report(JSError.make(property.name, PolymerPassErrors.POLYMER_INVALID_PROPERTY, new String[0]));
                return null;
            }
        }
        return new JSTypeExpression(typeNode, "<PolymerPass.java>");
    }

    public static String getPolymerElementType(PolymerClassDefinition cls) {
        String nativeElementName = cls.nativeBaseElement == null ? "" : CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_CAMEL, cls.nativeBaseElement);
        return SimpleFormat.format("Polymer%sElement", nativeElementName);
    }
}

