/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.DefinitionProvider;
import com.google.javascript.jscomp.DefinitionsRemover;
import com.google.javascript.jscomp.graph.GraphNode;
import com.google.javascript.jscomp.graph.LinkedDirectedGraph;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.JSType;
import com.google.javascript.rhino.jstype.JSTypeNative;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class NameReferenceGraph
extends LinkedDirectedGraph<Name, Reference>
implements DefinitionProvider {
    private final Multimap<Node, Name> referenceMap = HashMultimap.create();
    private Map<String, Name> nameMap = new HashMap<String, Name>();
    final Name unknown;
    final Name main;
    final Name window;
    final AbstractCompiler compiler;

    public NameReferenceGraph(AbstractCompiler compiler) {
        super(true, true);
        this.compiler = compiler;
        this.unknown = new Name("{UNKNOWN}", true);
        this.unknown.isAliased = true;
        this.unknown.type = (JSType)compiler.getTypeIRegistry().getNativeType(JSTypeNative.NO_TYPE);
        this.createNode(this.unknown);
        this.main = new Name("{Global Main}", true);
        this.createNode(this.main);
        this.window = new Name("window", true);
        this.createNode(this.window);
    }

    public Name defineNameIfNotExists(String name, boolean isExtern) {
        Name symbol = null;
        if (this.nameMap.containsKey(name)) {
            symbol = this.nameMap.get(name);
        } else {
            symbol = new Name(name, isExtern);
            this.nameMap.put(name, symbol);
            this.createNode(symbol);
        }
        return symbol;
    }

    public List<Name> getReferencesAt(Node site) {
        Preconditions.checkArgument((site.isGetProp() || site.isName() ? 1 : 0) != 0);
        ArrayList<Name> result = new ArrayList<Name>();
        result.addAll(this.referenceMap.get((Object)site));
        return result;
    }

    @Override
    public Collection<DefinitionsRemover.Definition> getDefinitionsReferencedAt(Node useSite) {
        List<Name> nameRefs = this.getReferencesAt(useSite);
        if (nameRefs.isEmpty()) {
            return null;
        }
        ArrayList<DefinitionsRemover.Definition> result = new ArrayList<DefinitionsRemover.Definition>();
        for (Name nameRef : nameRefs) {
            List<DefinitionsRemover.Definition> decls = nameRef.getDeclarations();
            if (decls.isEmpty()) continue;
            result.addAll(decls);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    public Name getSymbol(String name) {
        return this.nameMap.get(name);
    }

    @Override
    public GraphNode<Name, Reference> createNode(Name value) {
        this.nameMap.put(value.qName, value);
        return super.createNode(value);
    }

    @Override
    public void connect(Name src, Reference ref, Name dest) {
        super.connect(src, ref, dest);
        this.referenceMap.put((Object)ref.site, (Object)dest);
    }

    class Name {
        private final String qName;
        private JSType type;
        private List<DefinitionsRemover.Definition> declarations = new LinkedList<DefinitionsRemover.Definition>();
        final boolean isExtern;
        private boolean isExported = false;
        private boolean isAliased = false;
        private boolean exposedToCallOrApply = false;

        public Name(String qName, boolean isExtern) {
            this.qName = qName;
            this.isExtern = isExtern;
            int lastDot = qName.lastIndexOf(46);
            String name = lastDot == -1 ? qName : qName.substring(lastDot + 1);
            this.isExported = NameReferenceGraph.this.compiler.getCodingConvention().isExported(name);
            this.type = (JSType)NameReferenceGraph.this.compiler.getTypeIRegistry().getNativeType(JSTypeNative.UNKNOWN_TYPE);
        }

        public JSType getType() {
            return this.type;
        }

        public void setType(JSType type) {
            this.type = type;
        }

        public List<DefinitionsRemover.Definition> getDeclarations() {
            return this.declarations;
        }

        public void addAssignmentDeclaration(Node node) {
            this.declarations.add(new DefinitionsRemover.AssignmentDefinition(node, this.isExtern));
        }

        public void addFunctionDeclaration(Node node) {
            this.declarations.add(new DefinitionsRemover.NamedFunctionDefinition(node, this.isExtern));
        }

        public void markExported() {
            this.isExported = true;
        }

        public boolean isExported() {
            return this.isExported;
        }

        public boolean isAliased() {
            return this.isAliased;
        }

        public void setAliased(boolean isAliased) {
            this.isAliased = isAliased;
        }

        public String getQualifiedName() {
            return this.qName;
        }

        public String getPropertyName() {
            int lastIndexOfDot = this.qName.lastIndexOf(46);
            if (lastIndexOfDot == -1) {
                return null;
            }
            return this.qName.substring(lastIndexOfDot + 1);
        }

        public boolean exposedToCallOrApply() {
            return this.exposedToCallOrApply;
        }

        public void markExposedToCallOrApply() {
            this.exposedToCallOrApply = true;
        }

        public String toString() {
            return this.qName + " : " + this.type;
        }

        public int hashCode() {
            return this.qName.hashCode();
        }
    }

    static class Reference {
        public final Node site;

        public Reference(Node site) {
            this.site = site;
        }

        public Node getSite() {
            return this.site;
        }
    }
}

