/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.properties.sections;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11EndPoint;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorCSHelpIds;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDSetExistingBindingAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDSetNewBindingAction;
import org.eclipse.wst.wsdl.ui.internal.asd.contentgenerator.ui.extension.ContentGeneratorUIExtension;
import org.eclipse.wst.wsdl.ui.internal.asd.contentgenerator.ui.extension.ContentGeneratorUIExtensionRegistry;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObject;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IBinding;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IEndPoint;
import org.eclipse.wst.wsdl.ui.internal.asd.properties.sections.ReferenceSection;
import org.eclipse.wst.wsdl.ui.internal.util.ReferenceEditManagerHelper;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;

public class EndPointSection
extends ReferenceSection {
    protected Text addressText;
    protected CCombo protocolCombo;
    protected List bindingsInCombo = new ArrayList();
    protected ComponentReferenceEditManager refManager;

    @Override
    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        CLabel addressLabel = this.getWidgetFactory().createCLabel(this.composite, String.valueOf(Messages._UI_LABEL_ADDRESS) + ":");
        this.addressText = this.getWidgetFactory().createText(this.composite, "");
        GridData data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        addressLabel.setLayoutData((Object)data);
        this.addressText.setLayoutData((Object)new GridData(768));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.addressText, ASDEditorCSHelpIds.PROPERTIES_PORT_ADDRESS_TEXT);
        CLabel protocolLabel = this.getWidgetFactory().createCLabel(this.composite, String.valueOf(Messages._UI_LABEL_BINDING_PROTOCOL) + ":");
        this.protocolCombo = this.getWidgetFactory().createCCombo(this.composite);
        data = new GridData();
        data.horizontalAlignment = 32;
        data.grabExcessHorizontalSpace = false;
        protocolLabel.setLayoutData((Object)data);
        this.protocolCombo.setLayoutData((Object)new GridData(768));
        this.protocolCombo.addListener(24, (Listener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.protocolCombo, ASDEditorCSHelpIds.PROPERTIES_PORT_PROTOCOL_TEXT);
        this.comboLabel.setText(Messages._UI_LABEL_BINDING_IN_PROPERTIES_SECTION);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.combo, ASDEditorCSHelpIds.PROPERTIES_PORT_BINDING_COMBO);
    }

    @Override
    public void refresh() {
        this.removeListeners((Control)this.addressText);
        this.protocolCombo.removeListener(24, (Listener)this);
        super.refresh();
        IEndPoint endPoint = (IEndPoint)this.getModel();
        if (endPoint.getAddress() != null && !endPoint.getAddress().equals(this.addressText.getText())) {
            this.addressText.setText(endPoint.getAddress());
        }
        this.protocolCombo.removeAll();
        if (endPoint instanceof W11EndPoint) {
            String protocolValue = ((W11EndPoint)endPoint).getProtocol();
            ContentGeneratorUIExtensionRegistry registry = WSDLEditorPlugin.getInstance().getContentGeneratorUIExtensionRegistry();
            ContentGeneratorUIExtension extt = registry.getExtensionForName(protocolValue);
            if (extt != null) {
                protocolValue = extt.getLabel();
            }
            List protocols = ((W11EndPoint)this.getModel()).getApplicableProtocol();
            for (String protocol : protocols) {
                String label;
                ContentGeneratorUIExtension ext = registry.getExtensionForName(protocol);
                if (ext == null || (label = ext.getLabel()) == null) continue;
                this.protocolCombo.add(label);
            }
            this.protocolCombo.setText(protocolValue);
        }
        this.setControlForegroundColor((Control)this.addressText);
        this.setControlForegroundColor((Control)this.protocolCombo);
        this.applyTextListeners((Control)this.addressText);
        this.protocolCombo.addListener(24, (Listener)this);
    }

    protected ComponentReferenceEditManager getComponentReferenceEditManager() {
        if (this.refManager != null) {
            return this.refManager;
        }
        this.refManager = ReferenceEditManagerHelper.getBindingReferenceEditManager((IASDObject)this.getModel());
        return this.refManager;
    }

    @Override
    protected List getComboItems() {
        ComponentReferenceEditManager manager = this.getComponentReferenceEditManager();
        ArrayList<String> items = new ArrayList<String>();
        items.add(BROWSE_STRING);
        items.add(NEW_STRING);
        if (manager != null) {
            ComponentSpecification[] comboItems = manager.getQuickPicks();
            int index = 0;
            while (index < comboItems.length) {
                items.add((String)comboItems[index]);
                ++index;
            }
        }
        return items;
    }

    @Override
    protected Object getCurrentComboItem() {
        IEndPoint endPoint = (IEndPoint)this.getModel();
        return endPoint.getBinding();
    }

    @Override
    protected String getComboItemName(Object item) {
        String name = "";
        if (item instanceof ComponentSpecification) {
            name = ((ComponentSpecification)item).getName();
        } else if (item instanceof IBinding) {
            name = ((IBinding)item).getName();
        } else if (item instanceof String) {
            name = (String)item;
        }
        return name;
    }

    @Override
    protected void performComboSelection(Object item) {
        ComponentSpecification spec = null;
        if (item instanceof ComponentSpecification) {
            spec = (ComponentSpecification)item;
            ComponentReferenceEditManager manager = this.getComponentReferenceEditManager();
            manager.modifyComponentReference((Object)((IEndPoint)this.getModel()), spec);
        } else if (item instanceof String) {
            if (item.equals(BROWSE_STRING)) {
                IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                ASDSetExistingBindingAction action = new ASDSetExistingBindingAction(part);
                action.setIEndPoint((IEndPoint)this.getModel());
                action.run();
            } else if (item.equals(NEW_STRING)) {
                IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                ASDSetNewBindingAction action = new ASDSetNewBindingAction(part);
                action.setIEndPoint((IEndPoint)this.getModel());
                action.run();
            }
        }
        this.refresh();
    }

    @Override
    public boolean shouldUseExtraSpace() {
        return false;
    }

    @Override
    public void doHandleEvent(Event event) {
        if (event.widget == this.addressText && !this.addressText.isDisposed()) {
            String oldAddress;
            String newAddress = this.addressText.getText();
            if (newAddress == null) {
                newAddress = "";
            }
            if ((oldAddress = this.getOldAddress()).equals(newAddress)) {
                return;
            }
            IEndPoint endPoint = (IEndPoint)this.getModel();
            Command command = endPoint.getSetAddressCommand(newAddress);
            this.executeCommand(command);
        } else if (event.widget == this.protocolCombo && !this.protocolCombo.isDisposed()) {
            String newProtocol = this.protocolCombo.getText();
            ContentGeneratorUIExtensionRegistry registry = WSDLEditorPlugin.getInstance().getContentGeneratorUIExtensionRegistry();
            ContentGeneratorUIExtension ext = registry.getExtensionForLabel(newProtocol);
            if (ext != null) {
                newProtocol = ext.getName();
            }
            if (newProtocol != null && this.getModel() instanceof W11EndPoint) {
                W11EndPoint endPoint = (W11EndPoint)this.getModel();
                String oldProtocol = this.getOldProtocol(endPoint);
                if (oldProtocol.equals(newProtocol)) {
                    return;
                }
                endPoint.setProtocol(newProtocol);
            }
        } else {
            super.doHandleEvent(event);
        }
    }

    private String getOldAddress() {
        String value = null;
        if (this.getModel() instanceof W11EndPoint) {
            value = ((W11EndPoint)this.getModel()).getAddress();
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    private String getOldProtocol(W11EndPoint endPoint) {
        String value = null;
        value = endPoint.getProtocol();
        if (value == null) {
            value = "";
        }
        return value;
    }
}

