/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModelStatus;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementDelta;
import org.eclipse.wst.jsdt.internal.core.JavaModelOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public abstract class CreateElementInCUOperation
extends JavaModelOperation {
    protected JavaScriptUnit cuAST;
    protected static final int INSERT_LAST = 1;
    protected static final int INSERT_AFTER = 2;
    protected static final int INSERT_BEFORE = 3;
    protected int insertionPolicy = 1;
    protected IJavaScriptElement anchorElement = null;
    protected boolean creationOccurred = true;

    public CreateElementInCUOperation(IJavaScriptElement parentElement) {
        super(null, new IJavaScriptElement[]{parentElement});
        this.initializeDefaultPosition();
    }

    protected void apply(ASTRewrite rewriter, IDocument document, Map options) throws JavaScriptModelException {
        TextEdit edits = rewriter.rewriteAST(document, options);
        try {
            edits.apply(document);
        }
        catch (BadLocationException e) {
            throw new JavaScriptModelException(e, 984);
        }
    }

    @Override
    protected void checkCanceled() {
        if (!this.isNested) {
            super.checkCanceled();
        }
    }

    public void createAfter(IJavaScriptElement sibling) {
        this.setRelativePosition(sibling, 2);
    }

    public void createBefore(IJavaScriptElement sibling) {
        this.setRelativePosition(sibling, 3);
    }

    @Override
    protected void executeOperation() throws JavaScriptModelException {
        try {
            this.beginTask(this.getMainTaskName(), this.getMainAmountOfWork());
            JavaElementDelta delta = this.newJavaElementDelta();
            IJavaScriptUnit unit = this.getCompilationUnit();
            this.generateNewCompilationUnitAST(unit);
            if (this.creationOccurred) {
                unit.save(null, false);
                boolean isWorkingCopy = unit.isWorkingCopy();
                if (!isWorkingCopy) {
                    CreateElementInCUOperation.setAttribute("hasModifiedResource", "true");
                }
                this.worked(1);
                this.resultElements = this.generateResultHandles();
                if (!isWorkingCopy && !Util.isExcluded(unit) && unit.getParent().exists()) {
                    int i = 0;
                    while (i < this.resultElements.length) {
                        delta.added(this.resultElements[i]);
                        ++i;
                    }
                    this.addDelta(delta);
                }
            }
        }
        finally {
            this.done();
        }
    }

    protected abstract StructuralPropertyDescriptor getChildPropertyDescriptor(ASTNode var1);

    protected abstract ASTNode generateElementAST(ASTRewrite var1, IDocument var2, IJavaScriptUnit var3) throws JavaScriptModelException;

    protected void generateNewCompilationUnitAST(IJavaScriptUnit cu) throws JavaScriptModelException {
        IDocument document;
        this.cuAST = this.parse(cu);
        AST ast = this.cuAST.getAST();
        ASTRewrite rewriter = ASTRewrite.create(ast);
        ASTNode child = this.generateElementAST(rewriter, document = this.getDocument(cu), cu);
        if (child != null) {
            ASTNode parent = ((JavaElement)this.getParentElement()).findNode(this.cuAST);
            if (parent == null) {
                parent = this.cuAST;
            }
            this.insertASTNode(rewriter, parent, child);
            this.apply(rewriter, document, cu.getJavaScriptProject().getOptions(true));
        }
        this.worked(1);
    }

    protected abstract IJavaScriptElement generateResultHandle();

    protected IJavaScriptElement[] generateResultHandles() {
        return new IJavaScriptElement[]{this.generateResultHandle()};
    }

    protected IJavaScriptUnit getCompilationUnit() {
        return this.getCompilationUnitFor(this.getParentElement());
    }

    protected int getMainAmountOfWork() {
        return 2;
    }

    public abstract String getMainTaskName();

    @Override
    protected ISchedulingRule getSchedulingRule() {
        IResource resource = this.getCompilationUnit().getResource();
        IWorkspace workspace = resource.getWorkspace();
        return workspace.getRuleFactory().modifyRule(resource);
    }

    protected void initializeDefaultPosition() {
    }

    protected void insertASTNode(ASTRewrite rewriter, ASTNode parent, ASTNode child) throws JavaScriptModelException {
        StructuralPropertyDescriptor propertyDescriptor = this.getChildPropertyDescriptor(parent);
        if (propertyDescriptor instanceof ChildListPropertyDescriptor) {
            ChildListPropertyDescriptor childListPropertyDescriptor = (ChildListPropertyDescriptor)propertyDescriptor;
            ListRewrite rewrite = rewriter.getListRewrite(parent, childListPropertyDescriptor);
            switch (this.insertionPolicy) {
                case 3: {
                    ASTNode element = ((JavaElement)this.anchorElement).findNode(this.cuAST);
                    if (childListPropertyDescriptor.getElementType().isAssignableFrom(element.getClass())) {
                        rewrite.insertBefore(child, element, null);
                        break;
                    }
                    rewrite.insertLast(child, null);
                    break;
                }
                case 2: {
                    ASTNode element = ((JavaElement)this.anchorElement).findNode(this.cuAST);
                    if (childListPropertyDescriptor.getElementType().isAssignableFrom(element.getClass())) {
                        rewrite.insertAfter(child, element, null);
                        break;
                    }
                    rewrite.insertLast(child, null);
                    break;
                }
                case 1: {
                    rewrite.insertLast(child, null);
                }
            }
        } else {
            rewriter.set(parent, propertyDescriptor, child, null);
        }
    }

    protected JavaScriptUnit parse(IJavaScriptUnit cu) throws JavaScriptModelException {
        cu.makeConsistent(this.progressMonitor);
        ASTParser parser = ASTParser.newParser(3);
        parser.setSource(cu);
        return (JavaScriptUnit)parser.createAST(this.progressMonitor);
    }

    protected void setAlteredName(String newName) {
    }

    protected void setRelativePosition(IJavaScriptElement sibling, int policy) throws IllegalArgumentException {
        if (sibling == null) {
            this.anchorElement = null;
            this.insertionPolicy = 1;
        } else {
            this.anchorElement = sibling;
            this.insertionPolicy = policy;
        }
    }

    @Override
    public IJavaScriptModelStatus verify() {
        if (this.getParentElement() == null) {
            return new JavaModelStatus(968);
        }
        if (this.anchorElement != null) {
            IJavaScriptElement domPresentParent = this.anchorElement.getParent();
            if (domPresentParent.getElementType() == 12) {
                domPresentParent = domPresentParent.getParent();
            }
            if (domPresentParent.getElementType() == 15) {
                domPresentParent = domPresentParent.getParent();
            }
            if (!domPresentParent.equals(this.getParentElement())) {
                return new JavaModelStatus(993, this.anchorElement);
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

