/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.wst.jsdt.core.CompletionRequestor;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IBufferFactory;
import org.eclipse.wst.jsdt.core.IExportContainer;
import org.eclipse.wst.jsdt.core.IExportDeclaration;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IImportContainer;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IProblemRequestor;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.ASTHolderCUInfo;
import org.eclipse.wst.jsdt.internal.core.BecomeWorkingCopyOperation;
import org.eclipse.wst.jsdt.internal.core.BufferFactoryWrapper;
import org.eclipse.wst.jsdt.internal.core.BufferManager;
import org.eclipse.wst.jsdt.internal.core.CommitWorkingCopyOperation;
import org.eclipse.wst.jsdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.wst.jsdt.internal.core.CompilationUnitStructureRequestor;
import org.eclipse.wst.jsdt.internal.core.CompilationUnitStructureVisitor;
import org.eclipse.wst.jsdt.internal.core.CreateCompilationUnitOperation;
import org.eclipse.wst.jsdt.internal.core.CreateExportOperation;
import org.eclipse.wst.jsdt.internal.core.CreateFieldOperation;
import org.eclipse.wst.jsdt.internal.core.CreateImportOperation;
import org.eclipse.wst.jsdt.internal.core.CreateMethodOperation;
import org.eclipse.wst.jsdt.internal.core.CreateTypeOperation;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.DiscardWorkingCopyOperation;
import org.eclipse.wst.jsdt.internal.core.ExportContainer;
import org.eclipse.wst.jsdt.internal.core.IVirtualParent;
import org.eclipse.wst.jsdt.internal.core.ImportContainer;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaElementInfo;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.LocalVariable;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.ReconcileWorkingCopyOperation;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.SourceField;
import org.eclipse.wst.jsdt.internal.core.SourceMethod;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;
import org.eclipse.wst.jsdt.internal.core.SourceType;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CompilationUnit
extends Openable
implements IJavaScriptUnit,
ICompilationUnit,
SuffixConstants,
IVirtualParent {
    static final int JLS2_INTERNAL = 2;
    private static final IImportDeclaration[] NO_IMPORTS = new IImportDeclaration[0];
    private static final IExportDeclaration[] NO_EXPORTS = new IExportDeclaration[0];
    protected String name;
    public WorkingCopyOwner owner;
    public String superTypeName;
    private volatile boolean fIsMakingConsistent;

    public CompilationUnit(PackageFragment parent, String name, String superTypeName, WorkingCopyOwner owner) {
        super(parent);
        this.name = name;
        this.owner = owner;
        this.superTypeName = superTypeName;
        this.fIsMakingConsistent = false;
    }

    public CompilationUnit(PackageFragment parent, String name, WorkingCopyOwner owner) {
        this(parent, name, null, owner);
    }

    @Override
    public void becomeWorkingCopy(IProblemRequestor problemRequestor, IProgressMonitor monitor) throws JavaScriptModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(this, false, true, null);
        if (perWorkingCopyInfo == null) {
            this.close();
            BecomeWorkingCopyOperation operation = new BecomeWorkingCopyOperation(this, problemRequestor);
            operation.runOperation(monitor);
        }
    }

    @Override
    public void becomeWorkingCopy(IProgressMonitor monitor) throws JavaScriptModelException {
        IProblemRequestor requestor = this.owner == null ? null : this.owner.getProblemRequestor(this);
        this.becomeWorkingCopy(requestor, monitor);
    }

    @Override
    protected boolean buildStructure(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaScriptModelException {
        IStatus status;
        if (!this.isWorkingCopy() && !(status = this.validateCompilationUnit(underlyingResource)).isOK()) {
            throw this.newJavaModelException(status);
        }
        if (!this.isPrimary() && this.getPerWorkingCopyInfo() == null) {
            throw this.newNotPresentException();
        }
        CompilationUnitElementInfo unitInfo = (CompilationUnitElementInfo)info;
        IBuffer buffer = this.getBufferManager().getBuffer(this);
        if (buffer == null) {
            buffer = this.openBuffer(pm, unitInfo);
        }
        if (buffer == null) {
        } else {
            char[] characters = buffer.getCharacters();
            char[] cArray = characters == null ? CharOperation.NO_CHAR : characters;
        }
        new CompilationUnitStructureRequestor(this, unitInfo, newElements);
        CompilationUnitStructureVisitor visitor = new CompilationUnitStructureVisitor(this, unitInfo, newElements);
        ASTParser parser = ASTParser.newParser(3);
        parser.setSource(this);
        JavaScriptUnit cu = (JavaScriptUnit)parser.createAST(pm);
        if (cu != null) {
            cu.accept(visitor);
        }
        if (info instanceof ASTHolderCUInfo) {
            ((ASTHolderCUInfo)info).ast = cu;
        }
        if (underlyingResource == null) {
            underlyingResource = this.getResource();
        }
        if (underlyingResource != null) {
            unitInfo.timestamp = ((IFile)underlyingResource).getModificationStamp();
        }
        return unitInfo.isStructureKnown();
    }

    @Override
    public boolean canBeRemovedFromCache() {
        if (this.getPerWorkingCopyInfo() != null) {
            return false;
        }
        return super.canBeRemovedFromCache();
    }

    @Override
    public boolean canBufferBeRemovedFromCache(IBuffer buffer) {
        if (this.getPerWorkingCopyInfo() != null) {
            return false;
        }
        return super.canBufferBeRemovedFromCache(buffer);
    }

    @Override
    public void close() throws JavaScriptModelException {
        if (this.getPerWorkingCopyInfo() != null) {
            return;
        }
        super.close();
    }

    @Override
    protected void closing(Object info) {
        if (this.getPerWorkingCopyInfo() == null) {
            super.closing(info);
        }
    }

    @Override
    public void codeComplete(int offset, CompletionRequestor requestor) throws JavaScriptModelException {
        this.codeComplete(offset, requestor, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public void codeComplete(int offset, CompletionRequestor requestor, WorkingCopyOwner workingCopyOwner) throws JavaScriptModelException {
        this.codeComplete(this, this.isWorkingCopy() ? (ICompilationUnit)((Object)this.getOriginalElement()) : this, offset, requestor, workingCopyOwner);
    }

    @Override
    public IJavaScriptElement[] codeSelect(int offset, int length) throws JavaScriptModelException {
        return this.codeSelect(offset, length, DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public IJavaScriptElement[] codeSelect(int offset, int length, WorkingCopyOwner workingCopyOwner) throws JavaScriptModelException {
        return super.codeSelect(this, offset, length, workingCopyOwner);
    }

    public void commit(boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        this.commitWorkingCopy(force, monitor);
    }

    @Override
    public void commitWorkingCopy(boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        CommitWorkingCopyOperation op = new CommitWorkingCopyOperation(this, force);
        op.runOperation(monitor);
    }

    @Override
    public void copy(IJavaScriptElement container, IJavaScriptElement sibling, String rename, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        if (container == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this};
        IJavaScriptElement[] containers = new IJavaScriptElement[]{container};
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getJavaScriptModel().copy(elements, containers, null, renamings, force, monitor);
    }

    @Override
    protected Object createElementInfo() {
        return new CompilationUnitElementInfo();
    }

    @Override
    public IImportDeclaration createImport(String importName, IJavaScriptElement sibling, IProgressMonitor monitor) throws JavaScriptModelException {
        return this.createImport(importName, sibling, 0, monitor);
    }

    @Override
    public IImportDeclaration createImport(String importName, IJavaScriptElement sibling, int flags, IProgressMonitor monitor) throws JavaScriptModelException {
        CreateImportOperation op = new CreateImportOperation(importName, this, flags);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return this.getImport(importName);
    }

    public IExportDeclaration createExport(String exportName, IJavaScriptElement sibling, IProgressMonitor monitor) throws JavaScriptModelException {
        return this.createExport(exportName, sibling, 0, monitor);
    }

    public IExportDeclaration createExport(String exportName, IJavaScriptElement sibling, int flags, IProgressMonitor monitor) throws JavaScriptModelException {
        CreateExportOperation op = new CreateExportOperation(exportName, this, flags);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return this.getExport(exportName);
    }

    @Override
    public IType createType(String content, IJavaScriptElement sibling, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        if (!this.exists()) {
            IPackageFragment pkg = (IPackageFragment)this.getParent();
            String source = "";
            if (!pkg.isDefaultPackage()) {
                String lineSeparator = Util.getLineSeparator(null, this.getJavaScriptProject());
                source = "package " + pkg.getElementName() + ";" + lineSeparator + lineSeparator;
            }
            CreateCompilationUnitOperation op = new CreateCompilationUnitOperation(pkg, this.name, source, force);
            op.runOperation(monitor);
        }
        CreateTypeOperation op = new CreateTypeOperation(this, content, force);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return (IType)op.getResultElements()[0];
    }

    @Override
    public void delete(boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this};
        this.getJavaScriptModel().delete(elements, force, monitor);
    }

    public void destroy() {
        block2: {
            try {
                this.discardWorkingCopy();
            }
            catch (JavaScriptModelException e) {
                if (!JavaModelManager.VERBOSE) break block2;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void discardWorkingCopy() throws JavaScriptModelException {
        DiscardWorkingCopyOperation op = new DiscardWorkingCopyOperation(this);
        op.runOperation(null);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof CompilationUnit)) {
            return false;
        }
        CompilationUnit other = (CompilationUnit)obj;
        return this.owner.equals(other.owner) && super.equals(obj);
    }

    @Override
    public boolean exists() {
        if (this.getPerWorkingCopyInfo() != null) {
            return true;
        }
        return this.isPrimary() && this.validateCompilationUnit(this.getResource()).isOK();
    }

    @Override
    public IJavaScriptElement[] findElements(IJavaScriptElement element) {
        ArrayList<IJavaScriptElement> children = new ArrayList<IJavaScriptElement>();
        while (element != null && element.getElementType() != 5) {
            children.add(element);
            element = element.getParent();
        }
        if (element == null) {
            return null;
        }
        ISourceReference currentElement = this;
        int i = children.size() - 1;
        while (i >= 0) {
            SourceRefElement child = (SourceRefElement)children.get(i);
            switch (child.getElementType()) {
                case 12: {
                    currentElement = ((IJavaScriptUnit)currentElement).getImportContainer();
                    break;
                }
                case 13: {
                    currentElement = ((IImportContainer)currentElement).getImport(child.getElementName());
                    break;
                }
                case 15: {
                    currentElement = ((IJavaScriptUnit)currentElement).getExportContainer();
                    break;
                }
                case 16: {
                    currentElement = ((IExportContainer)currentElement).getExport(child.getElementName());
                    break;
                }
                case 7: {
                    switch (currentElement.getElementType()) {
                        case 5: {
                            currentElement = ((IJavaScriptUnit)currentElement).getType(child.getElementName());
                            break;
                        }
                        case 7: {
                            currentElement = ((IType)currentElement).getType(child.getElementName());
                            break;
                        }
                        case 8: 
                        case 9: 
                        case 10: {
                            currentElement = ((IMember)currentElement).getType(child.getElementName(), child.occurrenceCount);
                        }
                    }
                    break;
                }
                case 10: {
                    currentElement = ((IType)currentElement).getInitializer(child.occurrenceCount);
                    break;
                }
                case 8: {
                    if (currentElement instanceof CompilationUnit) {
                        currentElement = currentElement.getField(child.getElementName());
                        break;
                    }
                    if (!(currentElement instanceof IType)) break;
                    currentElement = ((IType)currentElement).getField(child.getElementName());
                    break;
                }
                case 9: {
                    currentElement = currentElement instanceof CompilationUnit ? currentElement.getFunction(child.getElementName(), ((IFunction)((Object)child)).getParameterTypes()) : (currentElement instanceof SourceMethod ? ((SourceMethod)currentElement).getFunction(child.getElementName(), ((IFunction)((Object)child)).getParameterTypes()) : ((IType)currentElement).getFunction(child.getElementName(), ((IFunction)((Object)child)).getParameterTypes()));
                }
            }
            --i;
        }
        if (currentElement != null && currentElement.exists()) {
            return new IJavaScriptElement[]{currentElement};
        }
        return null;
    }

    @Override
    public IType findPrimaryType() {
        String typeName = Util.getNameWithoutJavaLikeExtension(this.getElementName());
        IType primaryType = this.getType(typeName);
        if (primaryType.exists()) {
            return primaryType;
        }
        return null;
    }

    public IJavaScriptElement findSharedWorkingCopy(IBufferFactory factory) {
        if (factory == null) {
            factory = this.getBufferManager().getDefaultBufferFactory();
        }
        return this.findWorkingCopy(BufferFactoryWrapper.create(factory));
    }

    @Override
    public IJavaScriptUnit findWorkingCopy(WorkingCopyOwner workingCopyOwner) {
        CompilationUnit cu = new CompilationUnit((PackageFragment)this.parent, this.getElementName(), workingCopyOwner);
        if (workingCopyOwner == DefaultWorkingCopyOwner.PRIMARY) {
            return cu;
        }
        JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo = cu.getPerWorkingCopyInfo();
        if (perWorkingCopyInfo != null) {
            return perWorkingCopyInfo.getWorkingCopy();
        }
        return null;
    }

    @Override
    public IType[] getAllTypes() throws JavaScriptModelException {
        IType[] types = this.getTypes();
        ArrayList<IType> allTypes = new ArrayList<IType>(types.length);
        ArrayList<IType> typesToTraverse = new ArrayList<IType>(types.length);
        int i = 0;
        while (i < types.length) {
            typesToTraverse.add(types[i]);
            ++i;
        }
        while (!typesToTraverse.isEmpty()) {
            IType type = (IType)typesToTraverse.get(0);
            typesToTraverse.remove(type);
            allTypes.add(type);
            types = type.getTypes();
            i = 0;
            while (i < types.length) {
                typesToTraverse.add(types[i]);
                ++i;
            }
        }
        IType[] arrayOfAllTypes = new IType[allTypes.size()];
        allTypes.toArray(arrayOfAllTypes);
        return arrayOfAllTypes;
    }

    @Override
    public IJavaScriptUnit getCompilationUnit() {
        return this.getJavaScriptUnit();
    }

    @Override
    public IJavaScriptUnit getJavaScriptUnit() {
        return this;
    }

    @Override
    public char[] getContents() {
        IBuffer buffer = this.getBufferManager().getBuffer(this);
        if (buffer != null) {
            char[] contents = buffer.getCharacters();
            return contents == null ? CharOperation.NO_CHAR : contents;
        }
        try {
            IResource resource = this.getResource();
            if (resource instanceof IFile) {
                return Util.getResourceContentsAsCharArray((IFile)resource);
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        return CharOperation.NO_CHAR;
    }

    @Override
    public IResource getCorrespondingResource() throws JavaScriptModelException {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null || root.isArchive()) {
            return null;
        }
        return this.getUnderlyingResource();
    }

    @Override
    public IJavaScriptElement getElementAt(int position) throws JavaScriptModelException {
        IJavaScriptElement e = this.getSourceElementAt(position);
        if (e == this) {
            return null;
        }
        return e;
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    @Override
    public int getElementType() {
        return 5;
    }

    @Override
    public char[] getFileName() {
        if (this.name.startsWith("http:")) {
            return this.name.toCharArray();
        }
        return this.getPath().toString().toCharArray();
    }

    @Override
    public IJavaScriptElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner workingCopyOwner) {
        switch (token.charAt(0)) {
            case '#': {
                JavaElement container = (JavaElement)((Object)this.getImportContainer());
                return container.getHandleFromMemento(token, memento, workingCopyOwner);
            }
            case '[': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeName = memento.nextToken();
                JavaElement type = (JavaElement)((Object)this.getType(typeName));
                return type.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '^': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String fieldName = memento.nextToken();
                JavaElement field = (JavaElement)((Object)this.getField(fieldName));
                return field.getHandleFromMemento(memento, workingCopyOwner);
            }
            case '@': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String varName = memento.nextToken();
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                memento.nextToken();
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                int declarationStart = Integer.parseInt(memento.nextToken());
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                memento.nextToken();
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                int declarationEnd = Integer.parseInt(memento.nextToken());
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                memento.nextToken();
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                int nameStart = Integer.parseInt(memento.nextToken());
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                memento.nextToken();
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                int nameEnd = Integer.parseInt(memento.nextToken());
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                memento.nextToken();
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String typeSignature = memento.nextToken();
                return new LocalVariable(this, varName, declarationStart, declarationEnd, nameStart, nameEnd, typeSignature);
            }
            case '~': {
                if (!memento.hasMoreTokens()) {
                    return this;
                }
                String selector = memento.nextToken();
                ArrayList params = new ArrayList();
                if (memento.hasMoreTokens()) {
                    token = memento.nextToken();
                    switch (token.charAt(0)) {
                        case '[': 
                        case ']': {
                            break;
                        }
                    }
                }
                String[] parameters = new String[params.size()];
                params.toArray(parameters);
                JavaElement method = (JavaElement)((Object)this.getFunction(selector, parameters));
                if (token.charAt(0) == '!') {
                    if (!memento.hasMoreTokens()) {
                        return method;
                    }
                    memento.nextToken();
                    if (!memento.hasMoreTokens()) {
                        return method;
                    }
                    token = memento.nextToken();
                }
                switch (token.charAt(0)) {
                    case '@': 
                    case '[': 
                    case ']': {
                        return method.getHandleFromMemento(token, memento, workingCopyOwner);
                    }
                    case '~': {
                        if (!memento.hasMoreTokens()) break;
                        return method.getHandleFromMemento(token, memento, workingCopyOwner);
                    }
                }
                return method;
            }
        }
        return null;
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '{';
    }

    @Override
    public IImportDeclaration getImport(String importName) {
        return this.getImportContainer().getImport(importName);
    }

    @Override
    public IImportContainer getImportContainer() {
        return new ImportContainer(this);
    }

    @Override
    public IImportDeclaration[] getImports() throws JavaScriptModelException {
        IImportContainer container = this.getImportContainer();
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        Object info = manager.getInfo(container);
        if (info == null) {
            if (manager.getInfo(this) != null) {
                return NO_IMPORTS;
            }
            this.open(null);
            info = manager.getInfo(container);
            if (info == null) {
                return NO_IMPORTS;
            }
        }
        IJavaScriptElement[] elements = ((JavaElementInfo)info).children;
        int length = elements.length;
        IImportDeclaration[] imports = new IImportDeclaration[length];
        System.arraycopy(elements, 0, imports, 0, length);
        return imports;
    }

    @Override
    public IExportDeclaration getExport(String exportName) {
        return this.getExportContainer().getExport(exportName);
    }

    @Override
    public IExportContainer getExportContainer() {
        return new ExportContainer(this);
    }

    @Override
    public IExportDeclaration[] getExports() throws JavaScriptModelException {
        IExportContainer container = this.getExportContainer();
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        Object info = manager.getInfo(container);
        if (info == null) {
            if (manager.getInfo(this) != null) {
                return NO_EXPORTS;
            }
            this.open(null);
            info = manager.getInfo(container);
            if (info == null) {
                return NO_EXPORTS;
            }
        }
        IJavaScriptElement[] elements = ((JavaElementInfo)info).children;
        int length = elements.length;
        IExportDeclaration[] exports = new IExportDeclaration[length];
        System.arraycopy(elements, 0, exports, 0, length);
        return exports;
    }

    public ITypeRoot getTypeRoot() {
        return this;
    }

    @Override
    public char[] getMainTypeName() {
        return Util.getNameWithoutJavaLikeExtension(this.getElementName()).toCharArray();
    }

    public IJavaScriptElement getOriginal(IJavaScriptElement workingCopyElement) {
        if (!this.isWorkingCopy()) {
            return null;
        }
        CompilationUnit cu = (CompilationUnit)workingCopyElement.getAncestor(5);
        if (cu == null || !this.owner.equals(cu.owner)) {
            return null;
        }
        return workingCopyElement.getPrimaryElement();
    }

    public IJavaScriptElement getOriginalElement() {
        if (!this.isWorkingCopy()) {
            return null;
        }
        return this.getPrimaryElement();
    }

    @Override
    public WorkingCopyOwner getOwner() {
        return this.isPrimary() || !this.isWorkingCopy() ? null : this.owner;
    }

    @Override
    public char[][] getPackageName() {
        PackageFragment packageFragment = (PackageFragment)this.getParent();
        if (packageFragment == null) {
            return CharOperation.NO_CHAR_CHAR;
        }
        return Util.toCharArrays(packageFragment.names);
    }

    @Override
    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return new Path(this.getElementName());
        }
        if (root.isArchive()) {
            return root.getPath();
        }
        return this.getParent().getPath().append(this.getElementName());
    }

    public JavaModelManager.PerWorkingCopyInfo getPerWorkingCopyInfo() {
        return JavaModelManager.getJavaModelManager().getPerWorkingCopyInfo(this, false, false, null);
    }

    @Override
    public IJavaScriptUnit getPrimary() {
        return (IJavaScriptUnit)this.getPrimaryElement(true);
    }

    @Override
    public IJavaScriptElement getPrimaryElement(boolean checkOwner) {
        if (checkOwner && this.isPrimary()) {
            return this;
        }
        return new CompilationUnit((PackageFragment)this.getParent(), this.getElementName(), DefaultWorkingCopyOwner.PRIMARY);
    }

    @Override
    public IResource getResource() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null) {
            return null;
        }
        if (root.isArchive()) {
            return root.getResource();
        }
        IContainer parentResource = (IContainer)this.getParent().getResource();
        if (parentResource != null) {
            return parentResource.getFile((IPath)new Path(this.getElementName()));
        }
        return null;
    }

    @Override
    public String getSource() throws JavaScriptModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return "";
        }
        return buffer.getContents();
    }

    @Override
    public ISourceRange getSourceRange() throws JavaScriptModelException {
        return ((CompilationUnitElementInfo)this.getElementInfo()).getSourceRange();
    }

    @Override
    public IType getType(String typeName) {
        return new SourceType(this, typeName);
    }

    @Override
    public IType[] getTypes() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(7);
        IType[] array = new IType[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public IResource getUnderlyingResource() throws JavaScriptModelException {
        if (this.isWorkingCopy() && !this.isPrimary()) {
            return null;
        }
        return super.getUnderlyingResource();
    }

    public IJavaScriptElement getSharedWorkingCopy(IProgressMonitor pm, IBufferFactory factory, IProblemRequestor problemRequestor) throws JavaScriptModelException {
        if (factory == null) {
            factory = this.getBufferManager().getDefaultBufferFactory();
        }
        return this.getWorkingCopy(BufferFactoryWrapper.create(factory), problemRequestor, pm);
    }

    public IJavaScriptElement getWorkingCopy() throws JavaScriptModelException {
        return this.getWorkingCopy(null);
    }

    @Override
    public IJavaScriptUnit getWorkingCopy(IProgressMonitor monitor) throws JavaScriptModelException {
        return this.getWorkingCopy(new WorkingCopyOwner(){}, null, monitor);
    }

    @Override
    public IJavaScriptUnit getWorkingCopy(WorkingCopyOwner workingCopyOwner, IProgressMonitor monitor) throws JavaScriptModelException {
        return this.getWorkingCopy(workingCopyOwner, null, monitor);
    }

    public IJavaScriptElement getWorkingCopy(IProgressMonitor monitor, IBufferFactory factory, IProblemRequestor problemRequestor) throws JavaScriptModelException {
        return this.getWorkingCopy(BufferFactoryWrapper.create(factory), problemRequestor, monitor);
    }

    @Override
    public IJavaScriptUnit getWorkingCopy(WorkingCopyOwner workingCopyOwner, IProblemRequestor problemRequestor, IProgressMonitor monitor) throws JavaScriptModelException {
        CompilationUnit workingCopy;
        if (!this.isPrimary()) {
            return this;
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        JavaModelManager.PerWorkingCopyInfo perWorkingCopyInfo = manager.getPerWorkingCopyInfo(workingCopy = new CompilationUnit((PackageFragment)this.getParent(), this.getElementName(), this.superTypeName, workingCopyOwner), false, true, null);
        if (perWorkingCopyInfo != null) {
            return perWorkingCopyInfo.getWorkingCopy();
        }
        BecomeWorkingCopyOperation op = new BecomeWorkingCopyOperation(workingCopy, problemRequestor);
        op.runOperation(monitor);
        return workingCopy;
    }

    @Override
    protected boolean hasBuffer() {
        return true;
    }

    @Override
    public boolean hasResourceChanged() {
        if (!this.isWorkingCopy()) {
            return false;
        }
        Object info = JavaModelManager.getJavaModelManager().getInfo(this);
        if (info == null) {
            return false;
        }
        IResource resource = this.getResource();
        if (resource == null) {
            return false;
        }
        return ((CompilationUnitElementInfo)info).timestamp != resource.getModificationStamp();
    }

    public boolean isBasedOn(IResource resource) {
        if (!this.isWorkingCopy()) {
            return false;
        }
        if (!this.getResource().equals((Object)resource)) {
            return false;
        }
        return !this.hasResourceChanged();
    }

    @Override
    public boolean isConsistent() {
        return !JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().contains(this);
    }

    public boolean isPrimary() {
        return this.owner == DefaultWorkingCopyOwner.PRIMARY;
    }

    @Override
    protected boolean isSourceElement() {
        return true;
    }

    protected IStatus validateCompilationUnit(IResource resource) {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (resource != null) {
            char[][] exclusionPatterns;
            char[][] inclusionPatterns = root.fullInclusionPatternChars();
            if (Util.isExcluded(resource, inclusionPatterns, exclusionPatterns = root.fullExclusionPatternChars())) {
                return new JavaModelStatus(1006, this);
            }
            if (!resource.isAccessible()) {
                return new JavaModelStatus(969, this);
            }
        }
        IJavaScriptProject project = this.getJavaScriptProject();
        return JavaScriptConventions.validateCompilationUnitName(this.getElementName(), project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true), project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true));
    }

    @Override
    public boolean isWorkingCopy() {
        return !this.isPrimary() || this.getPerWorkingCopyInfo() != null;
    }

    @Override
    public void makeConsistent(IProgressMonitor monitor) throws JavaScriptModelException {
        this.makeConsistent(0, false, 0, null, monitor);
    }

    public JavaScriptUnit makeConsistent(int astLevel, boolean resolveBindings, int reconcileFlags, HashMap problems, IProgressMonitor monitor) throws JavaScriptModelException {
        if (this.isConsistent() || this.fIsMakingConsistent) {
            return null;
        }
        this.fIsMakingConsistent = true;
        try {
            if (astLevel != 0 || problems != null) {
                ASTHolderCUInfo info = new ASTHolderCUInfo();
                info.astLevel = astLevel;
                info.resolveBindings = resolveBindings;
                info.reconcileFlags = reconcileFlags;
                info.problems = problems;
                this.openWhenClosed(info, monitor);
                JavaScriptUnit result = info.ast;
                info.ast = null;
                JavaScriptUnit javaScriptUnit = result;
                return javaScriptUnit;
            }
            this.openWhenClosed(this.createElementInfo(), monitor);
            return null;
        }
        finally {
            this.fIsMakingConsistent = false;
        }
    }

    @Override
    public void move(IJavaScriptElement container, IJavaScriptElement sibling, String rename, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        if (container == null) {
            throw new IllegalArgumentException(Messages.operation_nullContainer);
        }
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this};
        IJavaScriptElement[] containers = new IJavaScriptElement[]{container};
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getJavaScriptModel().move(elements, containers, null, renamings, force, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IBuffer openBuffer(IProgressMonitor pm, Object info) throws JavaScriptModelException {
        IBuffer buffer;
        BufferManager bufManager = this.getBufferManager();
        boolean isWorkingCopy = this.isWorkingCopy();
        IBuffer iBuffer = buffer = isWorkingCopy ? this.owner.createBuffer(this) : BufferManager.createBuffer(this);
        if (buffer == null) {
            return null;
        }
        BufferManager bufferManager = bufManager;
        synchronized (bufferManager) {
            IBuffer existingBuffer = bufManager.getBuffer(this);
            if (existingBuffer != null) {
                return existingBuffer;
            }
            if (buffer.getCharacters() == null) {
                if (isWorkingCopy) {
                    CompilationUnit original;
                    if (!this.isPrimary() && (original = new CompilationUnit((PackageFragment)this.getParent(), this.getElementName(), DefaultWorkingCopyOwner.PRIMARY)).isOpen()) {
                        buffer.setContents(original.getSource());
                    } else {
                        IFile file = (IFile)this.getResource();
                        if (file == null || !file.exists()) {
                            buffer.setContents(CharOperation.NO_CHAR);
                        } else {
                            buffer.setContents(Util.getResourceContentsAsCharArray(file));
                        }
                    }
                } else {
                    IFile file = (IFile)this.getResource();
                    if (file == null || !file.exists()) {
                        throw this.newNotPresentException();
                    }
                    buffer.setContents(Util.getResourceContentsAsCharArray(file));
                }
            }
            bufManager.addBuffer(buffer);
            buffer.addBufferChangedListener(this);
        }
        return buffer;
    }

    @Override
    protected void openParent(Object childInfo, HashMap newElements, IProgressMonitor pm) throws JavaScriptModelException {
        if (!this.isWorkingCopy()) {
            super.openParent(childInfo, newElements, pm);
        }
    }

    public IMarker[] reconcile() throws JavaScriptModelException {
        this.reconcile(0, false, false, null, null);
        return null;
    }

    public void reconcile(boolean forceProblemDetection, IProgressMonitor monitor) throws JavaScriptModelException {
        this.reconcile(0, forceProblemDetection ? 1 : 0, null, monitor);
    }

    @Override
    public JavaScriptUnit reconcile(int astLevel, boolean forceProblemDetection, WorkingCopyOwner workingCopyOwner, IProgressMonitor monitor) throws JavaScriptModelException {
        return this.reconcile(astLevel, forceProblemDetection, false, workingCopyOwner, monitor);
    }

    @Override
    public JavaScriptUnit reconcile(int astLevel, boolean forceProblemDetection, boolean enableStatementsRecovery, WorkingCopyOwner workingCopyOwner, IProgressMonitor monitor) throws JavaScriptModelException {
        int flags = 0;
        if (forceProblemDetection) {
            flags |= 1;
        }
        if (enableStatementsRecovery) {
            flags |= 2;
        }
        return this.reconcile(astLevel, flags, workingCopyOwner, monitor);
    }

    @Override
    public JavaScriptUnit reconcile(int astLevel, int reconcileFlags, WorkingCopyOwner workingCopyOwner, IProgressMonitor monitor) throws JavaScriptModelException {
        if (!this.isWorkingCopy()) {
            return null;
        }
        if (workingCopyOwner == null) {
            workingCopyOwner = DefaultWorkingCopyOwner.PRIMARY;
        }
        PerformanceStats stats = null;
        if (ReconcileWorkingCopyOperation.PERF) {
            stats = PerformanceStats.getStats((String)"org.eclipse.wst.jsdt.core/perf/reconcile", (Object)this);
            stats.startRun(new String(this.getFileName()));
        }
        ReconcileWorkingCopyOperation op = new ReconcileWorkingCopyOperation(this, astLevel, reconcileFlags, workingCopyOwner);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            manager.cacheZipFiles();
            op.runOperation(monitor);
        }
        finally {
            manager.flushZipFiles();
        }
        if (ReconcileWorkingCopyOperation.PERF) {
            stats.endRun();
        }
        return op.ast;
    }

    @Override
    public void rename(String newName, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        if (newName == null) {
            throw new IllegalArgumentException(Messages.operation_nullName);
        }
        IJavaScriptElement[] elements = new IJavaScriptElement[]{this};
        IJavaScriptElement[] dests = new IJavaScriptElement[]{this.getParent()};
        String[] renamings = new String[]{newName};
        this.getJavaScriptModel().rename(elements, dests, renamings, force, monitor);
    }

    @Override
    public void restore() throws JavaScriptModelException {
        if (!this.isWorkingCopy()) {
            return;
        }
        CompilationUnit original = (CompilationUnit)this.getOriginalElement();
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return;
        }
        buffer.setContents(original.getContents());
        this.updateTimeStamp(original);
        this.makeConsistent(null);
    }

    @Override
    public void save(IProgressMonitor pm, boolean force) throws JavaScriptModelException {
        if (this.isWorkingCopy()) {
            this.reconcile();
        } else {
            super.save(pm, force);
        }
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        if (!this.isPrimary()) {
            buffer.append(this.tabString(tab));
            buffer.append("[Working copy] ");
            this.toStringName(buffer);
        } else if (this.isWorkingCopy()) {
            buffer.append(this.tabString(tab));
            buffer.append("[Working copy] ");
            this.toStringName(buffer);
            if (info == null) {
                buffer.append(" (not open)");
            }
        } else {
            super.toStringInfo(tab, buffer, info, showResolvedInfo);
        }
    }

    protected void updateTimeStamp(CompilationUnit original) throws JavaScriptModelException {
        long timeStamp = ((IFile)original.getResource()).getModificationStamp();
        if (timeStamp == -1L) {
            throw new JavaScriptModelException(new JavaModelStatus(995));
        }
        ((CompilationUnitElementInfo)this.getElementInfo()).timestamp = timeStamp;
    }

    @Override
    public IField getField(String fieldName) {
        return new SourceField(this, fieldName);
    }

    @Override
    public IField[] getFields() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(8);
        IField[] array = new IField[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public IFunction getFunction(String selector, String[] parameterTypeSignatures) {
        return new SourceMethod(this, selector, parameterTypeSignatures);
    }

    public IFunction[] getMethods() throws JavaScriptModelException {
        return this.getFunctions();
    }

    @Override
    public IFunction[] getFunctions() throws JavaScriptModelException {
        ArrayList list = this.getChildrenOfType(9);
        IFunction[] array = new IFunction[list.size()];
        list.toArray(array);
        return array;
    }

    @Override
    public IField createField(String contents, IJavaScriptElement sibling, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        CreateFieldOperation op = new CreateFieldOperation(this, contents, force);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return (IField)op.getResultElements()[0];
    }

    @Override
    public IFunction createMethod(String contents, IJavaScriptElement sibling, boolean force, IProgressMonitor monitor) throws JavaScriptModelException {
        CreateMethodOperation op = new CreateMethodOperation(this, contents, force);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        op.runOperation(monitor);
        return (IFunction)op.getResultElements()[0];
    }

    @Override
    public String getDisplayName() {
        if (this.isVirtual()) {
            JsGlobalScopeContainerInitializer init = ((IVirtualParent)((Object)this.parent)).getContainerInitializer();
            if (init == null) {
                return super.getDisplayName();
            }
            return init.getDescription((IPath)new Path(this.getElementName()), this.getJavaScriptProject());
        }
        return super.getDisplayName();
    }

    @Override
    public URI getHostPath() {
        JsGlobalScopeContainerInitializer init;
        if (this.isVirtual() && (init = ((IVirtualParent)((Object)this.parent)).getContainerInitializer()) != null) {
            return init.getHostPath((IPath)new Path(this.getElementName()), this.getJavaScriptProject());
        }
        return null;
    }

    @Override
    public JsGlobalScopeContainerInitializer getContainerInitializer() {
        JsGlobalScopeContainerInitializer init = null;
        if (this.parent instanceof IVirtualParent) {
            init = ((IVirtualParent)((Object)this.parent)).getContainerInitializer();
        }
        return init;
    }

    @Override
    public LibrarySuperType getCommonSuperType() {
        IJavaScriptProject javaProject = this.getJavaScriptProject();
        if (javaProject != null && javaProject.exists()) {
            return javaProject.getCommonSuperType();
        }
        return null;
    }

    @Override
    public IFunction[] findFunctions(IFunction method) {
        ArrayList<IFunction> list = new ArrayList<IFunction>();
        try {
            IFunction[] methods = this.getFunctions();
            String elementName = method.getElementName();
            String parentName = method.getParent().getElementName();
            int i = 0;
            int length = methods.length;
            while (i < length) {
                IFunction existingMethod = methods[i];
                if (elementName.equals(existingMethod.getElementName()) && parentName.equals(existingMethod.getParent().getElementName())) {
                    list.add(existingMethod);
                } else {
                    IFunction nestedMethod = this.findNestedFunction(existingMethod, elementName, parentName);
                    if (nestedMethod != null) {
                        list.add(nestedMethod);
                    }
                }
                ++i;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        int size = list.size();
        if (size == 0) {
            return null;
        }
        IFunction[] result = new IFunction[size];
        list.toArray(result);
        return result;
    }

    public IFunction findNestedFunction(IFunction method, String elementName, String parentName) {
        try {
            if (method.hasChildren()) {
                ArrayList methods = ((JavaElement)((Object)method)).getChildrenOfType(9);
                for (IFunction childMethod : methods) {
                    if (elementName.equals(childMethod.getElementName()) && parentName.equals(childMethod.getParent().getElementName())) {
                        return childMethod;
                    }
                    IFunction nestedMethod = this.findNestedFunction(childMethod, elementName, parentName);
                    if (nestedMethod == null) continue;
                    return nestedMethod;
                }
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        return null;
    }

    @Override
    public String getInferenceID() {
        JsGlobalScopeContainerInitializer containerInitializer = this.getContainerInitializer();
        if (containerInitializer != null) {
            return containerInitializer.getInferenceID();
        }
        return null;
    }

    @Override
    public SearchableEnvironment newSearchableNameEnvironment(WorkingCopyOwner owner) throws JavaScriptModelException {
        SearchableEnvironment env = super.newSearchableNameEnvironment(owner);
        env.setCompilationUnit(this);
        return env;
    }
}

