/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.parser;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.Block;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Initializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.parser.Parser;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredBlock;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredField;
import org.eclipse.wst.jsdt.internal.compiler.parser.RecoveredType;
import org.eclipse.wst.jsdt.internal.compiler.parser.TerminalTokens;

public class RecoveredInitializer
extends RecoveredField
implements TerminalTokens {
    public RecoveredType[] localTypes;
    public int localTypeCount;
    public RecoveredBlock initializerBody;

    public RecoveredInitializer(FieldDeclaration fieldDeclaration, RecoveredElement parent, int bracketBalance) {
        this(fieldDeclaration, parent, bracketBalance, null);
    }

    public RecoveredInitializer(FieldDeclaration fieldDeclaration, RecoveredElement parent, int bracketBalance, Parser parser) {
        super(fieldDeclaration, parent, bracketBalance, parser);
        this.foundOpeningBrace = true;
    }

    @Override
    public RecoveredElement add(Block nestedBlockDeclaration, int bracketBalanceValue) {
        if (this.fieldDeclaration.declarationSourceEnd > 0 && nestedBlockDeclaration.sourceStart > this.fieldDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(nestedBlockDeclaration, bracketBalanceValue);
        }
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        this.initializerBody = new RecoveredBlock(nestedBlockDeclaration, (RecoveredElement)this, bracketBalanceValue);
        if (nestedBlockDeclaration.sourceEnd == 0) {
            return this.initializerBody;
        }
        return this;
    }

    @Override
    public RecoveredElement add(FieldDeclaration newFieldDeclaration, int bracketBalanceValue) {
        char[][] fieldTypeName;
        if ((newFieldDeclaration.modifiers & 0xFFFFFFEF) != 0 || newFieldDeclaration.type == null || (fieldTypeName = newFieldDeclaration.type.getTypeName()).length == 1 && CharOperation.equals(fieldTypeName[0], TypeBinding.VOID.sourceName())) {
            if (this.parent == null) {
                return this;
            }
            this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(newFieldDeclaration.declarationSourceStart - 1));
            return this.parent.add(newFieldDeclaration, bracketBalanceValue);
        }
        if (this.fieldDeclaration.declarationSourceEnd > 0 && newFieldDeclaration.declarationSourceStart > this.fieldDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(newFieldDeclaration, bracketBalanceValue);
        }
        return this;
    }

    @Override
    public RecoveredElement add(LocalDeclaration localDeclaration, int bracketBalanceValue) {
        if (this.fieldDeclaration.declarationSourceEnd != 0 && localDeclaration.declarationSourceStart > this.fieldDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(localDeclaration, bracketBalanceValue);
        }
        Block block = new Block(0);
        block.sourceStart = ((Initializer)this.fieldDeclaration).sourceStart;
        RecoveredElement element = this.add(block, 1);
        return element.add(localDeclaration, bracketBalanceValue);
    }

    @Override
    public RecoveredElement add(Statement statement, int bracketBalanceValue) {
        if (this.fieldDeclaration.declarationSourceEnd != 0 && statement.sourceStart > this.fieldDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(statement, bracketBalanceValue);
        }
        Block block = new Block(0);
        block.sourceStart = ((Initializer)this.fieldDeclaration).sourceStart;
        RecoveredElement element = this.add(block, 1);
        return element.add(statement, bracketBalanceValue);
    }

    @Override
    public RecoveredElement add(TypeDeclaration typeDeclaration, int bracketBalanceValue) {
        if (this.fieldDeclaration.declarationSourceEnd != 0 && typeDeclaration.declarationSourceStart > this.fieldDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(typeDeclaration, bracketBalanceValue);
        }
        if ((typeDeclaration.bits & 0x100) != 0) {
            Block block = new Block(0);
            block.sourceStart = ((Initializer)this.fieldDeclaration).sourceStart;
            RecoveredElement element = this.add(block, 1);
            return element.add(typeDeclaration, bracketBalanceValue);
        }
        if (this.localTypes == null) {
            this.localTypes = new RecoveredType[5];
            this.localTypeCount = 0;
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new RecoveredType[2 * this.localTypeCount];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        RecoveredType element = new RecoveredType(typeDeclaration, (RecoveredElement)this, bracketBalanceValue);
        this.localTypes[this.localTypeCount++] = element;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        return element;
    }

    @Override
    public String toString(int tab) {
        StringBuffer result = new StringBuffer(this.tabString(tab));
        result.append("Recovered initializer:\n");
        this.fieldDeclaration.print(tab + 1, result);
        if (this.initializerBody != null) {
            result.append("\n");
            result.append(this.initializerBody.toString(tab + 1));
        }
        return result.toString();
    }

    @Override
    public FieldDeclaration updatedFieldDeclaration() {
        if (this.initializerBody != null) {
            Block block = this.initializerBody.updatedBlock();
            if (block != null) {
                ((Initializer)this.fieldDeclaration).block = block;
            }
            if (this.localTypeCount > 0) {
                this.fieldDeclaration.bits |= 2;
            }
        }
        if (this.fieldDeclaration.sourceEnd == 0) {
            this.fieldDeclaration.sourceEnd = this.fieldDeclaration.declarationSourceEnd;
        }
        return this.fieldDeclaration;
    }

    @Override
    public RecoveredElement updateOnClosingBrace(int braceStart, int braceEnd) {
        if (--this.bracketBalance <= 0 && this.parent != null) {
            this.updateSourceEndIfNecessary(braceStart, braceEnd);
            return this.parent;
        }
        return this;
    }

    @Override
    public RecoveredElement updateOnOpeningBrace(int braceStart, int braceEnd) {
        ++this.bracketBalance;
        return this;
    }

    @Override
    public void updateSourceEndIfNecessary(int braceStart, int braceEnd) {
        if (this.fieldDeclaration.declarationSourceEnd == 0) {
            Initializer initializer = (Initializer)this.fieldDeclaration;
            if (this.parser().rBraceSuccessorStart >= braceEnd) {
                initializer.declarationSourceEnd = initializer.bodyStart < this.parser().rBraceEnd ? this.parser().rBraceEnd : initializer.bodyStart;
                initializer.bodyEnd = initializer.bodyStart < this.parser().rBraceStart ? this.parser().rBraceStart : initializer.bodyStart;
            } else {
                initializer.declarationSourceEnd = braceEnd;
                initializer.bodyEnd = braceStart - 1;
            }
            if (initializer.block != null) {
                initializer.block.sourceEnd = initializer.declarationSourceEnd;
            }
        }
    }
}

