/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.env;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRestriction;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRule;

public class AccessRuleSet {
    private AccessRule[] accessRules;
    public String[] messageTemplates;
    public static final int MESSAGE_TEMPLATES_LENGTH = 4;

    public AccessRuleSet(AccessRule[] accessRules, String[] messageTemplates) {
        this.accessRules = accessRules;
        this.messageTemplates = messageTemplates != null && messageTemplates.length == 4 ? messageTemplates : new String[]{"{0}", "{0}", "{0} {1}", "{0} {1}"};
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccessRuleSet)) {
            return false;
        }
        AccessRuleSet otherRuleSet = (AccessRuleSet)object;
        if (this.messageTemplates.length != 4 || otherRuleSet.messageTemplates.length != 4) {
            return false;
        }
        int i = 0;
        while (i < 4) {
            if (!this.messageTemplates[i].equals(otherRuleSet.messageTemplates[i])) {
                return false;
            }
            ++i;
        }
        int rulesLength = this.accessRules.length;
        if (rulesLength != otherRuleSet.accessRules.length) {
            return false;
        }
        int i2 = 0;
        while (i2 < rulesLength) {
            if (!this.accessRules[i2].equals(otherRuleSet.accessRules[i2])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public AccessRule[] getAccessRules() {
        return this.accessRules;
    }

    public AccessRestriction getViolatedRestriction(char[] targetTypeFilePath) {
        int i = 0;
        int length = this.accessRules.length;
        while (i < length) {
            AccessRule accessRule = this.accessRules[i];
            if (CharOperation.pathMatch(accessRule.pattern, targetTypeFilePath, true, '/')) {
                switch (accessRule.getProblemId()) {
                    case 0x1000118: 
                    case 0x1000133: {
                        return new AccessRestriction(accessRule, this.messageTemplates);
                    }
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean wrap) {
        StringBuffer buffer = new StringBuffer(200);
        buffer.append("AccessRuleSet {");
        if (wrap) {
            buffer.append('\n');
        }
        int i = 0;
        int length = this.accessRules.length;
        while (i < length) {
            if (wrap) {
                buffer.append('\t');
            }
            AccessRule accessRule = this.accessRules[i];
            buffer.append(accessRule);
            if (wrap) {
                buffer.append('\n');
            } else if (i < length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append("} [templates:\"");
        i = 0;
        while (i < this.messageTemplates.length) {
            buffer.append(this.messageTemplates[i]);
            ++i;
        }
        buffer.append("\"]");
        return buffer.toString();
    }
}

