/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.sourcemap;

public interface TextSectionMapping {
    public TextPoint transform(TextPoint var1, Direction var2);

    public static enum Direction {
        DIRECT,
        REVERSE;

    }

    public static final class TextPoint
    implements Comparable<TextPoint> {
        private final int line;
        private final int column;

        public TextPoint(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof TextPoint)) {
                return false;
            }
            TextPoint other = (TextPoint)obj;
            return this.line == other.line && this.getColumn() == other.getColumn();
        }

        public int hashCode() {
            return this.line + this.getColumn() * 31;
        }

        @Override
        public int compareTo(TextPoint o) {
            if (this.line < o.line) {
                return -1;
            }
            if (this.line > o.line) {
                return 1;
            }
            if (this.getColumn() < o.getColumn()) {
                return -1;
            }
            if (this.getColumn() > o.getColumn()) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return String.valueOf(this.line) + ":" + this.column;
        }
    }
}

