/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.model;

import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.Script;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.UpdatableScript;
import org.eclipse.wst.jsdt.chromium.debug.core.model.SourceWrapSupport;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ChromiumDebugPluginUtil;
import org.eclipse.wst.jsdt.chromium.debug.core.util.ScriptTargetMapping;

public class PushChangesPlan {
    private final Script script;
    private final String newSource;
    private final ScriptTargetMapping scriptTargetMapping;
    private final SourceWrapSupport.Wrapper.Match wrapperMatch;

    public static PushChangesPlan create(ScriptTargetMapping filePair) {
        byte[] fileData;
        SourceWrapSupport.Wrapper.Match wrapperMatch;
        Script script = filePair.getSingleScript();
        if (filePair.isVirtualProjectResource()) {
            wrapperMatch = null;
        } else {
            SourceWrapSupport sourceWrapSupport = filePair.getConnectedTargetData().getSourceWrapSupport();
            wrapperMatch = sourceWrapSupport.chooseWrapper(script.getSource());
        }
        try {
            fileData = ChromiumDebugPluginUtil.readFileContents(filePair.getFile());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        String newSource = new String(fileData);
        return new PushChangesPlan(script, filePair, newSource, wrapperMatch);
    }

    private PushChangesPlan(Script script, ScriptTargetMapping scriptTargetMapping, String newSource, SourceWrapSupport.Wrapper.Match wrapperMatch) {
        this.script = script;
        this.newSource = newSource;
        this.scriptTargetMapping = scriptTargetMapping;
        this.wrapperMatch = wrapperMatch;
    }

    public SourceWrapSupport.Wrapper.Match getSourceWrapperMatch() {
        return this.wrapperMatch;
    }

    public String getNewSource() {
        return this.newSource;
    }

    public ScriptTargetMapping getScriptTargetMapping() {
        return this.scriptTargetMapping;
    }

    public Script getScript() {
        return this.script;
    }

    public RelayOk execute(boolean previewOnly, UpdatableScript.UpdateCallback callback, SyncCallback syncCallback) {
        String wrappedSource = this.wrapperMatch == null ? this.newSource : this.wrapperMatch.wrap(this.newSource);
        if (previewOnly) {
            return this.script.previewSetSource(wrappedSource, callback, syncCallback);
        }
        return this.script.setSourceOnRemote(wrappedSource, callback, syncCallback);
    }
}

