/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.debug.core.internal.sourcemap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.chromium.debug.core.ChromiumDebugPlugin;
import org.eclipse.wst.jsdt.chromium.debug.core.internal.sourcemap.SourceMapLanguageSupportType;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.extension.ISourceMapLanguageSupport;
import org.eclipse.wst.jsdt.chromium.debug.core.sourcemap.extension.ISourceMapManager;

public class SourceMapManager
implements ISourceMapManager,
IRegistryChangeListener {
    private static final SourceMapManager INSTANCE = new SourceMapManager();
    private static final String EXTENSION_SOURCEMAP_LANGUAGE_SUPPORTS = "sourceMapLanguageSupports";
    private List<SourceMapLanguageSupportType> sourceMapLanguageSupports;

    public static SourceMapManager getInstance() {
        return INSTANCE;
    }

    private SourceMapManager() {
    }

    @Override
    public boolean canSupportSourceMap(String fileExtension) {
        return this.getSourceMapLanguageSupport(fileExtension) != null;
    }

    @Override
    public String getJsFile(IPath file) throws CoreException {
        ISourceMapLanguageSupport support = this.getSourceMapLanguageSupport(file.getFileExtension());
        if (support == null) {
            return null;
        }
        IPath jsFile = support.getJsFile(file);
        return jsFile != null ? jsFile.toString() : null;
    }

    @Override
    public ISourceMapLanguageSupport getSourceMapLanguageSupport(String fileExtension) {
        this.loadSourceMapLanguageSupportsIfNeeded();
        for (SourceMapLanguageSupportType type : this.sourceMapLanguageSupports) {
            if (!type.canSupportSourceMap(fileExtension)) continue;
            return type.getSupport();
        }
        return null;
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.wst.jsdt.chromium.debug.core", EXTENSION_SOURCEMAP_LANGUAGE_SUPPORTS);
        if (deltas != null) {
            IExtensionDelta[] iExtensionDeltaArray = deltas;
            int n = deltas.length;
            int n2 = 0;
            while (n2 < n) {
                IExtensionDelta delta = iExtensionDeltaArray[n2];
                this.handleSourceMapLanguageSupportsDelta(delta);
                ++n2;
            }
        }
    }

    private void loadSourceMapLanguageSupportsIfNeeded() {
        if (this.sourceMapLanguageSupports != null) {
            return;
        }
        this.loadSourceMapLanguageSupports();
    }

    private synchronized void loadSourceMapLanguageSupports() {
        if (this.sourceMapLanguageSupports != null) {
            return;
        }
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.jsdt.chromium.debug.core", EXTENSION_SOURCEMAP_LANGUAGE_SUPPORTS);
        ArrayList<SourceMapLanguageSupportType> list = new ArrayList<SourceMapLanguageSupportType>(cf.length);
        this.addSourceMapLanguageSupports(cf, list);
        this.sourceMapLanguageSupports = list;
    }

    private synchronized void addSourceMapLanguageSupports(IConfigurationElement[] cf, List<SourceMapLanguageSupportType> list) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                list.add(new SourceMapLanguageSupportType(ce));
            }
            catch (Throwable e) {
                ChromiumDebugPlugin.log(e);
            }
            ++n2;
        }
    }

    protected void handleSourceMapLanguageSupportsDelta(IExtensionDelta delta) {
        if (this.sourceMapLanguageSupports == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        ArrayList<SourceMapLanguageSupportType> list = new ArrayList<SourceMapLanguageSupportType>(this.sourceMapLanguageSupports);
        if (delta.getKind() == 1) {
            this.addSourceMapLanguageSupports(cf, list);
        } else {
            int size = list.size();
            SourceMapLanguageSupportType[] st = new SourceMapLanguageSupportType[size];
            list.toArray(st);
            int size2 = cf.length;
            int i = 0;
            while (i < size) {
                int j = 0;
                while (j < size2) {
                    if (st[i].getId().equals(cf[j].getAttribute("id"))) {
                        list.remove(st[i]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.sourceMapLanguageSupports = list;
    }

    public void initialize() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener((IRegistryChangeListener)this, "org.eclipse.wst.jsdt.chromium.debug.core");
    }

    public void destroy() {
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
    }
}

