/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.annotate.mapping;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jpt.jpa.annotate.mapping.ColumnAttributes;
import org.eclipse.jpt.jpa.annotate.mapping.TableAnnotationAttributes;

public class JoinTableAttributes
extends TableAnnotationAttributes {
    private List<ColumnAttributes> joinColumns = new ArrayList<ColumnAttributes>();
    private List<ColumnAttributes> inverseJoinColumns = new ArrayList<ColumnAttributes>();

    public JoinTableAttributes() {
    }

    public JoinTableAttributes(JoinTableAttributes another) {
        super(another);
        this.joinColumns.addAll(another.joinColumns);
        this.inverseJoinColumns.addAll(another.inverseJoinColumns);
    }

    public JoinTableAttributes(String tableName, String catalog, String schema) {
        super(tableName, catalog, schema);
    }

    public void addJoinColumn(ColumnAttributes joinColumn) {
        this.joinColumns.add(joinColumn);
    }

    public List<ColumnAttributes> getJoinColumns() {
        return this.joinColumns;
    }

    public void removeAllJoinColumns() {
        for (ColumnAttributes col : this.joinColumns) {
            col.dispose();
        }
        this.joinColumns.clear();
    }

    public void setJoinColumns(List<ColumnAttributes> joinColumns) {
        this.removeAllJoinColumns();
        if (joinColumns != null) {
            this.joinColumns.addAll(joinColumns);
        }
    }

    public void addInverseJoinColumn(ColumnAttributes joinColumn) {
        this.inverseJoinColumns.add(joinColumn);
    }

    public List<ColumnAttributes> getInverseJoinColumns() {
        return this.inverseJoinColumns;
    }

    public void removeAllInverseJoinColumns() {
        for (ColumnAttributes col : this.inverseJoinColumns) {
            col.dispose();
        }
        this.inverseJoinColumns.clear();
    }

    public void setInverseJoinColumns(List<ColumnAttributes> joinColumns) {
        this.removeAllInverseJoinColumns();
        if (joinColumns != null) {
            this.inverseJoinColumns.addAll(joinColumns);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.removeAllJoinColumns();
        this.removeAllInverseJoinColumns();
    }
}

