/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.adt.editor;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SelectionManager;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.xsd.ui.internal.adt.actions.SetInputToGraphView;
import org.eclipse.wst.xsd.ui.internal.adt.design.ADTFloatingToolbar;
import org.eclipse.wst.xsd.ui.internal.adt.design.DesignViewGraphicalViewer;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.ADTEditPartFactory;
import org.eclipse.wst.xsd.ui.internal.adt.editor.CommonMultiPageEditor;
import org.eclipse.wst.xsd.ui.internal.adt.editor.ProductCustomizationProvider;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IModel;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ADTContentOutlinePage;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ADTLabelProvider;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ExtensibleContentOutlinePage;
import org.eclipse.wst.xsd.ui.internal.editor.XSDEditorPlugin;

public abstract class ADTMultiPageEditor
extends CommonMultiPageEditor {
    protected IModel model;
    private int currentPage = -1;
    protected Button tableOfContentsButton;
    protected ADTFloatingToolbar floatingToolbar;
    private IContextActivation contextActivation;
    public static final String DESIGN_VIEW_CONTEXT = "org.eclipse.wst.xsd.ui.editor.designView";
    public static final String SOURCE_VIEW_CONTEXT = "org.eclipse.wst.xsd.ui.editor.sourceView";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    protected Composite createGraphPageComposite() {
        Composite parent = new Composite(this.getContainer(), 0x800000);
        parent.setBackground(ColorConstants.white);
        parent.setLayout((Layout)new InternalLayout());
        this.floatingToolbar = new ADTFloatingToolbar(this.getModel());
        this.floatingToolbar.createControl(parent);
        this.floatingToolbar.getControl().setVisible(true);
        EditPartFactory editPartFactory = this.getEditorModeManager().getCurrentMode().getEditPartFactory();
        this.floatingToolbar.setEditPartFactory(editPartFactory);
        this.createViewModeToolbar(parent);
        return parent;
    }

    protected void createGraphPage() {
        super.createGraphPage();
    }

    public String getContributorId() {
        return "org.eclipse.wst.xsd.ui.internal.editor";
    }

    public IContentOutlinePage getContentOutlinePage() {
        if (this.fOutlinePage == null || this.fOutlinePage.getControl() == null || this.fOutlinePage.getControl().isDisposed()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.xsd.ui.internal.adt.editor.ProductCustomizationProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ProductCustomizationProvider productCustomizationProvider = (ProductCustomizationProvider)this.getAdapter(clazz);
            ExtensibleContentOutlinePage outlinePage = null;
            if (productCustomizationProvider != null) {
                outlinePage = productCustomizationProvider.getProductContentOutlinePage();
            }
            if (outlinePage == null) {
                outlinePage = new ADTContentOutlinePage();
            }
            outlinePage.setEditor(this);
            ITreeContentProvider provider = (ITreeContentProvider)this.getEditorModeManager().getCurrentMode().getOutlineProvider();
            outlinePage.setContentProvider(provider);
            ADTLabelProvider adtLabelProvider = new ADTLabelProvider();
            outlinePage.setLabelProvider(adtLabelProvider);
            outlinePage.setModel(this.getModel());
            this.fOutlinePage = outlinePage;
        }
        return this.fOutlinePage;
    }

    protected void createPages() {
        this.selectionProvider = this.getSelectionManager();
        this.createGraphPage();
        this.createSourcePage();
        this.getEditorSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.model = this.buildModel();
        this.initializeGraphicalViewer();
        this.floatingToolbar.setModel(this.model);
        int pageIndexToShow = this.getDefaultPageTypeIndex();
        this.setActivePage(pageIndexToShow);
    }

    protected int getDefaultPageTypeIndex() {
        int pageIndex = SOURCE_PAGE_INDEX;
        if (XSDEditorPlugin.getPlugin().getDefaultPage().equals(XSDEditorPlugin.DESIGN_PAGE)) {
            pageIndex = DESIGN_PAGE_INDEX;
        }
        return pageIndex;
    }

    public void setFocus() {
        super.setFocus();
        if (this.getActivePage() == DESIGN_PAGE_INDEX) {
            if (this.graphicalViewer != null && this.graphicalViewer.getControl() != null) {
                List selected = this.graphicalViewer.getSelectedEditParts();
                if (selected.size() > 0) {
                    this.graphicalViewer.setFocus((EditPart)selected.get(0));
                }
                this.graphicalViewer.getControl().setFocus();
            }
        } else {
            this.graphicalViewer.setFocus(null);
        }
    }

    protected void pageChange(int newPageIndex) {
        this.deactivateContext(this.contextActivation);
        this.currentPage = newPageIndex;
        super.pageChange(newPageIndex);
        String context = this.getContext(this.currentPage);
        this.contextActivation = this.activateContext(context);
        if (newPageIndex == DESIGN_PAGE_INDEX) {
            StructuredSelection structuredSelection;
            Object elem;
            ISelection selection = this.graphicalViewer.getSelectionManager().getSelection();
            Object model = null;
            if (selection instanceof StructuredSelection && (elem = (structuredSelection = (StructuredSelection)selection).getFirstElement()) instanceof EditPart) {
                model = ((EditPart)elem).getModel();
            }
            this.graphicalViewer.getContents().refresh();
            if (model != null) {
                this.getSelectionManager().setSelection((ISelection)new StructuredSelection(model));
            }
        }
        this.setFocus();
    }

    private boolean isTableOfContentsApplicable(Object graphViewInput) {
        return !(graphViewInput instanceof IModel);
    }

    protected ScrollingGraphicalViewer getGraphicalViewer() {
        DesignViewGraphicalViewer viewer = new DesignViewGraphicalViewer((IEditorPart)this, this.getSelectionManager());
        viewer.addInputChangdListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection input = (IStructuredSelection)event.getSelection();
                ADTMultiPageEditor.this.floatingToolbar.refresh(ADTMultiPageEditor.this.isTableOfContentsApplicable(input.getFirstElement()));
            }
        });
        viewer.setSelectionManager(new CustomSelectionManager());
        return viewer;
    }

    public abstract IModel buildModel();

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        SetInputToGraphView action = new SetInputToGraphView((IWorkbenchPart)this);
        action.setSelectionProvider(this.getSelectionManager());
        registry.registerAction((IAction)action);
    }

    public IModel getModel() {
        return this.model;
    }

    public Object getAdapter(Class type) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.gef.editparts.ZoomManager");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return this.graphicalViewer.getProperty(clazz2.toString());
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.gef.GraphicalViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz3) {
            return this.graphicalViewer;
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.gef.EditPart");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz4 && this.graphicalViewer != null) {
            return this.graphicalViewer.getRootEditPart();
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.draw2d.IFigure");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz5 && this.graphicalViewer != null) {
            return ((GraphicalEditPart)this.graphicalViewer.getRootEditPart()).getFigure();
        }
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.ui.views.contentoutline.IContentOutlinePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz6) {
            return this.getContentOutlinePage();
        }
        return super.getAdapter(type);
    }

    protected EditPartFactory getEditPartFactory() {
        return new ADTEditPartFactory();
    }

    protected void initializeGraphicalViewer() {
        this.graphicalViewer.setContents((Object)this.model);
    }

    public void dispose() {
        if (this.currentPage == SOURCE_PAGE_INDEX) {
            XSDEditorPlugin.getPlugin().setSourcePageAsDefault();
        } else {
            XSDEditorPlugin.getPlugin().setDesignPageAsDefault();
        }
        this.floatingToolbar = null;
        this.deactivateContext(this.contextActivation);
        super.dispose();
    }

    protected String getContext(int pageIndex) {
        if (pageIndex == DESIGN_PAGE_INDEX) {
            return DESIGN_VIEW_CONTEXT;
        }
        if (pageIndex == SOURCE_PAGE_INDEX) {
            return SOURCE_VIEW_CONTEXT;
        }
        return null;
    }

    private IContextActivation activateContext(String context) {
        IContextService contextService;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((contextService = (IContextService)iWorkbenchPartSite.getService((Class)clazz)) != null && context != null) {
            this.contextActivation = contextService.activateContext(context);
            return this.contextActivation;
        }
        return null;
    }

    private void deactivateContext(IContextActivation contextActivation) {
        IContextService contextService;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.ui.contexts.IContextService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((contextService = (IContextService)iWorkbenchPartSite.getService((Class)clazz)) != null && contextActivation != null) {
            contextService.deactivateContext(contextActivation);
        }
    }

    private class CustomSelectionManager
    extends SelectionManager {
        private CustomSelectionManager() {
        }

        public void appendSelection(EditPart editpart) {
            if (editpart != this.getFocus()) {
                this.getViewer().setFocus(editpart);
            }
            super.appendSelection(editpart);
        }
    }

    private class InternalLayout
    extends StackLayout {
        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            org.eclipse.swt.graphics.Rectangle rect = composite.getClientArea();
            rect.x += this.marginWidth;
            rect.y += this.marginHeight;
            rect.width -= 2 * this.marginWidth;
            rect.height -= 2 * this.marginHeight;
            int i = 0;
            while (i < children.length) {
                if (i == 0) {
                    Rectangle r = ((GraphicalEditPart)ADTMultiPageEditor.this.floatingToolbar.getContents()).getFigure().getBounds();
                    children[i].setBounds(rect.x + 10, rect.y + 10, r.width, Math.max(24, r.height));
                } else if (i == 1 && ADTMultiPageEditor.this.modeCombo != null) {
                    children[i].setBounds(rect.x + rect.width - 90 - ADTMultiPageEditor.this.maxLength, rect.y + 10, ADTMultiPageEditor.this.maxLength + 60, 26);
                } else {
                    children[i].setBounds(rect);
                }
                ++i;
            }
        }
    }
}

