/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletExtensionUtil;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletPreferenceStore;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletRuntime;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.ui.Messages;

public class XDocletBuilderValidator {
    public static final String MARKER_ID = "org.eclipse.jst.j2ee.ejb.annotations.xdoclet.xdoclet.marker";

    public boolean validate(IProject currentProject) throws CoreException {
        boolean isValidRuntime = this.isValidRuntime(currentProject);
        this.clearMarkers(currentProject, MARKER_ID);
        if (!isValidRuntime) {
            this.createWarningMarker(currentProject, MARKER_ID, Messages.xdoclet_runtime_invalid);
        }
        return isValidRuntime;
    }

    public IMarker createWarningMarker(IProject project, String type, String message) throws CoreException {
        return this.createMarker(project, 2, type, message);
    }

    public void clearMarkers(IProject project) throws CoreException {
        this.clearMarkers(project, MARKER_ID);
    }

    private void clearMarkers(IProject project, String type) throws CoreException {
        IMarker[] existing = project.findMarkers(type, false, 0);
        int i = 0;
        while (i < existing.length) {
            IMarker marker = existing[i];
            marker.delete();
            ++i;
        }
    }

    private IMarker createMarker(IProject project, int severity, String type, String message) throws CoreException {
        IMarker[] existing = project.findMarkers(type, false, 0);
        int i = 0;
        while (i < existing.length) {
            IMarker m = existing[i];
            if (m.getAttribute("severity", -1) == severity && m.getAttribute("message", "").equals(message)) {
                return m;
            }
            ++i;
        }
        IMarker m = project.createMarker(type);
        m.setAttribute("message", (Object)message);
        m.setAttribute("severity", severity);
        return m;
    }

    public boolean isValidRuntime(IProject currentProject) {
        XDocletPreferenceStore store = XDocletPreferenceStore.forProject(currentProject);
        XDocletRuntime runtime = XDocletExtensionUtil.getRuntime(store.getProperty("XDOCLETVERSION"));
        runtime.setHome(store.getProperty("XDOCLETHOME"));
        return runtime.isValid();
    }
}

