/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.json.impl.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.json.impl.schema.JSONSchemaProperty;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonArray;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonObject;
import org.eclipse.json.provisonnal.com.eclipsesource.json.JsonValue;
import org.eclipse.json.schema.IJSONSchemaDocument;
import org.eclipse.json.schema.IJSONSchemaNode;
import org.eclipse.json.schema.IJSONSchemaProperty;
import org.eclipse.json.schema.JSONSchemaType;

public class JSONSchemaNode
extends JsonObject
implements IJSONSchemaNode {
    private Map<String, JsonValue> definitions;
    private final IJSONSchemaNode parent;
    private final Map<String, IJSONSchemaProperty> properties;
    private JsonObject jsonObject;
    protected final String description;
    protected JSONSchemaType[] type;
    protected String defaultValue;
    private List<String> enumList;

    public JSONSchemaNode(JsonObject jsonObject, IJSONSchemaNode parent) {
        this.parent = parent;
        this.jsonObject = jsonObject;
        if (this instanceof IJSONSchemaDocument) {
            this.definitions = new HashMap<String, JsonValue>();
            this.addDefinitions();
            this.resolveReferences(jsonObject);
        }
        this.properties = new HashMap<String, IJSONSchemaProperty>();
        this.walk(jsonObject, this);
        this.description = jsonObject.getString("description", null);
        this.type = JSONSchemaNode.getType(jsonObject.get("type"));
        JsonValue value = jsonObject.get("default");
        if (value != null) {
            this.defaultValue = this.removeQuote(value);
        }
        if ((value = jsonObject.get("enum")) instanceof JsonArray) {
            JsonArray array = (JsonArray)value;
            List<JsonValue> items = array.values();
            for (JsonValue v : items) {
                String str;
                if (v == null) continue;
                if ((this.type == null || this.type.length == 0) && (str = v.toString()).startsWith("\"") && str.endsWith("\"")) {
                    this.type = new JSONSchemaType[]{JSONSchemaType.String};
                }
                this.addEnum(this.removeQuote(v));
            }
        }
    }

    private void resolveReferences(JsonObject json) {
        for (JsonObject.Member member : json) {
            JsonValue value = member.getValue();
            this.resolveReferences(json, member.getName(), value);
        }
    }

    private void resolveReferences(JsonObject parent, String name, JsonValue value) {
        block8: {
            block7: {
                if (!(value instanceof JsonObject)) break block7;
                JsonObject json = value.asObject();
                String ref = json.getString("$ref", null);
                if (ref != null && ref.startsWith("#/definitions/")) {
                    String r = ref.substring("#/definitions/".length());
                    JsonValue v = this.definitions.get(r);
                    parent.set(name, v);
                } else {
                    for (JsonObject.Member member : json) {
                        JsonValue v = member.getValue();
                        this.resolveReferences(json, member.getName(), v);
                    }
                }
                break block8;
            }
            if (!(value instanceof JsonArray)) break block8;
            JsonArray jsonArray = (JsonArray)value;
            int i = 0;
            while (i < jsonArray.size()) {
                JsonValue item = jsonArray.get(i);
                if (item instanceof JsonObject) {
                    JsonObject json = item.asObject();
                    String ref = json.getString("$ref", null);
                    if (ref != null && ref.startsWith("#/definitions/")) {
                        String r = ref.substring("#/definitions/".length());
                        JsonValue v = this.definitions.get(r);
                        jsonArray.set(i, v);
                    } else {
                        this.resolveReferences(json);
                    }
                }
                ++i;
            }
        }
    }

    private void addDefinitions() {
        JsonValue defs = this.jsonObject.get("definitions");
        if (defs instanceof JsonObject) {
            for (JsonObject.Member member : (JsonObject)defs) {
                JsonValue value = member.getValue();
                if (!(value instanceof JsonObject)) continue;
                this.definitions.put(member.getName(), member.getValue());
            }
        }
    }

    private void walk(JsonObject json, IJSONSchemaNode schemaNode) {
        JsonObject properties = (JsonObject)json.get("properties");
        this.addProperties(schemaNode, properties);
        this.add(json, schemaNode, "allOf");
        this.add(json, schemaNode, "anyOf");
        this.add(json, schemaNode, "oneOf");
        JsonValue notMember = json.get("not");
        if (notMember != null) {
            this.walk(notMember.asObject(), schemaNode);
        }
    }

    private void add(JsonObject jsonObject, IJSONSchemaNode schemaNode, String pref) {
        JsonValue values = jsonObject.get(pref);
        if (values instanceof JsonArray) {
            JsonArray array = (JsonArray)values;
            for (JsonValue value : array) {
                if (value == null) continue;
                this.walk(value.asObject(), schemaNode);
            }
        }
    }

    private void addProperties(IJSONSchemaNode schemaNode, JsonObject properties) {
        if (properties == null) {
            return;
        }
        for (JsonObject.Member member : properties) {
            schemaNode.addProperty(new JSONSchemaProperty(member.getName(), (JsonObject)member.getValue(), schemaNode));
        }
    }

    @Override
    public void addProperty(IJSONSchemaProperty property) {
        this.properties.put(property.getName(), property);
    }

    @Override
    public IJSONSchemaNode getParent() {
        return this.parent;
    }

    @Override
    public IJSONSchemaProperty[] getPropertyValues() {
        return this.properties.values().toArray(IJSONSchemaProperty.EMPTY_PROPERTY);
    }

    @Override
    public JsonObject getJsonObject() {
        return this.jsonObject;
    }

    @Override
    public void setJsonObject(JsonObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    @Override
    public Map<String, IJSONSchemaProperty> getProperties() {
        return this.properties;
    }

    protected String[] getRequired(JsonValue value) {
        if (value == null) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        if (value.isString()) {
            String s = value.asString();
            names.add(s);
        } else if (value.isArray()) {
            JsonArray array = (JsonArray)value;
            for (JsonValue item : array) {
                if (!item.isString()) continue;
                String s = item.asString();
                names.add(s);
            }
        }
        return names.toArray(new String[0]);
    }

    protected String removeQuote(JsonValue value) {
        String str = value.toString();
        if (str.startsWith("\"")) {
            str = str.substring(1);
        }
        if (str.endsWith("\"")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static JSONSchemaType[] getType(JsonValue value) {
        if (value == null) {
            return JSONSchemaType.EMPTY_TYPES;
        }
        JSONSchemaType t = null;
        ArrayList<JSONSchemaType> types = new ArrayList<JSONSchemaType>();
        if (value.isString()) {
            t = JSONSchemaType.getType(value.asString());
            if (t != null) {
                types.add(t);
            }
        } else if (value.isArray()) {
            JsonArray array = (JsonArray)value;
            for (JsonValue item : array) {
                t = JSONSchemaType.getType(item.asString());
                if (t == null) continue;
                types.add(t);
            }
        }
        return types.toArray(JSONSchemaType.EMPTY_TYPES);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public JSONSchemaType[] getType() {
        return this.type;
    }

    @Override
    public JSONSchemaType getFirstType() {
        if (this.type == null) {
            return null;
        }
        if (this.type.length == 0) {
            return null;
        }
        return this.type[0];
    }

    @Override
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public List<String> getEnumList() {
        return this.enumList;
    }

    public void addEnum(String item) {
        if (this.enumList == null) {
            this.enumList = new LinkedList<String>();
        }
        this.enumList.add(item);
    }

    @Override
    public IJSONSchemaDocument getSchemaDocument() {
        if (this instanceof IJSONSchemaDocument) {
            return (IJSONSchemaDocument)((Object)this);
        }
        IJSONSchemaNode p = this.getParent();
        if (p != null) {
            return p.getSchemaDocument();
        }
        return null;
    }
}

