/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.contentassist;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jst.jsp.core.internal.contentmodel.TaglibController;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.CMDocumentImpl;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TLDCMDocumentManager;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.TaglibTracker;
import org.eclipse.jst.jsp.core.internal.contentmodel.tld.provisional.TLDFunction;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.jspel.JSPELParserTokenManager;
import org.eclipse.jst.jsp.core.internal.java.jspel.SimpleCharStream;
import org.eclipse.jst.jsp.core.internal.java.jspel.Token;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPELProposalCollector;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPJavaCompletionProposalComputer;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPProposalCollector;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.sse.ui.internal.contentassist.CustomCompletionProposal;

public class JSPELCompletionProposalComputer
extends JSPJavaCompletionProposalComputer {
    @Override
    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        ITextViewer viewer = context.getViewer();
        int documentPosition = context.getInvocationOffset();
        ArrayList results = new ArrayList(this.computeJavaCompletionProposals(viewer, documentPosition, 3));
        IStructuredDocumentRegion flat = ContentAssistUtils.getStructuredDocumentRegion((ITextViewer)viewer, (int)documentPosition);
        if (flat != null) {
            String prefix;
            int startOffset;
            String elText;
            ITextRegion cursorRegion = flat.getRegionAtCharacterOffset(documentPosition);
            if (cursorRegion instanceof ITextRegionContainer) {
                ITextRegionContainer container = (ITextRegionContainer)cursorRegion;
                cursorRegion = container.getRegionAtCharacterOffset(documentPosition);
                elText = container.getText(cursorRegion);
                startOffset = container.getStartOffset(cursorRegion);
            } else {
                elText = flat.getText(cursorRegion);
                startOffset = flat.getStartOffset(cursorRegion);
            }
            if (cursorRegion.getType() == "JSP_EL_CONTENT" && (prefix = this.getPrefix(documentPosition - startOffset, elText)) != null) {
                List proposals = this.getFunctionProposals(prefix, viewer, documentPosition);
                results.addAll(proposals);
            }
        }
        return results;
    }

    @Override
    protected JSPProposalCollector getProposalCollector(ICompilationUnit cu, JSPTranslation translation) {
        return new JSPELProposalCollector(cu, translation);
    }

    /*
     * Handled impossible loop by duplicating code
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private String getPrefix(int relativePosition, String elText) {
        block6: {
            Token curToken;
            JSPELParserTokenManager scanner;
            block5: {
                StringReader reader = new StringReader(elText);
                scanner = new JSPELParserTokenManager(new SimpleCharStream((Reader)reader, 1, 1));
                curToken = null;
                Object var6_6 = null;
                if (!true) break block5;
                curToken = scanner.getNextToken();
                if (curToken.kind == 0) break block6;
            }
            do {
                void var6_7;
                if (29 == curToken.kind && curToken.endColumn == relativePosition && var6_7 != null) {
                    return var6_7.image;
                }
                if (47 == curToken.kind) {
                    Token token = curToken;
                } else {
                    Object var6_9 = null;
                }
                curToken = scanner.getNextToken();
            } while (curToken.kind != 0);
        }
        return null;
    }

    private List getFunctionProposals(String prefix, ITextViewer viewer, int offset) {
        TLDCMDocumentManager docMgr = TaglibController.getTLDCMDocumentManager((IDocument)viewer.getDocument());
        ArrayList<CustomCompletionProposal> completionList = new ArrayList<CustomCompletionProposal>();
        if (docMgr == null) {
            return null;
        }
        for (TaglibTracker tracker : docMgr.getCMDocumentTrackers(offset)) {
            if (!tracker.getPrefix().equals(prefix)) continue;
            CMDocumentImpl doc = (CMDocumentImpl)tracker.getDocument();
            List functions = doc.getFunctions();
            for (TLDFunction function : functions) {
                CustomCompletionProposal proposal = new CustomCompletionProposal(String.valueOf(function.getName()) + "()", offset, 0, function.getName().length() + 1, null, String.valueOf(function.getName()) + " - " + function.getSignature(), null, null, 1);
                completionList.add(proposal);
            }
        }
        return completionList;
    }
}

