/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.gen;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jpt.common.core.gen.JptGenerator;
import org.eclipse.jpt.common.ui.gen.AbstractJptGenerateJob;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.internal.gen.ClassesGenerator;
import org.eclipse.jpt.jaxb.core.internal.gen.ClassesGeneratorExtensionOptions;
import org.eclipse.jpt.jaxb.core.internal.gen.ClassesGeneratorOptions;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiMessages;
import org.eclipse.jpt.jaxb.ui.internal.plugin.JptJaxbUiPlugin;

public class GenerateJaxbClassesJob
extends AbstractJptGenerateJob {
    private final String absoluteLocalXsdUri;
    private final String outputDir;
    private final String targetPackage;
    private final String catalog;
    private final boolean usesMoxyGenerator;
    private final String[] bindingsFileNames;
    private final ClassesGeneratorOptions generatorOptions;
    private final ClassesGeneratorExtensionOptions generatorExtensionOptions;

    public GenerateJaxbClassesJob(IJavaProject javaProject, String absoluteLocalXsdUri, String outputDir, String targetPackage, String catalog, boolean usesMoxyGenerator, String[] bindingsFileNames, ClassesGeneratorOptions generatorOptions, ClassesGeneratorExtensionOptions generatorExtensionOptions) {
        super(JptJaxbUiMessages.GENERATE_JAXB_CLASSES_JOB_GENERATING_CLASSES, javaProject);
        if (javaProject == null) {
            throw new RuntimeException("Project is null");
        }
        if (StringTools.isBlank((String)absoluteLocalXsdUri)) {
            throw new RuntimeException("Schema cannot be empty");
        }
        if (StringTools.isBlank((String)outputDir)) {
            throw new RuntimeException("Output directory cannot be empty");
        }
        this.absoluteLocalXsdUri = absoluteLocalXsdUri;
        this.outputDir = outputDir;
        this.targetPackage = targetPackage;
        this.catalog = catalog;
        this.usesMoxyGenerator = usesMoxyGenerator;
        this.bindingsFileNames = bindingsFileNames;
        this.generatorOptions = generatorOptions;
        this.generatorExtensionOptions = generatorExtensionOptions;
    }

    protected JptGenerator buildGenerator() {
        return new ClassesGenerator(this.getJavaProject(), this.absoluteLocalXsdUri, this.outputDir, this.targetPackage, this.catalog, this.usesMoxyGenerator, this.bindingsFileNames, this.generatorOptions, this.generatorExtensionOptions);
    }

    protected void postGenerate() {
        this.refreshProject();
    }

    protected String getJobName() {
        return JptJaxbUiMessages.GENERATE_JAXB_CLASSES_JOB_GENERATING_CLASSES_TASK;
    }

    protected void jptPluginLogException(Exception exception) {
        JptJaxbUiPlugin.instance().logError(exception);
    }
}

