/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.chromium.internal.wip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.wst.jsdt.chromium.Breakpoint;
import org.eclipse.wst.jsdt.chromium.JavascriptVm;
import org.eclipse.wst.jsdt.chromium.RelayOk;
import org.eclipse.wst.jsdt.chromium.SyncCallback;
import org.eclipse.wst.jsdt.chromium.TextStreamPosition;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipBreakpointImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipCommandProcessor;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipContextBuilder;
import org.eclipse.wst.jsdt.chromium.internal.wip.WipTabImpl;
import org.eclipse.wst.jsdt.chromium.internal.wip.protocol.input.debugger.BreakpointResolvedEventData;
import org.eclipse.wst.jsdt.chromium.util.RelaySyncCallback;

public class WipBreakpointManager {
    private final WipTabImpl tabImpl;
    private final AtomicInteger breakpointUniqueId = new AtomicInteger(0);
    private final Db db = new Db();
    private static final Breakpoint.Target.Visitor<Boolean> IS_SCRIPT_ID_VISITOR = new Breakpoint.Target.Visitor<Boolean>(){

        public Boolean visitScriptName(String scriptName) {
            return Boolean.FALSE;
        }

        public Boolean visitScriptId(Object scriptId) {
            return Boolean.TRUE;
        }

        public Boolean visitUnknown(Breakpoint.Target target) {
            return Boolean.FALSE;
        }
    };

    WipBreakpointManager(WipTabImpl tabImpl) {
        this.tabImpl = tabImpl;
    }

    RelayOk setBreakpoint(Breakpoint.Target target, int line, int column, boolean enabled, String condition, final JavascriptVm.BreakpointCallback callback, SyncCallback syncCallback) {
        int sdkId = this.breakpointUniqueId.getAndAdd(1);
        final WipBreakpointImpl breakpointImpl = new WipBreakpointImpl(this, sdkId, target, line, column, condition, enabled);
        this.db.addBreakpoint(breakpointImpl);
        if (enabled) {
            if (condition == null) {
                condition = "";
            }
            WipBreakpointImpl.SetBreakpointCallback wrappedCallback = new WipBreakpointImpl.SetBreakpointCallback(){

                @Override
                public void onSuccess(String protocolId, Collection<WipBreakpointImpl.ActualLocation> actualLocations) {
                    breakpointImpl.setRemoteData(protocolId, actualLocations);
                    if (callback != null) {
                        callback.success((Breakpoint)breakpointImpl);
                    }
                }

                @Override
                public void onFailure(Exception exception) {
                    if (callback != null) {
                        callback.failure(exception.getMessage());
                    }
                }
            };
            return WipBreakpointImpl.sendSetBreakpointRequest(target, line, column, condition, wrappedCallback, syncCallback, this.tabImpl.getCommandProcessor());
        }
        callback.success((Breakpoint)breakpointImpl);
        return RelaySyncCallback.finish((SyncCallback)syncCallback);
    }

    Db getDb() {
        return this.db;
    }

    void clearNonProvisionalBreakpoints() {
        this.db.visitAllBreakpoints(new Db.Visitor<Void>(){

            @Override
            public Void visitAllBreakpoints(Set<WipBreakpointImpl> breakpoints) {
                ArrayList<WipBreakpointImpl> deleteList = new ArrayList<WipBreakpointImpl>();
                for (WipBreakpointImpl breakpoint : breakpoints) {
                    if (((Boolean)breakpoint.getTarget().accept(IS_SCRIPT_ID_VISITOR)).booleanValue()) {
                        deleteList.add(breakpoint);
                        continue;
                    }
                    breakpoint.clearActualLocations();
                }
                for (WipBreakpointImpl breakpoint : deleteList) {
                    breakpoint.deleteSelfFromDb();
                }
                return null;
            }
        });
    }

    WipCommandProcessor getCommandProcessor() {
        return this.tabImpl.getCommandProcessor();
    }

    Collection<WipBreakpointImpl> getAllBreakpoints() {
        return this.db.visitAllBreakpoints(new Db.Visitor<Collection<WipBreakpointImpl>>(){

            @Override
            public Collection<WipBreakpointImpl> visitAllBreakpoints(Set<WipBreakpointImpl> breakpoints) {
                return new ArrayList<WipBreakpointImpl>(breakpoints);
            }
        });
    }

    void breakpointReportedResolved(BreakpointResolvedEventData eventData) {
        String breakpointId = eventData.breakpointId();
        WipBreakpointImpl breakpoint = this.db.getBreakpoint(breakpointId);
        if (breakpoint == null) {
            throw new RuntimeException("Failed to find breakpoint by id: " + breakpointId);
        }
        breakpoint.addResolvedLocation(eventData.location());
    }

    public Collection<? extends Breakpoint> findRelatedBreakpoints(WipContextBuilder.WipDebugContextImpl.CallFrameImpl topFrame) {
        TextStreamPosition position = topFrame.getStatementStartPosition();
        int line = position.getLine();
        int column = position.getColumn();
        String scriptId = topFrame.getSourceId();
        final WipBreakpointImpl.ActualLocation location = new WipBreakpointImpl.ActualLocation(scriptId, line, Long.valueOf(column));
        return this.db.visitAllBreakpoints(new Db.Visitor<List<Breakpoint>>(){

            @Override
            public List<Breakpoint> visitAllBreakpoints(Set<WipBreakpointImpl> breakpoints) {
                ArrayList<Breakpoint> result = new ArrayList<Breakpoint>(1);
                for (WipBreakpointImpl breakpoint : breakpoints) {
                    if (!breakpoint.getActualLocations().contains(location)) continue;
                    result.add(breakpoint);
                }
                return result;
            }
        });
    }

    static class Db {
        private final Set<WipBreakpointImpl> breakpoints = new HashSet<WipBreakpointImpl>();
        private final Map<String, WipBreakpointImpl> idToBreakpoint = new HashMap<String, WipBreakpointImpl>();

        Db() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addBreakpoint(WipBreakpointImpl breakpoint) {
            Set<WipBreakpointImpl> set = this.breakpoints;
            synchronized (set) {
                this.breakpoints.add(breakpoint);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeBreakpoint(WipBreakpointImpl breakpoint) {
            Set<WipBreakpointImpl> set = this.breakpoints;
            synchronized (set) {
                this.breakpoints.remove(breakpoint);
            }
        }

        void setIdMapping(WipBreakpointImpl breakpoint, String protocolId) {
            if (protocolId == null) {
                this.idToBreakpoint.remove(protocolId);
            } else {
                this.idToBreakpoint.put(protocolId, breakpoint);
            }
        }

        WipBreakpointImpl getBreakpoint(String breakpointId) {
            return this.idToBreakpoint.get(breakpointId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        <R> R visitAllBreakpoints(Visitor<R> visitor) {
            Set<WipBreakpointImpl> set = this.breakpoints;
            synchronized (set) {
                return visitor.visitAllBreakpoints(this.breakpoints);
            }
        }

        static interface Visitor<R> {
            public R visitAllBreakpoints(Set<WipBreakpointImpl> var1);
        }
    }
}

