/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.reconcile.validator;

import java.util.ArrayList;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilableModel;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.Logger;
import org.eclipse.wst.sse.ui.internal.reconcile.DocumentAdapter;
import org.eclipse.wst.sse.ui.internal.reconcile.ReconcileAnnotationKey;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredReconcileStep;
import org.eclipse.wst.sse.ui.internal.reconcile.TemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.AnnotationInfo;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.ISourceValidator;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.IncrementalHelper;
import org.eclipse.wst.sse.ui.internal.reconcile.validator.IncrementalReporter;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ReconcileStepForValidator
extends StructuredReconcileStep {
    protected static final boolean DEBUG;
    private final IReconcileResult[] EMPTY_RECONCILE_RESULT_SET = new IReconcileResult[0];
    private IncrementalHelper fHelper = null;
    private IncrementalReporter fReporter = null;
    private int fScope = -1;
    private IValidator fValidator = null;
    private static final String QUICKASSISTPROCESSOR;
    private static final Object NO_FILE;
    private Object fFile = null;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.sse.ui/debug/reconcilerjob");
        DEBUG = Boolean.valueOf(value);
        QUICKASSISTPROCESSOR = IQuickAssistProcessor.class.getName();
        NO_FILE = new Object();
    }

    public ReconcileStepForValidator(IValidator v, int scope) {
        if (v == null) {
            throw new IllegalArgumentException("validator cannot be null");
        }
        this.fValidator = v;
        this.fScope = scope;
    }

    protected IReconcileResult[] createAnnotations(AnnotationInfo[] infos) {
        ArrayList<TemporaryAnnotation> annotations = new ArrayList<TemporaryAnnotation>();
        int i = 0;
        while (i < infos.length) {
            block6: {
                AnnotationInfo info = infos[i];
                IMessage validationMessage = info.getMessage();
                int offset = validationMessage.getOffset();
                if (offset >= 0) {
                    String messageText = null;
                    try {
                        messageText = validationMessage.getText(validationMessage.getClass().getClassLoader());
                    }
                    catch (Exception t) {
                        Logger.logException("exception reporting message from validator", t);
                        break block6;
                    }
                    String type = this.getSeverity(validationMessage);
                    int length = validationMessage.getLength();
                    if (length >= 0) {
                        Position p = new Position(offset, length);
                        ReconcileAnnotationKey key = this.createKey(this.getPartitionType(this.getDocument(), offset), this.getScope());
                        TemporaryAnnotation annotation = new TemporaryAnnotation(p, type, messageText, key);
                        Object extraInfo = info.getAdditionalFixInfo();
                        if (extraInfo == null) {
                            extraInfo = validationMessage.getAttribute(QUICKASSISTPROCESSOR);
                        }
                        annotation.setAdditionalFixInfo(extraInfo);
                        annotation.setAttributes(validationMessage.getAttributes());
                        annotations.add(annotation);
                    }
                }
            }
            ++i;
        }
        return annotations.toArray(new IReconcileResult[annotations.size()]);
    }

    private String getSeverity(IMessage validationMessage) {
        String type = "org.eclipse.wst.sse.ui.temp.info";
        switch (validationMessage.getSeverity()) {
            case 1: {
                type = "org.eclipse.wst.sse.ui.temp.error";
                break;
            }
            case 2: {
                type = "org.eclipse.wst.sse.ui.temp.warning";
                break;
            }
            case 4: {
                type = "org.eclipse.wst.sse.ui.temp.info";
                break;
            }
            case 3: {
                type = "org.eclipse.wst.sse.ui.temp.warning";
            }
        }
        return type;
    }

    private IFile getFile() {
        if (this.fFile == null) {
            IFile file;
            IPath path;
            this.fFile = NO_FILE;
            ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(this.getDocument());
            if (buffer != null && buffer.getLocation() != null && (path = buffer.getLocation()).segmentCount() > 1 && (file = ResourcesPlugin.getWorkspace().getRoot().getFile(path)).isAccessible()) {
                this.fFile = file;
            }
        }
        if (this.fFile != NO_FILE) {
            return (IFile)this.fFile;
        }
        return null;
    }

    private IncrementalHelper getHelper(IProject project) {
        if (this.fHelper == null) {
            this.fHelper = new IncrementalHelper(this.getDocument(), project);
        }
        return this.fHelper;
    }

    private IncrementalReporter getReporter() {
        if (this.fReporter == null) {
            this.fReporter = new IncrementalReporter(this.getProgressMonitor());
        }
        return this.fReporter;
    }

    public int getScope() {
        return this.fScope;
    }

    public void initialReconcile() {
    }

    @Override
    protected IReconcileResult[] reconcileModel(DirtyRegion dirtyRegion, IRegion subRegion) {
        if (DEBUG) {
            System.out.println("[trace reconciler] > reconciling model in VALIDATOR step w/ dirty region: [" + dirtyRegion.getText() + "]");
        }
        IReconcileResult[] results = this.EMPTY_RECONCILE_RESULT_SET;
        if (dirtyRegion != null) {
            try {
                results = this.fValidator instanceof ISourceValidator && this.getScope() == 1 ? this.validate(dirtyRegion, subRegion) : this.validate();
            }
            catch (Exception ex) {
                Logger.logException("EXCEPTION IN RECONCILE STEP FOR VALIDATOR", ex);
            }
        }
        if (DEBUG) {
            System.out.println("[trace reconciler] > VALIDATOR step done");
        }
        return results;
    }

    public String toString() {
        StringBuffer debugString = new StringBuffer("ValidatorStep: ");
        if (this.fValidator != null) {
            debugString.append(this.fValidator.toString());
        }
        return debugString.toString();
    }

    protected IReconcileResult[] validate() {
        IReconcileResult[] results;
        block8: {
            results = this.EMPTY_RECONCILE_RESULT_SET;
            IFile file = this.getFile();
            IncrementalReporter reporter = null;
            try {
                try {
                    IncrementalHelper helper = this.getHelper(file != null ? file.getProject() : null);
                    if (file != null && file.isAccessible()) {
                        helper.setURI(file.getFullPath().toString());
                    } else {
                        String uri = this.getURI();
                        if (uri != null) {
                            helper.setURI(uri);
                        }
                    }
                    reporter = this.getReporter();
                    this.fValidator.validate((IValidationContext)helper, (IReporter)reporter);
                    results = this.createAnnotations(reporter.getAnnotationInfo());
                    reporter.removeAllMessages(this.fValidator);
                }
                catch (Exception e) {
                    Logger.logException(e);
                    this.fValidator.cleanup(reporter);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.fValidator.cleanup(reporter);
                throw throwable;
            }
            this.fValidator.cleanup((IReporter)reporter);
        }
        return results;
    }

    private String getURI() {
        IStructuredModel model = null;
        try {
            ITextFileBuffer textFileBuffer;
            model = StructuredModelManager.getModelManager().getExistingModelForRead(this.getDocument());
            if (model != null && !"org.eclipse.wst.sse.core.IModelManager.UNMANAGED_MODEL".equals(model.getBaseLocation())) {
                String string = model.getBaseLocation();
                return string;
            }
            ITextFileBufferManager textFileBufferManager = FileBuffers.getTextFileBufferManager();
            if (textFileBufferManager != null && (textFileBuffer = textFileBufferManager.getTextFileBuffer(this.getDocument())) != null && textFileBuffer.getLocation() != null) {
                String string = textFileBuffer.getLocation().toString();
                return string;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
        }
        return null;
    }

    public void setInputModel(IReconcilableModel inputModel) {
        IDocument document;
        if (inputModel instanceof DocumentAdapter && (document = ((DocumentAdapter)inputModel).getDocument()) != null && this.fValidator instanceof ISourceValidator) {
            ((ISourceValidator)this.fValidator).connect(document);
        }
        super.setInputModel(inputModel);
    }

    @Override
    public void release() {
        if (this.fValidator instanceof ISourceValidator) {
            IDocument document = this.getDocument();
            if (document != null) {
                ((ISourceValidator)this.fValidator).disconnect(document);
            }
            this.fValidator.cleanup((IReporter)this.getReporter());
        }
        super.release();
    }

    protected IReconcileResult[] validate(DirtyRegion dirtyRegion, IRegion subRegion) {
        IReconcileResult[] results = this.EMPTY_RECONCILE_RESULT_SET;
        IFile file = this.getFile();
        try {
            IncrementalHelper helper = this.getHelper(file != null ? file.getProject() : null);
            if (file != null && file.exists()) {
                helper.setURI(file.getFullPath().toString());
            }
            if (this.fValidator instanceof ISourceValidator) {
                IncrementalReporter reporter = this.getReporter();
                if (this.getScope() == 1) {
                    ((ISourceValidator)this.fValidator).validate((IRegion)dirtyRegion, helper, reporter);
                } else {
                    ((ISourceValidator)this.fValidator).validate((IRegion)new Region(0, this.getDocument().getLength()), helper, reporter);
                }
                results = this.createAnnotations(reporter.getAnnotationInfo());
                reporter.removeAllMessages(this.fValidator);
            }
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return results;
    }
}

