/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.rhino.ui.launching;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.RhinoUIPlugin;
import org.eclipse.wst.jsdt.debug.internal.rhino.ui.launching.Messages;

public class RhinoLaunchShortcut
implements ILaunchShortcut2 {
    public void launch(ISelection selection, String mode) {
        this.launch(this.getLaunchableResource(selection), mode);
    }

    public void launch(IEditorPart editor, String mode) {
        this.launch(this.getLaunchableResource(editor), mode);
    }

    void launch(IResource resource, String mode) {
        List configs;
        if (resource != null && (configs = this.getCandidates(resource)) != null) {
            ILaunchConfiguration config = null;
            int count = configs.size();
            if (count == 1) {
                config = (ILaunchConfiguration)configs.get(0);
            } else if (count > 1 && (config = this.chooseConfiguration(configs)) == null) {
                return;
            }
            if (config == null) {
                config = this.createConfiguration(resource);
            }
            if (config != null) {
                DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
            }
        }
    }

    ILaunchConfiguration createConfiguration(IResource resource) {
        ILaunchConfiguration config = null;
        ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.wst.jsdt.debug.rhino.ui.launch.config.type");
        String project = resource.getProject().getName();
        String script = resource instanceof IFile ? resource.getFullPath().toString() : null;
        try {
            if (script != null) {
                ILaunchConfigurationWorkingCopy copy = type.newInstance(null, NLS.bind((String)Messages.config_name, (Object[])new String[]{project, resource.getName()}));
                copy.setAttribute("script", script);
                copy.setAttribute("logexceptions", true);
                copy.setAttribute("ecmaversion", "170");
                copy.setAttribute("optlevel", -1);
                copy.setAttribute("strictmode", false);
                copy.setMappedResources(new IResource[]{resource});
                config = copy.doSave();
            }
        }
        catch (CoreException ce) {
            RhinoUIPlugin.log(ce);
        }
        return config;
    }

    ILaunchConfiguration findConfig(IResource resource) {
        List candidates = this.getCandidates(resource);
        int candidateCount = candidates.size();
        if (candidateCount == 1) {
            return (ILaunchConfiguration)candidates.get(0);
        }
        if (candidateCount > 1) {
            return this.chooseConfiguration(candidates);
        }
        return null;
    }

    protected ILaunchConfiguration chooseConfiguration(List configList) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(RhinoUIPlugin.getActiveWorkbenchWindow().getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(Messages.select_rhino_config);
        dialog.setMessage(Messages.select_existing_config);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return null;
    }

    public IResource getLaunchableResource(ISelection selection) {
        IStructuredSelection ss;
        Object obj;
        if (selection instanceof IStructuredSelection && (obj = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable) {
            return this.getResource((IAdaptable)obj);
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        return this.getResource((IAdaptable)editorpart.getEditorInput());
    }

    List getCandidates(IResource resource) {
        ArrayList<ILaunchConfiguration> candidates = Collections.EMPTY_LIST;
        try {
            ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = lm.getLaunchConfigurationType("org.eclipse.wst.jsdt.debug.rhino.ui.launch.config.type");
            ILaunchConfiguration[] configs = lm.getLaunchConfigurations(type);
            candidates = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                if (config.hasAttribute("script") && config.getAttribute("script", "").equals(resource.getFullPath().toString())) {
                    candidates.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            RhinoUIPlugin.log(e);
        }
        return candidates;
    }

    IResource getResource(IAdaptable adaptable) {
        IJavaScriptElement element = (IJavaScriptElement)adaptable.getAdapter(IJavaScriptElement.class);
        if (element != null) {
            return element.getResource();
        }
        return (IResource)adaptable.getAdapter(IResource.class);
    }
}

