/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.java.JavaGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmGenerator;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextModel;
import org.eclipse.jpt.jpa.core.resource.orm.XmlGenerator;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractOrmGenerator<X extends XmlGenerator>
extends AbstractOrmXmlContextModel<JpaContextModel>
implements OrmGenerator {
    protected final X xmlGenerator;
    protected String name;

    protected AbstractOrmGenerator(JpaContextModel parent, X xmlGenerator) {
        super(parent);
        this.xmlGenerator = xmlGenerator;
        this.name = xmlGenerator.getName();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.setName_(this.xmlGenerator.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.setName_(name);
        this.xmlGenerator.setName(name);
    }

    protected void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    @Override
    public boolean supportsValidationMessages() {
        return true;
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (StringTools.isBlank((String)this.name)) {
            messages.add(this.buildValidationMessage(this.getNameTextRange(), JptJpaCoreValidationMessages.GENERATOR_NAME_UNDEFINED));
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.xmlGenerator.getValidationTextRange();
        return textRange != null ? textRange : ((JpaContextModel)this.parent).getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getValidationTextRange(this.xmlGenerator.getNameTextRange());
    }

    @Override
    public boolean isEquivalentTo(Generator other) {
        return this != other && this.getGeneratorType() == other.getGeneratorType() && this.isEquivalentTo_(other);
    }

    protected boolean isEquivalentTo_(Generator other) {
        return ObjectTools.equals((Object)this.name, (Object)other.getName());
    }

    public void convertFrom(JavaGenerator javaGenerator) {
        this.setName(javaGenerator.getName());
    }

    public X getXmlGenerator() {
        return this.xmlGenerator;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }
}

