/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.core.resource.java.Annotation;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.ColumnMapping;
import org.eclipse.jpt.jpa.core.context.Generator;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedColumn;
import org.eclipse.jpt.jpa.core.context.SpecifiedRelationship;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedPersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaContextModel;
import org.eclipse.jpt.jpa.core.internal.jpa2.context.SimpleMetamodelField;
import org.eclipse.jpt.jpa.core.jpa2.context.AttributeMapping2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.MetamodelField2_0;
import org.eclipse.jpt.jpa.core.jpa2.context.SpecifiedPersistentAttribute2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.JPA2_0;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

public abstract class AbstractJavaAttributeMapping<A extends Annotation>
extends AbstractJavaContextModel<JavaSpecifiedPersistentAttribute>
implements JavaAttributeMapping,
AttributeMapping2_0 {
    protected boolean default_ = this.buildDefault();

    protected AbstractJavaAttributeMapping(JavaSpecifiedPersistentAttribute parent) {
        super(parent);
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.updateDefault();
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
    }

    @Override
    public String getName() {
        return this.getPersistentAttribute().getName();
    }

    public A getMappingAnnotation() {
        return (A)this.getAnnotation_();
    }

    protected Annotation getAnnotation_() {
        return this.getResourceAttribute().getAnnotation(this.getAnnotationName());
    }

    protected abstract String getAnnotationName();

    public A getAnnotationForUpdate() {
        A annotation = this.getMappingAnnotation();
        if (annotation == null) {
            this.getPersistentAttribute().setMappingKey(this.getKey());
            annotation = this.getMappingAnnotation();
            if (annotation == null) {
                throw new IllegalStateException("missing annotation: " + String.valueOf(this));
            }
        }
        return annotation;
    }

    @Override
    public boolean isDefault() {
        return this.default_;
    }

    protected void setDefault(boolean default_) {
        boolean old = this.default_;
        this.default_ = default_;
        this.firePropertyChanged("default", old, default_);
    }

    @Override
    public void updateDefault() {
        this.setDefault(this.buildDefault());
    }

    protected boolean buildDefault() {
        return this.getMappingAnnotation() == null;
    }

    @Override
    public JavaSpecifiedPersistentAttribute getPersistentAttribute() {
        return (JavaSpecifiedPersistentAttribute)this.parent;
    }

    @Override
    public TypeMapping getTypeMapping() {
        return this.getPersistentAttribute().getDeclaringTypeMapping();
    }

    @Override
    public JavaResourceAttribute getResourceAttribute() {
        return this.getPersistentAttribute().getResourceAttribute();
    }

    @Override
    public String getPrimaryKeyColumnName() {
        return null;
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return false;
    }

    @Override
    public boolean isOverridableAssociationMapping() {
        return false;
    }

    @Override
    public boolean isRelationshipOwner() {
        return false;
    }

    @Override
    public boolean isOwnedBy(AttributeMapping mapping) {
        return false;
    }

    @Override
    public boolean validatesAgainstDatabase() {
        return this.getTypeMapping().validatesAgainstDatabase();
    }

    public Table resolveDbTable(String tableName) {
        return this.getTypeMapping().resolveDbTable(tableName);
    }

    protected JavaSpecifiedPersistentAttribute getJavaPersistentAttribute() {
        return this.getPersistentAttribute().getJavaPersistentAttribute();
    }

    @Override
    public Iterable<Generator> getGenerators() {
        return EmptyIterable.instance();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public Iterable<String> getAllMappingNames() {
        return new SingleElementIterable((Object)this.getName());
    }

    @Override
    public Iterable<String> getAllOverridableAttributeMappingNames() {
        return this.isOverridableAttributeMapping() ? new SingleElementIterable((Object)this.getName()) : EmptyIterable.instance();
    }

    @Override
    public Iterable<String> getAllOverridableAssociationMappingNames() {
        return this.isOverridableAssociationMapping() ? new SingleElementIterable((Object)this.getName()) : EmptyIterable.instance();
    }

    @Override
    public SpecifiedColumn resolveOverriddenColumn(String attributeName) {
        ColumnMapping mapping = this.resolveColumnMapping(attributeName);
        return mapping == null ? null : mapping.getColumn();
    }

    protected ColumnMapping resolveColumnMapping(String name) {
        AttributeMapping mapping = this.resolveAttributeMapping(name);
        return mapping != null && mapping.isOverridableAttributeMapping() ? (ColumnMapping)mapping : null;
    }

    @Override
    public SpecifiedRelationship resolveOverriddenRelationship(String attributeName) {
        RelationshipMapping mapping = this.resolveRelationshipMapping(attributeName);
        return mapping == null ? null : mapping.getRelationship();
    }

    protected RelationshipMapping resolveRelationshipMapping(String name) {
        AttributeMapping mapping = this.resolveAttributeMapping(name);
        return mapping != null && mapping.isOverridableAssociationMapping() ? (RelationshipMapping)mapping : null;
    }

    @Override
    public AttributeMapping resolveAttributeMapping(String attributeName) {
        return this.getName().equals(attributeName) ? this : null;
    }

    protected Transformer<String, String> buildQualifierTransformer() {
        return new MappingTools.QualifierTransformer(this.getName());
    }

    protected String unqualify(String attributeName) {
        return MappingTools.unqualify(this.getName(), attributeName);
    }

    @Override
    public MetamodelField2_0 getMetamodelField() {
        return new SimpleMetamodelField(this.getMetamodelFieldModifiers(), this.getMetamodelFieldTypeName(), this.getMetamodelFieldTypeArgumentNames(), this.getMetamodelFieldName());
    }

    protected Iterable<String> getMetamodelFieldModifiers() {
        return STANDARD_METAMODEL_FIELD_MODIFIERS;
    }

    protected String getMetamodelFieldTypeName() {
        return JPA2_0.SINGULAR_ATTRIBUTE;
    }

    protected final Iterable<String> getMetamodelFieldTypeArgumentNames() {
        ArrayList<String> typeArgumentNames = new ArrayList<String>(3);
        typeArgumentNames.add(this.getTypeMapping().getPersistentType().getName());
        this.addMetamodelFieldTypeArgumentNamesTo(typeArgumentNames);
        return typeArgumentNames;
    }

    protected void addMetamodelFieldTypeArgumentNamesTo(ArrayList<String> typeArgumentNames) {
        typeArgumentNames.add(this.getMetamodelTypeName());
    }

    @Override
    public String getMetamodelTypeName() {
        return ((SpecifiedPersistentAttribute2_0)((Object)this.getPersistentAttribute())).getMetamodelTypeName();
    }

    protected String getMetamodelFieldName() {
        return this.getName();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateMappingType(messages);
    }

    protected void validateMappingType(List<IMessage> messages) {
        if (!this.getTypeMapping().attributeMappingKeyAllowed(this.getKey())) {
            if (this.getPersistentAttribute().isVirtual()) {
                messages.add(this.buildValidationMessage(this.getVirtualPersistentAttributeTextRange(), JptJpaCoreValidationMessages.PERSISTENT_ATTRIBUTE_INVALID_MAPPING, this.getName()));
            } else {
                messages.add(this.buildValidationMessage(this.getValidationTextRange(), JptJpaCoreValidationMessages.PERSISTENT_ATTRIBUTE_INVALID_MAPPING, this.getName()));
            }
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getMappingAnnotationTextRange();
        return textRange != null ? textRange : this.getPersistentAttribute().getValidationTextRange();
    }

    protected TextRange getVirtualPersistentAttributeTextRange() {
        return this.getPersistentAttribute().getValidationTextRange();
    }

    protected TextRange getMappingAnnotationTextRange() {
        A annotation = this.getMappingAnnotation();
        return annotation == null ? null : annotation.getTextRange();
    }
}

