/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTExpression;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVirtSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionScope;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTDeclarator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunctionScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;

public class CPPASTFunctionDeclarator
extends CPPASTDeclarator
implements ICPPASTFunctionDeclarator {
    public static final ICPPEvaluation NOEXCEPT_TRUE = new EvalFixed(CPPBasicType.BOOLEAN, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(true));
    private ICPPASTParameterDeclaration[] parameters;
    private IASTTypeId[] typeIds = NO_EXCEPTION_SPECIFICATION;
    private ICPPASTExpression noexceptExpression;
    private IASTTypeId trailingReturnType;
    private ICPPASTVirtSpecifier[] virtSpecifiers = NO_VIRT_SPECIFIERS;
    private boolean varArgs;
    private boolean pureVirtual;
    private boolean isVolatile;
    private boolean isConst;
    private boolean isMutable;
    private ICPPASTFunctionDeclarator.RefQualifier refQualifier;
    private boolean isConstexpr;
    private ICPPFunctionScope scope;

    public CPPASTFunctionDeclarator() {
    }

    public CPPASTFunctionDeclarator(IASTName name) {
        super(name);
    }

    @Override
    public CPPASTFunctionDeclarator copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CPPASTFunctionDeclarator copy(IASTNode.CopyStyle style) {
        CPPASTFunctionDeclarator copy = new CPPASTFunctionDeclarator();
        return this.copy(copy, style);
    }

    @Override
    protected <T extends CPPASTFunctionDeclarator> T copy(T copy, IASTNode.CopyStyle style) {
        copy.setVarArgs(this.varArgs);
        copy.setPureVirtual(this.pureVirtual);
        copy.setVolatile(this.isVolatile);
        copy.setConst(this.isConst);
        copy.setMutable(this.isMutable);
        copy.setRefQualifier(this.refQualifier);
        copy.setConstexpr(this.isConstexpr);
        IASTNode[] iASTNodeArray = this.getParameters();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTParameterDeclaration param = iASTNodeArray[n2];
            copy.addParameterDeclaration(param == null ? null : param.copy(style));
            ++n2;
        }
        iASTNodeArray = this.getExceptionSpecification();
        n = iASTNodeArray.length;
        n2 = 0;
        while (n2 < n) {
            IASTNode typeId = iASTNodeArray[n2];
            copy.addExceptionSpecificationTypeId(typeId == null ? null : typeId.copy(style));
            ++n2;
        }
        if (this.noexceptExpression != null) {
            copy.setNoexceptExpression(this.noexceptExpression == NOEXCEPT_DEFAULT ? this.noexceptExpression : (ICPPASTExpression)this.noexceptExpression.copy(style));
        }
        if (this.trailingReturnType != null) {
            copy.setTrailingReturnType(this.trailingReturnType.copy(style));
        }
        iASTNodeArray = this.getVirtSpecifiers();
        n = iASTNodeArray.length;
        n2 = 0;
        while (n2 < n) {
            IASTNode virtSpecifier = iASTNodeArray[n2];
            copy.addVirtSpecifier(virtSpecifier.copy(style));
            ++n2;
        }
        return super.copy(copy, style);
    }

    @Override
    public ICPPASTParameterDeclaration[] getParameters() {
        if (this.parameters == null) {
            return ICPPASTParameterDeclaration.EMPTY_CPPPARAMETERDECLARATION_ARRAY;
        }
        this.parameters = ArrayUtil.trim(this.parameters);
        return this.parameters;
    }

    @Override
    public void addParameterDeclaration(IASTParameterDeclaration parameter) {
        this.assertNotFrozen();
        if (parameter != null) {
            parameter.setParent(this);
            parameter.setPropertyInParent(FUNCTION_PARAMETER);
            this.parameters = ArrayUtil.append(ICPPASTParameterDeclaration.class, this.parameters, (ICPPASTParameterDeclaration)parameter);
        }
    }

    @Override
    public boolean takesVarArgs() {
        return this.varArgs;
    }

    @Override
    public void setVarArgs(boolean value) {
        this.assertNotFrozen();
        this.varArgs = value;
    }

    @Override
    public boolean isConst() {
        return this.isConst;
    }

    @Override
    public void setConst(boolean value) {
        this.assertNotFrozen();
        this.isConst = value;
    }

    @Override
    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public void setVolatile(boolean value) {
        this.assertNotFrozen();
        this.isVolatile = value;
    }

    @Override
    public boolean isMutable() {
        return this.isMutable;
    }

    @Override
    public void setMutable(boolean value) {
        this.assertNotFrozen();
        this.isMutable = value;
    }

    @Override
    public IASTTypeId[] getExceptionSpecification() {
        this.typeIds = ArrayUtil.trim(this.typeIds);
        return this.typeIds;
    }

    @Override
    public void setEmptyExceptionSpecification() {
        this.assertNotFrozen();
        this.typeIds = IASTTypeId.EMPTY_TYPEID_ARRAY;
    }

    @Override
    public void addExceptionSpecificationTypeId(IASTTypeId typeId) {
        this.assertNotFrozen();
        if (typeId != null) {
            assert (this.typeIds != null);
            this.typeIds = ArrayUtil.append(this.typeIds, typeId);
            typeId.setParent(this);
            typeId.setPropertyInParent(EXCEPTION_TYPEID);
        }
    }

    @Override
    public ICPPASTExpression getNoexceptExpression() {
        return this.noexceptExpression;
    }

    @Override
    public void setNoexceptExpression(ICPPASTExpression expression) {
        this.assertNotFrozen();
        this.noexceptExpression = expression;
        if (expression != null && expression != NOEXCEPT_DEFAULT) {
            expression.setParent(this);
            expression.setPropertyInParent(NOEXCEPT_EXPRESSION);
        }
    }

    @Override
    public IASTTypeId getTrailingReturnType() {
        return this.trailingReturnType;
    }

    @Override
    public void setTrailingReturnType(IASTTypeId typeId) {
        this.assertNotFrozen();
        this.trailingReturnType = typeId;
        if (typeId != null) {
            typeId.setParent(this);
            typeId.setPropertyInParent(TRAILING_RETURN_TYPE);
        }
    }

    @Override
    public boolean isPureVirtual() {
        return this.pureVirtual;
    }

    @Override
    public void setPureVirtual(boolean isPureVirtual) {
        this.assertNotFrozen();
        this.pureVirtual = isPureVirtual;
    }

    @Override
    public ICPPASTFunctionDeclarator.RefQualifier getRefQualifier() {
        return this.refQualifier;
    }

    @Override
    public void setRefQualifier(ICPPASTFunctionDeclarator.RefQualifier value) {
        this.assertNotFrozen();
        this.refQualifier = value;
    }

    @Override
    @Deprecated
    public ICPPASTConstructorChainInitializer[] getConstructorChain() {
        if (ASTQueries.findTypeRelevantDeclarator(this) == this) {
            IASTNode parent = this.getParent();
            while (!(parent instanceof IASTDeclaration)) {
                if (parent == null) break;
                parent = parent.getParent();
            }
            if (parent instanceof ICPPASTFunctionDefinition) {
                return ((ICPPASTFunctionDefinition)parent).getMemberInitializers();
            }
        }
        return ICPPASTConstructorChainInitializer.EMPTY_CONSTRUCTORCHAININITIALIZER_ARRAY;
    }

    @Override
    @Deprecated
    public void addConstructorToChain(ICPPASTConstructorChainInitializer initializer) {
        this.assertNotFrozen();
    }

    @Override
    public ICPPFunctionScope getFunctionScope() {
        if (this.scope != null) {
            return this.scope;
        }
        IASTNode node = this.getParent();
        while (!(node instanceof IASTDeclaration)) {
            if (node == null) {
                return null;
            }
            node = node.getParent();
        }
        if (node instanceof IASTParameterDeclaration) {
            return null;
        }
        if (ASTQueries.findTypeRelevantDeclarator(this) == this) {
            this.scope = new CPPFunctionScope(this);
        }
        return this.scope;
    }

    @Override
    protected boolean postAccept(ASTVisitor action) {
        ICPPASTVirtSpecifier[] virtSpecifiers;
        IASTTypeId[] ids;
        ICPPASTParameterDeclaration[] params = this.getParameters();
        int i = 0;
        while (i < params.length) {
            if (!params[i].accept(action)) {
                return false;
            }
            ++i;
        }
        IASTTypeId[] iASTTypeIdArray = ids = this.getExceptionSpecification();
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            IASTTypeId id = iASTTypeIdArray[n2];
            if (!id.accept(action)) {
                return false;
            }
            ++n2;
        }
        if (this.noexceptExpression != null && this.noexceptExpression != NOEXCEPT_DEFAULT && !this.noexceptExpression.accept(action)) {
            return false;
        }
        if (this.trailingReturnType != null && !this.trailingReturnType.accept(action)) {
            return false;
        }
        ICPPASTVirtSpecifier[] iCPPASTVirtSpecifierArray = virtSpecifiers = this.getVirtSpecifiers();
        int n3 = virtSpecifiers.length;
        n = 0;
        while (n < n3) {
            ICPPASTVirtSpecifier virtSpecifier = iCPPASTVirtSpecifierArray[n];
            if (!virtSpecifier.accept(action)) {
                return false;
            }
            ++n;
        }
        return super.postAccept(action);
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.length) {
                if (child == this.parameters[i]) {
                    other.setPropertyInParent(child.getPropertyInParent());
                    other.setParent(child.getParent());
                    this.parameters[i] = (ICPPASTParameterDeclaration)other;
                    return;
                }
                ++i;
            }
        }
        if (child == this.noexceptExpression) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.noexceptExpression = (ICPPASTExpression)other;
            return;
        }
        assert (false);
    }

    @Override
    public boolean isOverride() {
        ICPPASTVirtSpecifier[] iCPPASTVirtSpecifierArray = this.getVirtSpecifiers();
        int n = iCPPASTVirtSpecifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTVirtSpecifier virtSpecifier = iCPPASTVirtSpecifierArray[n2];
            if (virtSpecifier.getKind() == ICPPASTVirtSpecifier.SpecifierKind.Override) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void setOverride(boolean value) {
        this.assertNotFrozen();
    }

    @Override
    public boolean isFinal() {
        ICPPASTVirtSpecifier[] iCPPASTVirtSpecifierArray = this.getVirtSpecifiers();
        int n = iCPPASTVirtSpecifierArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTVirtSpecifier virtSpecifier = iCPPASTVirtSpecifierArray[n2];
            if (virtSpecifier.getKind() == ICPPASTVirtSpecifier.SpecifierKind.Final) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public void setFinal(boolean value) {
        this.assertNotFrozen();
    }

    @Override
    public ICPPASTVirtSpecifier[] getVirtSpecifiers() {
        this.virtSpecifiers = ArrayUtil.trim(this.virtSpecifiers);
        return this.virtSpecifiers;
    }

    @Override
    public void addVirtSpecifier(ICPPASTVirtSpecifier virtSpecifier) {
        this.assertNotFrozen();
        if (virtSpecifier != null) {
            assert (this.virtSpecifiers != null);
            this.virtSpecifiers = ArrayUtil.append(this.virtSpecifiers, virtSpecifier);
            virtSpecifier.setParent(this);
            virtSpecifier.setPropertyInParent(VIRT_SPECIFIER);
        }
    }

    @Override
    public void setVirtSpecifiers(ICPPASTVirtSpecifier[] newVirtSpecifiers) {
        this.assertNotFrozen();
        if (newVirtSpecifiers == null) {
            this.virtSpecifiers = NO_VIRT_SPECIFIERS;
        } else {
            this.virtSpecifiers = newVirtSpecifiers;
            ICPPASTVirtSpecifier[] iCPPASTVirtSpecifierArray = newVirtSpecifiers;
            int n = newVirtSpecifiers.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPASTVirtSpecifier virtSpecifier = iCPPASTVirtSpecifierArray[n2];
                virtSpecifier.setParent(this);
                virtSpecifier.setPropertyInParent(VIRT_SPECIFIER);
                ++n2;
            }
        }
    }

    @Override
    public ICPPEvaluation getNoexceptEvaluation() {
        if (this.getNoexceptExpression() != null) {
            return this.getNoexceptExpression().getEvaluation();
        }
        if (this.getExceptionSpecification() == IASTTypeId.EMPTY_TYPEID_ARRAY) {
            return NOEXCEPT_TRUE;
        }
        return null;
    }

    @Override
    public boolean isConstexpr() {
        return this.isConstexpr;
    }

    @Override
    public void setConstexpr(boolean value) {
        this.assertNotFrozen();
        this.isConstexpr = value;
    }
}

