/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser;

import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.filter.parser.FilterSimpleExpression;

public class FilterExpression
implements Predicate<Multimap<String, Object>> {
    private final List<Object> fElements;

    public FilterExpression(List<Object> elements) {
        this.fElements = elements;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean test(Multimap<String, Object> data) {
        if (this.fElements.isEmpty()) {
            return false;
        }
        int index = 0;
        boolean result = false;
        String operator = "||";
        while (index < this.fElements.size()) {
            Object element = this.fElements.get(index);
            if (index % 2 == 0) {
                if (element instanceof FilterSimpleExpression) {
                    expression = (FilterSimpleExpression)element;
                    result = FilterExpression.handleOperator(result, operator, ((FilterSimpleExpression)expression).test(data));
                } else {
                    if (!(element instanceof FilterExpression)) return false;
                    expression = (FilterExpression)element;
                    result = FilterExpression.handleOperator(result, operator, ((FilterExpression)expression).test(data));
                }
            } else {
                if (!(element instanceof String)) {
                    return false;
                }
                operator = (String)element;
            }
            ++index;
        }
        return result;
    }

    private static boolean handleOperator(boolean left, String operator, boolean right) {
        return operator.equals("||") ? left || right : left && right;
    }
}

