/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core.backend.historytree;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.Deque;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTConfig;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;

public interface IHistoryTree {
    public static final int TREE_HEADER_SIZE = 4096;

    public void closeTree(long var1);

    public long getTreeStart();

    public long getTreeEnd();

    public int getNodeCount();

    public HTNode getRootNode();

    public FileInputStream supplyATReader();

    public File supplyATWriterFile();

    public long supplyATWriterFilePos();

    public HTNode readNode(int var1) throws ClosedChannelException;

    public HTNode readNode(Deque<Integer> var1) throws ClosedChannelException;

    public void writeNode(HTNode var1);

    public void closeFile();

    public void deleteFile();

    public void insertInterval(HTInterval var1) throws TimeRangeException;

    public long getFileSize();

    public static void seekFCToNodePos(FileChannel channel, long blockSize, long blockNb) throws IOException {
        channel.position(4096L + blockNb * blockSize);
    }

    public static interface IHTNodeFactory {
        public HTNode createCoreNode(HTConfig var1, int var2, int var3, long var4) throws IOException;

        public HTNode createLeafNode(HTConfig var1, int var2, int var3, long var4) throws IOException;
    }
}

