/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.trace.experiment;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.PriorityQueue;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;

public final class TmfExperimentContext
extends TmfContext {
    private final ITmfContext[] fContexts;
    private final PriorityQueue<ContextTuple> fPriority;

    public TmfExperimentContext(int nbTraces) {
        if (nbTraces < 0) {
            throw new IllegalArgumentException("TmfExperimentContext size cannot be negative");
        }
        this.fContexts = new ITmfContext[nbTraces];
        this.fPriority = new PriorityQueue(Math.max(1, nbTraces), null);
    }

    @Override
    public void dispose() {
        ITmfContext[] iTmfContextArray = this.fContexts;
        int n = this.fContexts.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfContext context = iTmfContextArray[n2];
            context.dispose();
            ++n2;
        }
        super.dispose();
    }

    public void setContent(int traceIndex, ITmfContext ctx, ITmfEvent event) {
        this.fContexts[traceIndex] = ctx;
        if (event != null && ctx != null) {
            this.fPriority.add(new ContextTuple(traceIndex, event, ctx));
        }
    }

    public ContextTuple getNext() {
        return this.fPriority.poll();
    }

    @VisibleForTesting
    public ITmfContext[] getContexts() {
        return Arrays.copyOf(this.fContexts, this.fContexts.length);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.fContexts);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof TmfExperimentContext)) {
            return false;
        }
        TmfExperimentContext o = (TmfExperimentContext)other;
        return Arrays.equals(this.fContexts, o.fContexts);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("TmfExperimentContext [\n");
        sb.append("\tfLocation=" + String.valueOf(this.getLocation()) + ", fRank=" + this.getRank() + "\n");
        sb.append("\tfContexts=[");
        int i = 0;
        while (i < this.fContexts.length) {
            sb.append("(" + String.valueOf(this.fContexts[i].getLocation()) + "," + this.fContexts[i].getRank() + (i < this.fContexts.length - 1 ? ")," : ")]\n"));
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    public class ContextTuple
    implements Comparable<ContextTuple> {
        private final int fIndex;
        private final @NonNull ITmfEvent fEvent;
        private final @NonNull ITmfContext fContext;

        private ContextTuple(@NonNull int index, @NonNull ITmfEvent event, ITmfContext context) {
            this.fIndex = index;
            this.fEvent = event;
            this.fContext = context;
        }

        public int getIndex() {
            return this.fIndex;
        }

        public @NonNull ITmfEvent getEvent() {
            return this.fEvent;
        }

        public @NonNull ITmfContext getContext() {
            return this.fContext;
        }

        @Override
        public int compareTo(ContextTuple o) {
            int timeStampComparison = this.fEvent.getTimestamp().compareTo(o.fEvent.getTimestamp());
            if (timeStampComparison != 0) {
                return timeStampComparison;
            }
            return Integer.compare(this.fIndex, o.fIndex);
        }
    }
}

