/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junitlauncher.confined;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.JUnitLauncherTask;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.ListenerDefinition;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.NamedTest;
import org.apache.tools.ant.taskdefs.optional.junitlauncher.confined.TestDefinition;

public class SingleTestClass
extends TestDefinition
implements NamedTest {
    private String testClass;
    private Set<String> testMethods;

    public void setName(String test) {
        if (test == null || test.trim().isEmpty()) {
            throw new IllegalArgumentException("Test name cannot be null or empty string");
        }
        this.testClass = test;
    }

    @Override
    public String getName() {
        return this.testClass;
    }

    public void setMethods(String methods) {
        if (methods == null || methods.trim().isEmpty()) {
            this.testMethods = Collections.emptySet();
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(methods, ",");
        if (!tokenizer.hasMoreTokens()) {
            this.testMethods = Collections.emptySet();
            return;
        }
        this.testMethods = new LinkedHashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            String method = tokenizer.nextToken().trim();
            if (method.isEmpty()) continue;
            this.testMethods.add(method);
        }
    }

    boolean hasMethodsSpecified() {
        return this.testMethods != null && !this.testMethods.isEmpty();
    }

    public String[] getMethods() {
        if (!this.hasMethodsSpecified()) {
            return null;
        }
        return this.testMethods.toArray(new String[0]);
    }

    @Override
    protected List<TestDefinition.ForkedRepresentation> toForkedRepresentations() throws IllegalStateException {
        if (this.forkDefinition == null) {
            throw new IllegalStateException("tests haven't been configured to run in forked JVM");
        }
        return Collections.singletonList(new SingleTestFork());
    }

    public static TestDefinition fromForkedRepresentation(XMLStreamReader reader) throws XMLStreamException {
        String excludeEngs;
        String includeEngs;
        String outDir;
        String halt;
        reader.require(1, null, "test");
        SingleTestClass testDefinition = new SingleTestClass();
        String testClassName = SingleTestClass.requireAttributeValue(reader, "classname");
        testDefinition.setName(testClassName);
        String methodNames = reader.getAttributeValue(null, "methods");
        if (methodNames != null) {
            testDefinition.setMethods(methodNames);
        }
        if ((halt = reader.getAttributeValue(null, "haltOnFailure")) != null) {
            testDefinition.setHaltOnFailure(Boolean.parseBoolean(halt));
        }
        if ((outDir = reader.getAttributeValue(null, "outDir")) != null) {
            testDefinition.setOutputDir(new File(outDir));
        }
        if ((includeEngs = reader.getAttributeValue(null, "includeEngines")) != null) {
            testDefinition.setIncludeEngines(includeEngs);
        }
        if ((excludeEngs = reader.getAttributeValue(null, "excludeEngines")) != null) {
            testDefinition.setExcludeEngines(excludeEngs);
        }
        while (reader.nextTag() != 2) {
            reader.require(1, null, "listener");
            testDefinition.addConfiguredListener(ListenerDefinition.fromForkedRepresentation(reader));
        }
        return testDefinition;
    }

    private static String requireAttributeValue(XMLStreamReader reader, String attrName) throws XMLStreamException {
        String val = reader.getAttributeValue(null, attrName);
        if (val != null) {
            return val;
        }
        throw new XMLStreamException("Attribute " + attrName + " is missing at " + reader.getLocation());
    }

    private final class SingleTestFork
    extends TestDefinition.ForkedRepresentation {
        private SingleTestFork() {
        }

        @Override
        public void write(JUnitLauncherTask task, XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("test");
            writer.writeAttribute("classname", SingleTestClass.this.testClass);
            if (SingleTestClass.this.testMethods != null) {
                StringBuilder sb = new StringBuilder();
                for (String method : SingleTestClass.this.testMethods) {
                    if (sb.length() != 0) {
                        sb.append(",");
                    }
                    sb.append(method);
                }
                writer.writeAttribute("methods", sb.toString());
            }
            if (SingleTestClass.this.haltOnFailure != null) {
                writer.writeAttribute("haltOnFailure", SingleTestClass.this.haltOnFailure.toString());
            }
            if (SingleTestClass.this.outputDir != null) {
                writer.writeAttribute("outDir", SingleTestClass.this.outputDir.getPath());
            }
            if (SingleTestClass.this.includeEngines != null) {
                writer.writeAttribute("includeEngines", SingleTestClass.this.includeEngines);
            }
            if (SingleTestClass.this.excludeEngines != null) {
                writer.writeAttribute("excludeEngines", SingleTestClass.this.excludeEngines);
            }
            if (SingleTestClass.this.listeners != null) {
                for (ListenerDefinition listenerDef : SingleTestClass.this.getListeners()) {
                    if (!listenerDef.shouldUse(task.getProject())) continue;
                    listenerDef.toForkedRepresentation(writer);
                }
            }
            writer.writeEndElement();
        }
    }
}

