/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.ui;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import java.net.PasswordAuthentication;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jsch.ui.UserInfoPrompter;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IUserAuthenticatorService;
import org.eclipse.swt.widgets.Display;

public class JSchUserAuthenticator
implements IUserAuthenticatorService {
    private final IRemoteConnection remoteConnection;
    private UserInfoPrompter prompter;

    public JSchUserAuthenticator(IRemoteConnection conn) {
        this.remoteConnection = conn;
        try {
            String username = conn.getAttribute("JSCH_USERNAME_ATTR");
            String address = conn.getAttribute("JSCH_ADDRESS_ATTR");
            this.prompter = new UserInfoPrompter(new JSch().getSession(username, address));
        }
        catch (JSchException jSchException) {
            // empty catch block
        }
    }

    public IRemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    public PasswordAuthentication prompt(String username, String message) {
        if (this.prompter.promptPassword(message)) {
            String sessionUserName = this.prompter.getSession().getUserName();
            if (sessionUserName != null) {
                username = sessionUserName;
            }
            PasswordAuthentication auth = new PasswordAuthentication(username, this.prompter.getPassword().toCharArray());
            return auth;
        }
        return null;
    }

    public String[] prompt(String destination, String name, String message, String[] prompt, boolean[] echo) {
        return this.prompter.promptKeyboardInteractive(destination, name, message, prompt, echo);
    }

    public int prompt(final int promptType, final String title, final String message, int[] promptResponses, final int defaultResponseIndex) {
        final Display display = this.getDisplay();
        final int[] retval = new int[1];
        final String[] buttons = new String[promptResponses.length];
        int i = 0;
        while (i < promptResponses.length) {
            int prompt = promptResponses[i];
            switch (prompt) {
                case 0: {
                    buttons[i] = IDialogConstants.OK_LABEL;
                    break;
                }
                case 1: {
                    buttons[i] = IDialogConstants.CANCEL_LABEL;
                    break;
                }
                case 3: {
                    buttons[i] = IDialogConstants.NO_LABEL;
                    break;
                }
                case 2: {
                    buttons[i] = IDialogConstants.YES_LABEL;
                }
            }
            ++i;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(display.getActiveShell(), title, null, message, promptType, buttons, defaultResponseIndex);
                retval[0] = dialog.open();
            }
        });
        return promptResponses[retval[0]];
    }

    private Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static class Factory
    implements IRemoteConnection.Service.Factory {
        public <T extends IRemoteConnection.Service> T getService(IRemoteConnection connection, Class<T> service) {
            if (IUserAuthenticatorService.class.equals(service)) {
                return (T)new JSchUserAuthenticator(connection);
            }
            return null;
        }
    }
}

