/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.IObjectContributor;
import org.eclipse.ui.internal.LegacyResourceSupport;

public abstract class ObjectContributorManager
implements IExtensionChangeHandler {
    protected Map contributors = new Hashtable(5);
    protected Map objectLookup = null;
    protected Map resourceAdapterLookup = null;
    protected Map adaptableLookup = null;
    protected Set contributorRecordSet = new HashSet(5);

    public ObjectContributorManager() {
        String extensionPointId = this.getExtensionPointFilter();
        if (extensionPointId != null) {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", extensionPointId);
            PlatformUI.getApplication().map(MContext::getContext).map(ctx -> (IExtensionTracker)ctx.get(IExtensionTracker.class)).orElseThrow(PlatformUI.NO_WORKBENCH).registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)extensionPoint));
        }
    }

    protected String getExtensionPointFilter() {
        return null;
    }

    private void addContributorsFor(List types, List result) {
        for (Class clazz : types) {
            List contributorList = (List)this.contributors.get(clazz.getName());
            if (contributorList == null) continue;
            result.addAll(contributorList);
        }
    }

    protected final List computeClassOrder(Class extensibleClass) {
        ArrayList result = new ArrayList(4);
        Class clazz = extensibleClass;
        while (clazz != null) {
            result.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    protected final List computeInterfaceOrder(List classList) {
        ArrayList result = new ArrayList(4);
        HashMap seen = new HashMap(4);
        Iterator list = classList.iterator();
        while (list.hasNext()) {
            Class[] interfaces = ((Class)list.next()).getInterfaces();
            this.internalComputeInterfaceOrder(interfaces, result, seen);
        }
        return result;
    }

    public void flushLookup() {
        this.objectLookup = null;
        this.resourceAdapterLookup = null;
        this.adaptableLookup = null;
    }

    private void cacheResourceAdapterLookup(Class adapterClass, List results) {
        if (this.resourceAdapterLookup == null) {
            this.resourceAdapterLookup = new HashMap();
        }
        this.resourceAdapterLookup.put(adapterClass, results);
    }

    private void cacheAdaptableLookup(String adapterClass, List results) {
        if (this.adaptableLookup == null) {
            this.adaptableLookup = new HashMap();
        }
        this.adaptableLookup.put(adapterClass, results);
    }

    private void cacheObjectLookup(Class objectClass, List results) {
        if (this.objectLookup == null) {
            this.objectLookup = new HashMap();
        }
        this.objectLookup.put(objectClass, results);
    }

    public Collection getContributors() {
        return Collections.unmodifiableCollection(this.contributors.values());
    }

    protected List addContributorsFor(Class objectClass) {
        List classList = this.computeClassOrder(objectClass);
        ArrayList result = new ArrayList();
        this.addContributorsFor(classList, result);
        classList = this.computeInterfaceOrder(classList);
        this.addContributorsFor(classList, result);
        return result;
    }

    public boolean hasContributorsFor(Object object) {
        List contributors = this.getContributors(object);
        return contributors.size() > 0;
    }

    private void internalComputeInterfaceOrder(Class[] interfaces, List result, Map seen) {
        ArrayList<Class> newInterfaces = new ArrayList<Class>(seen.size());
        Class[] classArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class currentInterface = classArray[n2];
            if (seen.get(currentInterface) == null) {
                result.add(currentInterface);
                seen.put(currentInterface, currentInterface);
                newInterfaces.add(currentInterface);
            }
            ++n2;
        }
        Iterator newList = newInterfaces.iterator();
        while (newList.hasNext()) {
            this.internalComputeInterfaceOrder(((Class)newList.next()).getInterfaces(), result, seen);
        }
    }

    public boolean isApplicableTo(IStructuredSelection selection, IObjectContributor contributor) {
        for (Object element : selection) {
            if (contributor.isApplicableTo(element)) continue;
            return false;
        }
        return true;
    }

    public boolean isApplicableTo(List list, IObjectContributor contributor) {
        for (Object element : list) {
            if (contributor.isApplicableTo(element)) continue;
            return false;
        }
        return true;
    }

    public void registerContributor(IObjectContributor contributor, String targetType) {
        ArrayList<IObjectContributor> contributorList = (ArrayList<IObjectContributor>)this.contributors.get(targetType);
        if (contributorList == null) {
            contributorList = new ArrayList<IObjectContributor>(5);
            this.contributors.put(targetType, contributorList);
        }
        contributorList.add(contributor);
        this.flushLookup();
        IConfigurationElement element = (IConfigurationElement)Adapters.adapt((Object)contributor, IConfigurationElement.class);
        if (element != null) {
            ContributorRecord contributorRecord = new ContributorRecord(contributor, targetType);
            this.contributorRecordSet.add(contributorRecord);
            PlatformUI.getApplication().map(MContext::getContext).map(ctx -> (IExtensionTracker)ctx.get(IExtensionTracker.class)).orElseThrow(PlatformUI.NO_WORKBENCH).registerObject(element.getDeclaringExtension(), (Object)contributorRecord, 2);
        }
    }

    public void unregisterAllContributors() {
        this.contributors = new Hashtable(5);
        this.flushLookup();
    }

    public void unregisterContributor(IObjectContributor contributor, String targetType) {
        List contributorList = (List)this.contributors.get(targetType);
        if (contributorList == null) {
            return;
        }
        contributorList.remove(contributor);
        if (contributorList.isEmpty()) {
            this.contributors.remove(targetType);
        }
        this.flushLookup();
    }

    public void unregisterContributors(String targetType) {
        this.contributors.remove(targetType);
        this.flushLookup();
    }

    protected List getContributors(Object object) {
        Object resource = LegacyResourceSupport.getAdaptedContributorResource(object);
        ArrayList<String> adapters = new ArrayList<String>(Arrays.asList(Platform.getAdapterManager().computeAdapterTypes(object.getClass())));
        this.removeCommonAdapters(adapters, Arrays.asList(object.getClass()));
        List contributors = new ArrayList();
        ObjectContributorManager.addAll(contributors, this.getObjectContributors(object.getClass()));
        if (resource != null) {
            ObjectContributorManager.addAll(contributors, this.getResourceContributors(resource.getClass()));
        }
        if (adapters != null) {
            for (String adapter : adapters) {
                ObjectContributorManager.addAll(contributors, this.getAdaptableContributors(adapter));
            }
        }
        return (contributors = ObjectContributorManager.removeDups(contributors)).isEmpty() ? Collections.EMPTY_LIST : new ArrayList(contributors);
    }

    protected List getObjectContributors(Class objectClass) {
        List<Object> objectList = null;
        if (this.objectLookup != null) {
            objectList = (List)this.objectLookup.get(objectClass);
        }
        if (objectList == null) {
            objectList = this.addContributorsFor(objectClass);
            objectList = objectList.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(objectList);
            this.cacheObjectLookup(objectClass, objectList);
        }
        return objectList;
    }

    protected List getResourceContributors(Class resourceClass) {
        List<Object> resourceList = null;
        if (this.resourceAdapterLookup != null) {
            resourceList = (List)this.resourceAdapterLookup.get(resourceClass);
        }
        if (resourceList == null) {
            resourceList = this.addContributorsFor(resourceClass);
            resourceList = resourceList.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.filterOnlyAdaptableContributors(resourceList));
            this.cacheResourceAdapterLookup(resourceClass, resourceList);
        }
        return resourceList;
    }

    protected List getAdaptableContributors(String adapterType) {
        List<Object> adaptableList = null;
        if (this.adaptableLookup != null) {
            adaptableList = (List)this.adaptableLookup.get(adapterType);
        }
        if (adaptableList == null) {
            adaptableList = LegacyResourceSupport.isResourceType(adapterType) || LegacyResourceSupport.isResourceMappingType(adapterType) ? Collections.EMPTY_LIST : ((adaptableList = (List)this.contributors.get(adapterType)) == null || adaptableList.isEmpty() ? Collections.EMPTY_LIST : Collections.unmodifiableList(this.filterOnlyAdaptableContributors(adaptableList)));
            this.cacheAdaptableLookup(adapterType, adaptableList);
        }
        return adaptableList;
    }

    protected void removeCommonAdapters(List adapters, List results) {
        for (Class clazz : results) {
            List commonTypes = this.computeCombinedOrder(clazz);
            for (Class type : commonTypes) {
                adapters.remove(type.getName());
            }
        }
    }

    protected List computeCombinedOrder(Class inputClass) {
        ArrayList result = new ArrayList(4);
        Class clazz = inputClass;
        while (clazz != null) {
            result.add(clazz);
            Class<?>[] interfaces = clazz.getInterfaces();
            result.addAll(Arrays.asList(interfaces));
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    private List filterOnlyAdaptableContributors(List contributors) {
        ArrayList<IObjectContributor> adaptableContributors = null;
        for (IObjectContributor c : contributors) {
            if (!c.canAdapt()) continue;
            if (adaptableContributors == null) {
                adaptableContributors = new ArrayList<IObjectContributor>();
            }
            adaptableContributors.add(c);
        }
        return adaptableContributors == null ? Collections.EMPTY_LIST : adaptableContributors;
    }

    public void removeExtension(IExtension source, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ContributorRecord) {
                ContributorRecord contributorRecord = (ContributorRecord)object;
                this.unregisterContributor(contributorRecord.contributor, contributorRecord.objectClassName);
                this.contributorRecordSet.remove(contributorRecord);
            }
            ++n2;
        }
    }

    public void dispose() {
        if (this.getExtensionPointFilter() != null) {
            PlatformUI.getWorkbench().getExtensionTracker().unregisterHandler((IExtensionChangeHandler)this);
        }
    }

    protected List getContributors(List elements) {
        ArrayList commonAdapters = new ArrayList();
        List commonClasses = this.getCommonClasses(elements, commonAdapters);
        Class resourceClass = this.getCommonResourceClass(elements);
        Class<?> resourceMappingClass = this.getResourceMappingClass(elements);
        List contributors = new ArrayList();
        if (resourceClass != null) {
            ObjectContributorManager.addAll(contributors, this.getResourceContributors(resourceClass));
        }
        if (commonClasses != null && !commonClasses.isEmpty()) {
            for (Object commonClass : commonClasses) {
                List results = this.getObjectContributors((Class)commonClass);
                ObjectContributorManager.addAll(contributors, results);
            }
        }
        if (resourceMappingClass == null) {
            resourceMappingClass = LegacyResourceSupport.getResourceMappingClass();
            if (resourceMappingClass != null && commonAdapters.contains(resourceMappingClass.getName())) {
                ObjectContributorManager.addAll(contributors, this.getResourceContributors(resourceMappingClass));
            }
        } else {
            contributors.addAll(this.getResourceContributors(resourceMappingClass));
        }
        if (!commonAdapters.isEmpty()) {
            for (String adapter : commonAdapters) {
                ObjectContributorManager.addAll(contributors, this.getAdaptableContributors(adapter));
            }
        }
        return (contributors = ObjectContributorManager.removeDups(contributors)).isEmpty() ? Collections.EMPTY_LIST : new ArrayList(contributors);
    }

    private static void addAll(Collection collection, List toAdd) {
        for (Object element : toAdd) {
            collection.add(element);
        }
    }

    private static List removeDups(List list) {
        if (list.size() <= 1) {
            return list;
        }
        HashSet set = new HashSet(list);
        if (set.size() == list.size()) {
            return list;
        }
        ArrayList result = new ArrayList(set.size());
        for (Object o : list) {
            if (!set.remove(o)) continue;
            result.add(o);
        }
        return result;
    }

    private List getCommonClasses(List objects, List commonAdapters) {
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        if (this.allSameClass(objects)) {
            Class<?> clazz = objects.get(0).getClass();
            commonAdapters.addAll(Arrays.asList(Platform.getAdapterManager().computeAdapterTypes(clazz)));
            ArrayList result = new ArrayList(1);
            result.add(clazz);
            return result;
        }
        List classes = this.computeClassOrder(objects.get(0).getClass());
        List adapters = this.computeAdapterOrder(classes);
        List interfaces = this.computeInterfaceOrder(classes);
        ArrayList lastCommonTypes = new ArrayList();
        boolean classesEmpty = classes.isEmpty();
        boolean interfacesEmpty = interfaces.isEmpty();
        int i = 1;
        while (i < objects.size()) {
            List otherAdapters;
            List otherClasses = this.computeClassOrder(objects.get(i).getClass());
            if (!classesEmpty) {
                classesEmpty = this.extractCommonClasses(classes, otherClasses);
            }
            List otherInterfaces = this.computeInterfaceOrder(otherClasses);
            if (!interfacesEmpty) {
                interfacesEmpty = this.extractCommonClasses(interfaces, otherInterfaces);
            }
            ArrayList classesAndInterfaces = new ArrayList(otherClasses);
            if (otherInterfaces != null) {
                classesAndInterfaces.addAll(otherInterfaces);
            }
            if ((otherAdapters = this.computeAdapterOrder(classesAndInterfaces)).isEmpty() && !adapters.isEmpty()) {
                this.removeNonCommonAdapters(adapters, classesAndInterfaces);
            } else if (adapters.isEmpty()) {
                this.removeNonCommonAdapters(otherAdapters, lastCommonTypes);
                if (!otherAdapters.isEmpty()) {
                    adapters.addAll(otherAdapters);
                }
            } else {
                Iterator it = adapters.iterator();
                while (it.hasNext()) {
                    String adapter = (String)it.next();
                    if (otherAdapters.contains(adapter)) continue;
                    it.remove();
                }
            }
            lastCommonTypes.clear();
            lastCommonTypes.addAll(classes);
            lastCommonTypes.addAll(interfaces);
            if (interfacesEmpty && classesEmpty && adapters.isEmpty()) {
                return null;
            }
            ++i;
        }
        ArrayList results = new ArrayList(4);
        ArrayList superClasses = new ArrayList(4);
        if (!classesEmpty) {
            for (Object clazz : classes) {
                if (clazz == null) continue;
                superClasses.add(clazz);
            }
            if (!superClasses.isEmpty()) {
                results.add(superClasses.get(0));
            }
        }
        if (!interfacesEmpty) {
            this.removeCommonInterfaces(superClasses, interfaces, results);
        }
        if (!adapters.isEmpty()) {
            this.removeCommonAdapters(adapters, results);
            commonAdapters.addAll(adapters);
        }
        return results;
    }

    private boolean allSameClass(List objects) {
        int size = objects.size();
        if (size <= 1) {
            return true;
        }
        Class<?> clazz = objects.get(0).getClass();
        int i = 1;
        while (i < size) {
            if (!objects.get(i).getClass().equals(clazz)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean extractCommonClasses(List classes, List otherClasses) {
        boolean classesEmpty = true;
        if (otherClasses.isEmpty()) {
            classes.clear();
        } else {
            int j = 0;
            while (j < classes.size()) {
                if (classes.get(j) != null) {
                    classesEmpty = false;
                    if (!otherClasses.contains(classes.get(j))) {
                        classes.set(j, null);
                    }
                }
                ++j;
            }
        }
        return classesEmpty;
    }

    private void removeNonCommonAdapters(List adapters, List classes) {
        int i = 0;
        while (i < classes.size()) {
            Class clazz;
            String name;
            Object o = classes.get(i);
            if (o != null && adapters.contains(name = (clazz = (Class)o).getName())) {
                return;
            }
            ++i;
        }
        adapters.clear();
    }

    private void removeCommonInterfaces(List superClasses, List types, List results) {
        List dropInterfaces = null;
        if (!superClasses.isEmpty()) {
            dropInterfaces = this.computeInterfaceOrder(superClasses);
        }
        int j = 0;
        while (j < types.size()) {
            if (types.get(j) != null && dropInterfaces != null && !dropInterfaces.contains(types.get(j))) {
                results.add(types.get(j));
            }
            ++j;
        }
    }

    private List computeAdapterOrder(List classList) {
        HashSet<String> result = new HashSet<String>(4);
        IAdapterManager adapterMgr = Platform.getAdapterManager();
        for (Class clazz : classList) {
            String[] stringArray = adapterMgr.computeAdapterTypes(clazz);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String adapter = stringArray[n2];
                if (!result.contains(adapter)) {
                    result.add(adapter);
                }
                ++n2;
            }
        }
        return new ArrayList(result);
    }

    private Class getCommonResourceClass(List objects) {
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        Class<?> resourceClass = LegacyResourceSupport.getResourceClass();
        if (resourceClass == null) {
            return null;
        }
        ArrayList<Object> testList = new ArrayList<Object>(objects.size());
        int i = 0;
        while (i < objects.size()) {
            Object object = objects.get(i);
            if (object instanceof IAdaptable) {
                if (!resourceClass.isInstance(object)) {
                    Object resource = LegacyResourceSupport.getAdaptedContributorResource(object);
                    if (resource == null) {
                        return null;
                    }
                    testList.add(resource);
                }
            } else {
                return null;
            }
            ++i;
        }
        return this.getCommonClass(testList);
    }

    private Class getResourceMappingClass(List objects) {
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        Class<?> resourceMappingClass = LegacyResourceSupport.getResourceMappingClass();
        if (resourceMappingClass == null) {
            return null;
        }
        for (Object object : objects) {
            if (object instanceof IAdaptable) {
                Object resourceMapping;
                if (resourceMappingClass.isInstance(object) || (resourceMapping = LegacyResourceSupport.getAdaptedContributorResourceMapping(object)) != null) continue;
                return null;
            }
            return null;
        }
        return resourceMappingClass;
    }

    private Class getCommonClass(List objects) {
        if (objects == null || objects.isEmpty()) {
            return null;
        }
        Class commonClass = objects.get(0).getClass();
        if (objects.size() == 1) {
            return commonClass;
        }
        int i = 1;
        while (i < objects.size()) {
            Object object = objects.get(i);
            Class<?> newClass = object.getClass();
            if (!newClass.equals(commonClass) && (commonClass = this.getCommonClass(commonClass, newClass)) == null) {
                return null;
            }
            ++i;
        }
        return commonClass;
    }

    private Class getCommonClass(Class class1, Class class2) {
        List list1 = this.computeCombinedOrder(class1);
        List list2 = this.computeCombinedOrder(class2);
        for (Object element1 : list1) {
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                Class candidate1 = (Class)element1;
                Object element2 = iterator.next();
                Class candidate2 = (Class)element2;
                if (!candidate1.equals(candidate2)) continue;
                return candidate1;
            }
        }
        return null;
    }

    private static class ContributorRecord {
        String objectClassName;
        IObjectContributor contributor;

        public ContributorRecord(IObjectContributor contributor, String targetType) {
            this.contributor = contributor;
            this.objectClassName = targetType;
        }
    }
}

