/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.enumeration;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeSpecifierListParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class EnumContainerParser
extends AbstractScopedCommonTreeParser {
    public static final EnumContainerParser INSTANCE = new EnumContainerParser();

    private EnumContainerParser() {
    }

    @Override
    public IntegerDeclaration parse(ICTFMetadataNode enumContainerType, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        CTFTrace trace;
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        Param parameter = (Param)param;
        DeclarationScope scope = parameter.fCurrentScope;
        ICTFMetadataNode typeSpecifierList = enumContainerType.getChild(0);
        IDeclaration decl = TypeSpecifierListParser.INSTANCE.parse(typeSpecifierList, new TypeSpecifierListParser.Param(trace = ((Param)param).fTrace, null, null, scope));
        if (decl instanceof IntegerDeclaration) {
            return (IntegerDeclaration)decl;
        }
        throw new ParseException("enum container type must be an integer");
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fCurrentScope;
        private final CTFTrace fTrace;

        public Param(CTFTrace trace, DeclarationScope currentScope) {
            this.fTrace = trace;
            this.fCurrentScope = currentScope;
        }
    }
}

