/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.internal.hppc.IntArrayList;
import org.apache.lucene.internal.hppc.IntCursor;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.RollingBuffer;

public final class FlattenGraphFilter
extends TokenFilter {
    private final RollingBuffer<InputNode> inputNodes = new RollingBuffer<InputNode>(){

        protected InputNode newInstance() {
            return new InputNode();
        }
    };
    private final RollingBuffer<OutputNode> outputNodes = new RollingBuffer<OutputNode>(){

        protected OutputNode newInstance() {
            return new OutputNode();
        }
    };
    private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLenAtt = (PositionLengthAttribute)this.addAttribute(PositionLengthAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private int inputFrom;
    private int outputFrom;
    private boolean done;
    private int lastOutputFrom;
    private int finalOffset;
    private int finalPosInc;
    private int maxLookaheadUsed;
    private int lastStartOffset;

    public FlattenGraphFilter(TokenStream in) {
        super(in);
    }

    private boolean releaseBufferedToken() {
        while (this.outputFrom < this.outputNodes.getMaxPos()) {
            OutputNode output = (OutputNode)this.outputNodes.get(this.outputFrom);
            if (output.inputNodes.isEmpty()) {
                ++this.outputFrom;
                continue;
            }
            int maxToNode = -1;
            for (IntCursor inputNodeID : output.inputNodes) {
                InputNode inputNode = (InputNode)this.inputNodes.get(inputNodeID.value);
                assert (inputNode.outputNode == this.outputFrom);
                maxToNode = Math.max(maxToNode, inputNode.maxToNode);
            }
            if (maxToNode <= this.inputFrom || this.done) {
                assert (output.nextOut < output.inputNodes.size()) : "output.nextOut=" + output.nextOut + " vs output.inputNodes.size()=" + output.inputNodes.size();
                InputNode inputNode = (InputNode)this.inputNodes.get(output.inputNodes.get(output.nextOut));
                if (this.done && inputNode.tokens.size() == 0 && this.outputFrom >= this.outputNodes.getMaxPos()) {
                    return false;
                }
                if (inputNode.tokens.size() == 0) {
                    assert (inputNode.nextOut == 0);
                    if (output.inputNodes.size() > 1) {
                        ++output.nextOut;
                        if (output.nextOut < output.inputNodes.size()) continue;
                    }
                    this.freeBefore(output);
                    continue;
                }
                assert (inputNode.nextOut < inputNode.tokens.size());
                this.restoreState(inputNode.tokens.get(inputNode.nextOut));
                assert (this.outputFrom >= this.lastOutputFrom);
                this.posIncAtt.setPositionIncrement(this.outputFrom - this.lastOutputFrom);
                int toInputNodeID = inputNode.node + this.posLenAtt.getPositionLength();
                InputNode toInputNode = (InputNode)this.inputNodes.get(toInputNodeID);
                assert (toInputNode.outputNode > this.outputFrom);
                this.posLenAtt.setPositionLength(toInputNode.outputNode - this.outputFrom);
                this.lastOutputFrom = this.outputFrom;
                ++inputNode.nextOut;
                OutputNode outputEndNode = (OutputNode)this.outputNodes.get(toInputNode.outputNode);
                int startOffset = Math.max(this.lastStartOffset, output.startOffset);
                int endOffset = Math.max(startOffset, outputEndNode.endOffset);
                this.offsetAtt.setOffset(startOffset, endOffset);
                this.lastStartOffset = startOffset;
                if (inputNode.nextOut == inputNode.tokens.size()) {
                    ++output.nextOut;
                    if (output.nextOut == output.inputNodes.size()) {
                        this.freeBefore(output);
                    }
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void freeBefore(OutputNode output) {
        ++this.outputFrom;
        int freeBefore = output.inputNodes.stream().min().orElseThrow();
        assert (((OutputNode)this.outputNodes.get((int)this.outputFrom)).inputNodes.stream().filter(n -> freeBefore > n).count() == 0L) : "FreeBefore " + freeBefore + " will free in use nodes";
        this.inputNodes.freeBefore(freeBefore);
        this.outputNodes.freeBefore(this.outputFrom);
    }

    public boolean incrementToken() throws IOException {
        while (!this.releaseBufferedToken()) {
            if (this.done) {
                return false;
            }
            if (this.input.incrementToken()) {
                int outputEndNode;
                int positionIncrement = this.posIncAtt.getPositionIncrement();
                this.inputFrom += positionIncrement;
                int startOffset = this.offsetAtt.startOffset();
                int endOffset = this.offsetAtt.endOffset();
                int inputTo = this.inputFrom + this.posLenAtt.getPositionLength();
                InputNode src = (InputNode)this.inputNodes.get(this.inputFrom);
                if (src.node == -1) {
                    this.recoverFromHole(src, startOffset, positionIncrement);
                } else {
                    OutputNode outSrc = (OutputNode)this.outputNodes.get(src.outputNode);
                    if (positionIncrement > 1 && src.outputNode - ((InputNode)this.inputNodes.get((int)(this.inputFrom - positionIncrement))).outputNode <= 1 && ((InputNode)this.inputNodes.get((int)(this.inputFrom - positionIncrement))).minToNode != this.inputFrom) {
                        assert (((InputNode)this.inputNodes.get((int)this.inputFrom)).tokens.isEmpty()) : "about to remove non empty edge";
                        outSrc.inputNodes.removeElement(this.inputFrom);
                        src.outputNode = -1;
                        int prevEndOffset = outSrc.endOffset;
                        outSrc = this.recoverFromHole(src, startOffset, positionIncrement);
                        outSrc.endOffset = prevEndOffset;
                    }
                    if (outSrc.startOffset == -1 || startOffset > outSrc.startOffset) {
                        outSrc.startOffset = Math.max(startOffset, outSrc.startOffset);
                    }
                }
                src.tokens.add(this.captureState());
                src.maxToNode = Math.max(src.maxToNode, inputTo);
                src.minToNode = Math.min(src.minToNode, inputTo);
                this.maxLookaheadUsed = Math.max(this.maxLookaheadUsed, this.inputNodes.getBufferSize());
                InputNode dest = (InputNode)this.inputNodes.get(inputTo);
                if (dest.node == -1) {
                    dest.node = inputTo;
                }
                if ((outputEndNode = src.outputNode + 1) > dest.outputNode) {
                    if (dest.outputNode != -1) {
                        boolean removed = ((OutputNode)this.outputNodes.get((int)dest.outputNode)).inputNodes.removeElement(inputTo);
                        assert (removed);
                    }
                    ((OutputNode)this.outputNodes.get((int)outputEndNode)).inputNodes.add(inputTo);
                    dest.outputNode = outputEndNode;
                    assert (outputEndNode <= inputTo) : "outputEndNode=" + outputEndNode + " vs inputTo=" + inputTo;
                }
                OutputNode outDest = (OutputNode)this.outputNodes.get(dest.outputNode);
                if (outDest.endOffset != -1 && endOffset >= outDest.endOffset) continue;
                outDest.endOffset = endOffset;
                continue;
            }
            this.input.end();
            this.finalPosInc = this.posIncAtt.getPositionIncrement();
            this.finalOffset = this.offsetAtt.endOffset();
            this.done = true;
        }
        return true;
    }

    private OutputNode recoverFromHole(InputNode src, int startOffset, int posinc) {
        int outIndex;
        assert (src.outputNode == -1);
        src.node = this.inputFrom;
        int previousInputFrom = this.inputFrom - posinc;
        if (previousInputFrom >= 0) {
            InputNode offsetSrc = (InputNode)this.inputNodes.get(previousInputFrom);
            outIndex = offsetSrc.minToNode < this.inputFrom ? ((InputNode)this.inputNodes.get((int)offsetSrc.minToNode)).outputNode + 1 : this.outputNodes.getMaxPos();
        } else {
            outIndex = this.outputNodes.getMaxPos() + 1;
        }
        OutputNode outSrc = (OutputNode)this.outputNodes.get(outIndex);
        src.outputNode = outIndex;
        if (outSrc.node == -1) {
            outSrc.node = src.outputNode;
            outSrc.startOffset = startOffset;
        } else {
            outSrc.startOffset = Math.max(startOffset, outSrc.startOffset);
        }
        outSrc.inputNodes.add(this.inputFrom);
        return outSrc;
    }

    public void end() throws IOException {
        if (!this.done) {
            super.end();
        }
        this.clearAttributes();
        if (this.done) {
            this.posIncAtt.setPositionIncrement(this.finalPosInc);
            this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
        } else {
            super.end();
        }
    }

    public void reset() throws IOException {
        super.reset();
        this.inputFrom = -1;
        this.inputNodes.reset();
        InputNode in = (InputNode)this.inputNodes.get(0);
        in.node = 0;
        in.outputNode = 0;
        this.outputNodes.reset();
        OutputNode out = (OutputNode)this.outputNodes.get(0);
        out.node = 0;
        out.inputNodes.add(0);
        out.startOffset = 0;
        this.outputFrom = 0;
        this.lastOutputFrom = -1;
        this.done = false;
        this.finalPosInc = -1;
        this.finalOffset = -1;
        this.lastStartOffset = 0;
        this.maxLookaheadUsed = 0;
    }

    public int getMaxLookaheadUsed() {
        return this.maxLookaheadUsed;
    }

    private static final class OutputNode
    implements RollingBuffer.Resettable {
        private final IntArrayList inputNodes = new IntArrayList();
        int node = -1;
        int nextOut;
        int startOffset = -1;
        int endOffset = -1;

        private OutputNode() {
        }

        public void reset() {
            this.inputNodes.clear();
            this.node = -1;
            this.nextOut = 0;
            this.startOffset = -1;
            this.endOffset = -1;
        }
    }

    private static final class InputNode
    implements RollingBuffer.Resettable {
        private final List<AttributeSource.State> tokens = new ArrayList<AttributeSource.State>();
        int node = -1;
        int maxToNode = -1;
        int minToNode = Integer.MAX_VALUE;
        int outputNode = -1;
        int nextOut;

        private InputNode() {
        }

        public void reset() {
            this.tokens.clear();
            this.node = -1;
            this.outputNode = -1;
            this.maxToNode = -1;
            this.minToNode = Integer.MAX_VALUE;
            this.nextOut = 0;
        }
    }
}

