/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.core.index.EntryResult;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchPattern;

public abstract class IntersectingPattern
extends JavaSearchPattern {
    public IntersectingPattern(int patternKind, int matchRule) {
        super(patternKind, matchRule);
    }

    @Override
    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) throws IOException {
        Object[] names;
        int n;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.resetQuery();
        SimpleSet intersectedNames = null;
        try {
            index.startQuery();
            do {
                SearchPattern pattern;
                EntryResult[] entries;
                if ((entries = (pattern = this.currentPattern()).queryIn(index)) == null) {
                    return;
                }
                SearchPattern decodedResult = pattern.getBlankPattern();
                SimpleSet newIntersectedNames = new SimpleSet(3);
                EntryResult[] entryResultArray = entries;
                int n2 = entries.length;
                n = 0;
                while (n < n2) {
                    EntryResult entry = entryResultArray[n];
                    if (progressMonitor != null && progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    decodedResult.decodeIndexKey(entry.getWord());
                    if (pattern.matchesDecodedKey(decodedResult)) {
                        String[] names2 = entry.getDocumentNames(index);
                        if (intersectedNames != null) {
                            var19_22 = names2;
                            var18_21 = names2.length;
                            var17_20 = 0;
                            while (var17_20 < var18_21) {
                                name = var19_22[var17_20];
                                if (intersectedNames.includes((Object)name)) {
                                    newIntersectedNames.add((Object)name);
                                }
                                ++var17_20;
                            }
                        } else {
                            var19_22 = names2;
                            var18_21 = names2.length;
                            var17_20 = 0;
                            while (var17_20 < var18_21) {
                                name = var19_22[var17_20];
                                newIntersectedNames.add((Object)name);
                                ++var17_20;
                            }
                        }
                    }
                    ++n;
                }
                if (newIntersectedNames.elementSize == 0) {
                    return;
                }
                intersectedNames = newIntersectedNames;
            } while (this.hasNextQuery());
        }
        finally {
            index.stopQuery();
        }
        String containerPath = index.containerPath;
        char separator = index.separator;
        Object[] objectArray = names = intersectedNames.values;
        n = names.length;
        int n3 = 0;
        while (n3 < n) {
            Object name = objectArray[n3];
            if (name != null) {
                this.acceptMatch((String)name, containerPath, separator, null, requestor, participant, scope, progressMonitor);
            }
            ++n3;
        }
    }

    @Override
    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, boolean resolveDocumentName, IProgressMonitor progressMonitor) throws IOException {
        this.findIndexMatches(index, requestor, participant, scope, progressMonitor);
    }

    protected abstract boolean hasNextQuery();

    protected abstract void resetQuery();
}

