/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.SegmentStoreStatisticsModel;
import org.eclipse.tracecompass.analysis.timing.core.statistics.IStatistics;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.IDataAspect;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.ITypedDataAspect;
import org.eclipse.tracecompass.internal.analysis.timing.core.segmentstore.SegmentStoreStatisticsAspects;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.TableColumnDescriptor;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.tmf.core.model.AbstractTmfTraceDataProvider;
import org.eclipse.tracecompass.tmf.core.model.ITableColumnDescriptor;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public abstract class AbstractSegmentStoreStatisticsDataProvider
extends AbstractTmfTraceDataProvider
implements ITmfTreeDataProvider<SegmentStoreStatisticsModel> {
    protected static final String TOTAL_PREFIX = "Total_";
    protected static final String SELECTION_PREFIX = "Selection_";
    private static final AtomicLong ENTRY_ID = new AtomicLong();
    private final String fId;
    private @Nullable String fRootEntryName;
    private final Map<String, Long> fIdToType = new HashMap<String, Long>();
    protected final long fTraceId = ENTRY_ID.getAndIncrement();
    private SegmentStoreStatisticsAspects fAspects = new SegmentStoreStatisticsAspects();

    protected AbstractSegmentStoreStatisticsDataProvider(ITmfTrace trace, String id) {
        super(trace);
        this.fId = id;
    }

    protected AbstractSegmentStoreStatisticsDataProvider(ITmfTrace trace, String id, List<IDataAspect<SegmentStoreStatisticsAspects.NamedStatistics>> userDefinedAspects) {
        this(trace, id);
        this.fAspects = new SegmentStoreStatisticsAspects(userDefinedAspects);
    }

    protected List<ITableColumnDescriptor> getColumnDescriptors() {
        ImmutableList.Builder headers = new ImmutableList.Builder();
        for (IDataAspect<SegmentStoreStatisticsAspects.NamedStatistics> aspect : this.fAspects.getAspects()) {
            TableColumnDescriptor.Builder builder = new TableColumnDescriptor.Builder();
            builder.setText(Objects.requireNonNull(aspect.getName()));
            builder.setTooltip(Objects.requireNonNull(aspect.getHelpText()));
            if (aspect instanceof ITypedDataAspect) {
                builder.setDataType(((ITypedDataAspect)aspect).getDataType());
            }
            headers.add((Object)builder.build());
        }
        return headers.build();
    }

    protected List<String> getCellLabels(String name, IStatistics<ISegment> statistics) {
        SegmentStoreStatisticsAspects.NamedStatistics namedStatistics = new SegmentStoreStatisticsAspects.NamedStatistics(name, statistics);
        ImmutableList.Builder labels = new ImmutableList.Builder();
        for (IDataAspect<SegmentStoreStatisticsAspects.NamedStatistics> aspect : this.fAspects.getAspects()) {
            labels.add((Object)NonNullUtils.nullToEmptyString(aspect.apply(namedStatistics)));
        }
        return labels.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getUniqueId(String name) {
        Map<String, Long> map = this.fIdToType;
        synchronized (map) {
            return this.fIdToType.computeIfAbsent(name, n -> ENTRY_ID.getAndIncrement());
        }
    }

    public String getId() {
        return this.fId;
    }

    public void setRootEntryName(@Nullable String rootName) {
        this.fRootEntryName = rootName;
    }

    public final @Nullable String getRootEntryName() {
        return this.fRootEntryName;
    }

    public void setMapper(Function<Number, String> mapper) {
        this.fAspects.setMapper(mapper);
    }

    public void setLabelMapper(UnaryOperator<String> mapper) {
        this.fAspects.setLabelMapper(mapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<String, Long> map = this.fIdToType;
        synchronized (map) {
            this.fIdToType.clear();
        }
    }
}

