/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.elf.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.utils.AR;
import org.eclipse.cdt.utils.BinaryFile;
import org.eclipse.cdt.utils.elf.parser.ElfBinaryObject;
import org.eclipse.core.runtime.IPath;

public class ElfBinaryArchive
extends BinaryFile
implements IBinaryParser.IBinaryArchive {
    private ArrayList<IBinaryParser.IBinaryObject> children;

    public ElfBinaryArchive(IBinaryParser parser, IPath path) throws IOException {
        super(parser, path, 8);
        Throwable throwable = null;
        Object var4_4 = null;
        try {
            AR ar = new AR(path.toOSString());
            if (ar != null) {
                ar.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.children = new ArrayList(5);
    }

    @Override
    public IBinaryParser.IBinaryObject[] getObjects() {
        if (this.hasChanged()) {
            this.children.clear();
            AR ar = null;
            try {
                ar = new AR(this.getPath().toOSString());
                AR.ARHeader[] headers = ar.getHeaders();
                IBinaryParser.IBinaryObject[] bobjs = this.createArchiveMembers(headers);
                this.children.addAll(Arrays.asList(bobjs));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (ar != null) {
                ar.dispose();
            }
            this.children.trimToSize();
        }
        return this.children.toArray(new IBinaryParser.IBinaryObject[0]);
    }

    protected IBinaryParser.IBinaryObject[] createArchiveMembers(AR.ARHeader[] headers) {
        IBinaryParser.IBinaryObject[] result = new IBinaryParser.IBinaryObject[headers.length];
        int i = 0;
        while (i < headers.length) {
            result[i] = new ElfBinaryObject(this.getBinaryParser(), this.getPath(), headers[i]);
            ++i;
        }
        return result;
    }

    @Deprecated
    protected void addArchiveMembers(AR.ARHeader[] headers, ArrayList children) {
        IBinaryParser.IBinaryObject[] bobjs = this.createArchiveMembers(headers);
        children.addAll(Arrays.asList(bobjs));
    }
}

