/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.CoreModelUtil;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IIncludeEntry;
import org.eclipse.cdt.core.model.IIncludeReference;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementInfo;
import org.eclipse.cdt.internal.core.model.ExternalTranslationUnit;
import org.eclipse.cdt.internal.core.model.Openable;
import org.eclipse.cdt.internal.core.model.OpenableInfo;
import org.eclipse.cdt.internal.core.util.MementoTokenizer;
import org.eclipse.cdt.utils.PathUtil;
import org.eclipse.cdt.utils.UNCPathConverter;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public class IncludeReference
extends Openable
implements IIncludeReference {
    final IIncludeEntry fIncludeEntry;
    final IPath fPath;

    public IncludeReference(ICProject cproject, IIncludeEntry entry) {
        this((ICElement)cproject, entry, entry.getFullIncludePath());
    }

    public IncludeReference(ICElement celement, IIncludeEntry entry, IPath path) {
        super(celement, null, path.toString(), 30);
        this.fIncludeEntry = entry;
        this.fPath = PathUtil.getCanonicalPathWindows(path);
    }

    @Override
    public IResource getResource() {
        return null;
    }

    @Override
    public boolean exists() {
        File file = null;
        if (this.fPath != null) {
            file = this.fPath.toFile();
        } else if (this.fIncludeEntry != null) {
            file = this.fIncludeEntry.getFullIncludePath().toFile();
        }
        return file != null && file.isDirectory();
    }

    @Override
    protected CElementInfo createElementInfo() {
        return new OpenableInfo(this);
    }

    @Override
    public IIncludeEntry getIncludeEntry() {
        return this.fIncludeEntry;
    }

    @Override
    protected boolean buildStructure(OpenableInfo info, IProgressMonitor pm, Map<ICElement, CElementInfo> newElements, IResource underlyingResource) throws CModelException {
        return this.computeChildren(info, pm, underlyingResource);
    }

    @Override
    public IPath getAffectedPath() {
        return this.fIncludeEntry.getPath();
    }

    protected boolean computeChildren(OpenableInfo info, IProgressMonitor pm, IResource res) throws CModelException {
        ArrayList<IncludeReference> vChildren = new ArrayList<IncludeReference>();
        IPath filePath = null;
        if (this.fPath != null) {
            filePath = this.fPath;
        } else if (this.fIncludeEntry != null) {
            filePath = this.fIncludeEntry.getFullIncludePath();
        }
        if (filePath != null) {
            if (!filePath.isUNC()) {
                File file = filePath.toFile();
                String[] names = null;
                if (file != null && file.isDirectory() && (names = file.list()) != null) {
                    Path path = new Path(file.getAbsolutePath());
                    String[] stringArray = names;
                    int n = names.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String id;
                        String name = stringArray[n2];
                        File child = new File(file, name);
                        Openable celement = null;
                        if (child.isDirectory()) {
                            celement = new IncludeReference((ICElement)this, this.fIncludeEntry, (IPath)new Path(child.getAbsolutePath()));
                        } else if (child.isFile() && (id = CoreModel.getRegistedContentTypeId(this.getCProject().getProject(), name)) != null) {
                            celement = new ExternalTranslationUnit((ICElement)this, URIUtil.toURI((IPath)path.append(name)), id);
                        }
                        if (celement != null) {
                            vChildren.add((IncludeReference)celement);
                        }
                        ++n2;
                    }
                }
            } else {
                try {
                    IFileStore[] children;
                    IFileStore store = EFS.getStore((URI)UNCPathConverter.getInstance().toURI(filePath));
                    IFileStore[] iFileStoreArray = children = store.childStores(0, pm);
                    int n = children.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IFileStore child = iFileStoreArray[n3];
                        Openable celement = null;
                        if (child.fetchInfo().isDirectory()) {
                            celement = new IncludeReference((ICElement)this, this.fIncludeEntry, filePath.append(child.getName()));
                        } else {
                            String id = CoreModel.getRegistedContentTypeId(this.getCProject().getProject(), child.getName());
                            if (id != null) {
                                celement = new ExternalTranslationUnit((ICElement)this, child.toURI(), id);
                            }
                        }
                        if (celement != null) {
                            vChildren.add((IncludeReference)celement);
                        }
                        ++n3;
                    }
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        info.setChildren(vChildren);
        return true;
    }

    @Override
    public boolean isOnIncludeEntry(IPath path) {
        return this.fIncludeEntry.getFullIncludePath().isPrefixOf(path) && !CoreModelUtil.isExcluded(path, this.fIncludeEntry.fullExclusionPatternChars());
    }

    @Override
    public IPath getPath() {
        return this.fPath;
    }

    @Override
    public ICElement getHandleFromMemento(String token, MementoTokenizer memento) {
        return null;
    }

    @Override
    public void getHandleMemento(StringBuilder buff) {
        ((CElement)this.getParent()).getHandleMemento(buff);
    }

    @Override
    protected char getHandleMementoDelimiter() {
        Assert.isTrue((boolean)false, (String)"Should not be called");
        return '\u0000';
    }
}

