/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.history;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.history.BrowseRefactoringHistoryContentProvider;
import org.eclipse.ltk.internal.ui.refactoring.history.BrowseRefactoringHistoryLabelProvider;
import org.eclipse.ltk.internal.ui.refactoring.history.BrowseRefactoringHistoryViewerSorter;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryControl;
import org.eclipse.ltk.internal.ui.refactoring.util.SWTUtil;
import org.eclipse.ltk.ui.refactoring.history.ISortableRefactoringHistoryControl;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryContentProvider;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryLabelProvider;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;

public class SortableRefactoringHistoryControl
extends RefactoringHistoryControl
implements ISortableRefactoringHistoryControl {
    private static final RefactoringDescriptorProxy[] EMPTY_DESCRIPTORS = new RefactoringDescriptorProxy[0];
    private static final String TOOLBAR_SORT_GROUP = "group.sort";
    private Button fDeselectAllButton = null;
    private Button fSelectAllButton = null;
    private final IAction fSortProjects = new Action(RefactoringUIMessages.BrowseRefactoringHistoryControl_sort_project, 8){

        public final void run() {
            BrowseRefactoringHistoryContentProvider provider = (BrowseRefactoringHistoryContentProvider)SortableRefactoringHistoryControl.this.fHistoryViewer.getContentProvider();
            provider.setSortProjects(true);
            SortableRefactoringHistoryControl.this.fHistoryViewer.setComparator((ViewerComparator)SortableRefactoringHistoryControl.this.fViewerComperator);
            SortableRefactoringHistoryControl.this.fHistoryViewer.refresh(false);
            SortableRefactoringHistoryControl.this.reconcileCheckState();
            SortableRefactoringHistoryControl.this.reconcileSelectionState();
            SortableRefactoringHistoryControl.this.fSortProjects.setChecked(true);
            SortableRefactoringHistoryControl.this.fSortTimestamps.setChecked(false);
        }
    };
    private final IAction fSortTimestamps = new Action(RefactoringUIMessages.BrowseRefactoringHistoryControl_sort_date, 8){

        public final void run() {
            BrowseRefactoringHistoryContentProvider provider = (BrowseRefactoringHistoryContentProvider)SortableRefactoringHistoryControl.this.fHistoryViewer.getContentProvider();
            provider.setSortProjects(false);
            SortableRefactoringHistoryControl.this.fHistoryViewer.setComparator(null);
            SortableRefactoringHistoryControl.this.fHistoryViewer.refresh(false);
            SortableRefactoringHistoryControl.this.reconcileCheckState();
            SortableRefactoringHistoryControl.this.reconcileSelectionState();
            SortableRefactoringHistoryControl.this.fSortTimestamps.setChecked(true);
            SortableRefactoringHistoryControl.this.fSortProjects.setChecked(false);
        }
    };
    private ToolBarManager fToolBarManager = null;
    private final BrowseRefactoringHistoryViewerSorter fViewerComperator = new BrowseRefactoringHistoryViewerSorter();

    public SortableRefactoringHistoryControl(Composite parent, RefactoringHistoryControlConfiguration configuration) {
        super(parent, configuration);
        this.addDisposeListener(event -> {
            if (this.fToolBarManager != null) {
                this.fToolBarManager.removeAll();
                this.fToolBarManager.dispose();
                this.fToolBarManager = null;
            }
        });
    }

    @Override
    protected void createBottomButtonBar(Composite parent) {
        Assert.isNotNull((Object)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginTop = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 128;
        composite.setLayoutData((Object)data);
        this.createSelectAllButton(composite);
        this.createDeselectAllButton(composite);
    }

    @Override
    public void createControl() {
        super.createControl();
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.heightHint = new PixelConverter((Control)this).convertHeightInCharsToPixels(22);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        this.setLayoutData(data);
    }

    protected void createDeselectAllButton(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.fDeselectAllButton = new Button(parent, 0);
        this.fDeselectAllButton.setEnabled(false);
        this.fDeselectAllButton.setText(RefactoringUIMessages.SelectRefactoringHistoryControl_deselect_all_label);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        data.verticalAlignment = 1;
        data.widthHint = SWTUtil.getButtonWidthHint(this.fDeselectAllButton);
        this.fDeselectAllButton.setLayoutData((Object)data);
        this.fDeselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                SortableRefactoringHistoryControl.this.handleDeselectAll();
            }
        });
    }

    @Override
    protected TreeViewer createHistoryViewer(Composite parent) {
        Assert.isNotNull((Object)parent);
        Object viewer = null;
        viewer = this.fControlConfiguration.isCheckableViewer() ? new RefactoringHistoryControl.RefactoringHistoryTreeViewer(parent, 770) : new TreeViewer(parent, 770);
        return viewer;
    }

    protected void createSelectAllButton(Composite parent) {
        Assert.isNotNull((Object)parent);
        this.fSelectAllButton = new Button(parent, 0);
        this.fSelectAllButton.setEnabled(false);
        this.fSelectAllButton.setText(RefactoringUIMessages.SelectRefactoringHistoryControl_select_all_label);
        GridData data = new GridData();
        data.horizontalAlignment = 3;
        data.grabExcessHorizontalSpace = true;
        data.verticalAlignment = 1;
        data.widthHint = SWTUtil.getButtonWidthHint(this.fSelectAllButton);
        this.fSelectAllButton.setLayoutData((Object)data);
        this.fSelectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                SortableRefactoringHistoryControl.this.handleSelectAll();
            }
        });
    }

    @Override
    protected void createToolBar(ViewForm parent) {
        ToolBarManager manager = this.getToolBarManager();
        if (manager != null) {
            manager.removeAll();
            manager.add((IContributionItem)new Separator(TOOLBAR_SORT_GROUP));
            this.fSortProjects.setText(RefactoringUIMessages.BrowseRefactoringHistoryControl_sort_project);
            this.fSortProjects.setToolTipText(RefactoringUIMessages.BrowseRefactoringHistoryControl_sort_project);
            this.fSortProjects.setDescription(RefactoringUIMessages.BrowseRefactoringHistoryControl_sort_project_description);
            this.fSortProjects.setImageDescriptor(RefactoringPluginImages.DESC_ELCL_SORT_PROJECT);
            this.fSortProjects.setDisabledImageDescriptor(RefactoringPluginImages.DESC_DLCL_SORT_PROJECT);
            this.fSortTimestamps.setText(RefactoringUIMessages.BrowseRefactoringHistoryControl_sort_date);
            this.fSortTimestamps.setToolTipText(RefactoringUIMessages.BrowseRefactoringHistoryControl_sort_date);
            this.fSortTimestamps.setDescription(RefactoringUIMessages.BrowseRefactoringHistoryControl_sort_date_description);
            this.fSortTimestamps.setImageDescriptor(RefactoringPluginImages.DESC_ELCL_SORT_DATE);
            this.fSortTimestamps.setDisabledImageDescriptor(RefactoringPluginImages.DESC_DLCL_SORT_DATE);
            manager.appendToGroup(TOOLBAR_SORT_GROUP, this.fSortProjects);
            manager.appendToGroup(TOOLBAR_SORT_GROUP, this.fSortTimestamps);
            manager.update(true);
        }
    }

    @Override
    protected int getContainerColumns() {
        return 1;
    }

    @Override
    protected RefactoringHistoryContentProvider getContentProvider() {
        return new BrowseRefactoringHistoryContentProvider(this.fControlConfiguration);
    }

    public Button getDeselectAllButton() {
        return this.fDeselectAllButton;
    }

    @Override
    protected RefactoringHistoryLabelProvider getLabelProvider() {
        return new BrowseRefactoringHistoryLabelProvider(this.fControlConfiguration);
    }

    public Button getSelectAllButton() {
        return this.fSelectAllButton;
    }

    protected ToolBarManager getToolBarManager() {
        if (this.fToolBarManager == null) {
            ToolBar toolbar = new ToolBar((Composite)this.fHistoryPane, 0x800000);
            this.fHistoryPane.setTopCenter((Control)toolbar);
            this.fToolBarManager = new ToolBarManager(toolbar);
        }
        return this.fToolBarManager;
    }

    @Override
    protected void handleCheckStateChanged() {
        super.handleCheckStateChanged();
        RefactoringHistory history = this.getInput();
        if (history != null) {
            int checked = this.getCheckedDescriptors().length;
            int total = history.getDescriptors().length;
            if (this.fSelectAllButton != null) {
                this.fSelectAllButton.setEnabled(checked < total);
            }
            if (this.fDeselectAllButton != null) {
                this.fDeselectAllButton.setEnabled(checked > 0);
            }
        }
    }

    protected void handleDeselectAll() {
        this.setCheckedDescriptors(EMPTY_DESCRIPTORS);
    }

    protected void handleSelectAll() {
        RefactoringHistory history = this.getInput();
        if (history != null) {
            this.setCheckedDescriptors(history.getDescriptors());
        }
    }

    @Override
    public boolean isSortByDate() {
        return !this.isSortByProjects();
    }

    @Override
    public boolean isSortByProjects() {
        IContentProvider provider = this.fHistoryViewer.getContentProvider();
        if (provider instanceof BrowseRefactoringHistoryContentProvider) {
            BrowseRefactoringHistoryContentProvider extended = (BrowseRefactoringHistoryContentProvider)provider;
            return extended.isSortProjects();
        }
        return false;
    }

    @Override
    protected void setHistoryControlEnablement() {
        RefactoringDescriptorProxy[] proxies;
        super.setHistoryControlEnablement();
        boolean enable = false;
        RefactoringHistory history = (RefactoringHistory)this.fHistoryViewer.getInput();
        if (history != null && (proxies = history.getDescriptors()).length > 0) {
            enable = true;
        }
        this.fSortProjects.setEnabled(enable);
        this.fSortTimestamps.setEnabled(enable);
    }

    @Override
    public void setInput(RefactoringHistory history) {
        super.setInput(history);
        if (this.fDeselectAllButton != null) {
            this.fDeselectAllButton.setEnabled(false);
        }
        if (this.fSelectAllButton != null) {
            this.fSelectAllButton.setEnabled(history != null && !history.isEmpty());
        }
    }

    @Override
    public void sortByDate() {
        this.fSortTimestamps.run();
    }

    @Override
    public void sortByProjects() {
        this.fSortProjects.run();
    }
}

