/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceSessionState;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseAddContextHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.CommandParameter;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.DomainCommandParameter;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceDomainComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.ui.IWorkbenchPage;

public class AddContextOnDomainHandler
extends BaseAddContextHandler {
    @Override
    public void addContexts(CommandParameter param, List<String> contextNames, IProgressMonitor monitor) throws ExecutionException {
        if (param instanceof DomainCommandParameter) {
            TraceDomainComponent domain = ((DomainCommandParameter)param).getDomain();
            domain.addContexts(contextNames, monitor);
        }
    }

    public boolean isEnabled() {
        boolean isEnabled;
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        TraceDomainComponent domain = null;
        TraceSessionComponent session = null;
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                TraceDomainComponent tmpDomain;
                if (!(element instanceof TraceDomainComponent) || (session = (TraceSessionComponent)(tmpDomain = (TraceDomainComponent)element).getParent()).getSessionState() != TraceSessionState.INACTIVE || session.isDestroyed()) continue;
                domain = tmpDomain;
            }
        }
        boolean bl = isEnabled = domain != null;
        if (TraceDomainType.JUL.equals(domain)) {
            isEnabled = false;
        }
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new DomainCommandParameter((TraceSessionComponent)NonNullUtils.checkNotNull(session), (TraceDomainComponent)NonNullUtils.checkNotNull(domain));
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }
}

