/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.core.mapping;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;

class LineComparator
implements IRangeComparator {
    private String[] fLines;

    public static LineComparator create(IStorage storage, String outputEncoding) throws CoreException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedInputStream is = new BufferedInputStream(storage.getContents());){
            String encoding = LineComparator.getEncoding(storage, outputEncoding);
            return new LineComparator(is, encoding);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static String getEncoding(IStorage storage, String outputEncoding) throws CoreException {
        IEncodedStorage es;
        String charset;
        if (storage instanceof IEncodedStorage && (charset = (es = (IEncodedStorage)storage).getCharset()) != null) {
            return charset;
        }
        return outputEncoding;
    }

    public LineComparator(InputStream is, String encoding) throws IOException {
        TrailingLineFeedDetector trailingLineFeedDetector = new TrailingLineFeedDetector(is);
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)trailingLineFeedDetector, encoding));){
            String line;
            ArrayList<String> ar = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                ar.add(line);
            }
            if (trailingLineFeedDetector.hadTrailingLineFeed()) {
                ar.add("");
            }
            this.fLines = ar.toArray(new String[ar.size()]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    String getLine(int ix) {
        return this.fLines[ix];
    }

    public int getRangeCount() {
        return this.fLines.length;
    }

    public boolean rangesEqual(int thisIndex, IRangeComparator other, int otherIndex) {
        String s1 = this.fLines[thisIndex];
        String s2 = ((LineComparator)other).fLines[otherIndex];
        return s1.equals(s2);
    }

    public boolean skipRangeComparison(int length, int maxLength, IRangeComparator other) {
        return false;
    }

    private static class TrailingLineFeedDetector
    extends FilterInputStream {
        boolean trailingLF = false;

        protected TrailingLineFeedDetector(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int c = super.read();
            this.trailingLF = this.isLineFeed(c);
            return c;
        }

        @Override
        public int read(byte[] buffer, int off, int len) throws IOException {
            int length = super.read(buffer, off, len);
            if (length != -1) {
                int index = off + length - 1;
                if (index >= buffer.length) {
                    index = buffer.length - 1;
                }
                this.trailingLF = this.isLineFeed(buffer[index]);
            }
            return length;
        }

        private boolean isLineFeed(int c) {
            return c != -1 && c == 10;
        }

        public boolean hadTrailingLineFeed() {
            return this.trailingLF;
        }
    }
}

