/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.datastore.core.historytree;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;

public interface IHTNode<E extends IHTInterval> {
    public void writeSelf(FileChannel var1) throws IOException;

    public long getNodeStart();

    public long getNodeEnd();

    public int getSequenceNumber();

    public int getParentSequenceNumber();

    public void setParentSequenceNumber(int var1);

    public boolean isOnDisk();

    public void add(E var1);

    public void closeThisNode(long var1);

    public Iterable<E> getMatchingIntervals(TimeRangeCondition var1, Predicate<E> var2);

    public @Nullable E getMatchingInterval(TimeRangeCondition var1, Predicate<E> var2);

    public int getTotalHeaderSize();

    public int getNodeFreeSpace();

    public long getNodeUsagePercent();

    public NodeType getNodeType();

    public boolean isEmpty();

    default public int getNbChildren() {
        return 0;
    }

    default public int getChild(int index) {
        throw new IndexOutOfBoundsException("This node does not have any children");
    }

    default public int getLatestChild() {
        throw new UnsupportedOperationException("This node does not support children");
    }

    default public void linkNewChild(IHTNode<E> childNode) {
        throw new UnsupportedOperationException("This node does not support children");
    }

    default public Collection<Integer> selectNextChildren(TimeRangeCondition timeCondition) {
        return Collections.emptyList();
    }

    public static enum NodeType {
        CORE(1),
        LEAF(2);

        private final byte fByte;

        private NodeType(byte rep) {
            this.fByte = rep;
        }

        public static NodeType fromByte(byte rep) {
            switch (rep) {
                case 1: {
                    return CORE;
                }
                case 2: {
                    return LEAF;
                }
            }
            throw new IllegalArgumentException("The NodeType byte " + rep + " is not a valid type");
        }

        public byte toByte() {
            return this.fByte;
        }
    }
}

