/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.simpleconfigurator;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.internal.simpleconfigurator.Activator;
import org.eclipse.equinox.internal.simpleconfigurator.ConfigApplier;
import org.eclipse.equinox.internal.simpleconfigurator.utils.EquinoxUtils;
import org.eclipse.equinox.internal.simpleconfigurator.utils.SimpleConfiguratorUtils;
import org.eclipse.equinox.internal.simpleconfigurator.utils.Utils;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SimpleConfiguratorImpl
implements Configurator {
    private static URL configurationURL = null;
    private static Object configurationLock = new Object();
    private BundleContext context;
    private ConfigApplier configApplier;
    private Bundle bundle;
    private static final long NO_TIMESTAMP = -1L;
    public static final String BASE_TIMESTAMP_FILE_BUNDLESINFO = ".baseBundlesInfoTimestamp";
    public static final String KEY_BUNDLESINFO_TIMESTAMP = "bundlesInfoTimestamp";
    public static final String KEY_EXT_TIMESTAMP = "extTimestamp";
    public static final String PROP_IGNORE_USER_CONFIGURATION = "eclipse.ignoreUserConfiguration";

    public SimpleConfiguratorImpl(BundleContext context, Bundle bundle) {
        this.context = context;
        this.bundle = bundle;
    }

    public URL getConfigurationURL() throws IOException {
        String specifiedURL = this.context.getProperty("org.eclipse.equinox.simpleconfigurator.configUrl");
        if (specifiedURL == null) {
            specifiedURL = "file:org.eclipse.equinox.simpleconfigurator/bundles.info";
        }
        try {
            if (!specifiedURL.startsWith("file:")) {
                return new URL(specifiedURL);
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
        try {
            boolean done = false;
            URL url = null;
            String file = specifiedURL;
            while (!done) {
                try {
                    url = Utils.buildURL(file);
                    file = url.getFile();
                }
                catch (MalformedURLException e) {
                    done = true;
                }
            }
            if (url != null && new File(url.getFile()).isAbsolute()) {
                return url;
            }
            URL[] configURL = EquinoxUtils.getConfigAreaURL(this.context);
            URL result = this.chooseConfigurationURL(url, configURL);
            if (result != null) {
                return result;
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
        try {
            return Utils.buildURL(specifiedURL);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public URL chooseConfigurationURL(URL relativeURL, URL[] configURL) throws MalformedURLException {
        if (configURL != null) {
            File userConfig = new File(configURL[0].getFile(), relativeURL.getFile());
            if (configURL.length == 1) {
                return userConfig.exists() ? userConfig.toURL() : null;
            }
            File sharedConfig = new File(configURL[1].getFile(), relativeURL.getFile());
            if (!userConfig.exists()) {
                return sharedConfig.exists() ? sharedConfig.toURL() : null;
            }
            if (!sharedConfig.exists()) {
                return userConfig.toURL();
            }
            if (Boolean.TRUE.toString().equals(System.getProperty(PROP_IGNORE_USER_CONFIGURATION))) {
                return sharedConfig.toURL();
            }
            long[] sharedBundlesInfoTimestamp = SimpleConfiguratorImpl.getCurrentBundlesInfoBaseTimestamp(sharedConfig);
            long[] lastKnownBaseTimestamp = this.getLastKnownBundlesInfoBaseTimestamp(userConfig.getParentFile());
            if (lastKnownBaseTimestamp[0] == sharedBundlesInfoTimestamp[0] && lastKnownBaseTimestamp[1] == sharedBundlesInfoTimestamp[1] || lastKnownBaseTimestamp[0] == -1L) {
                return userConfig.toURL();
            }
            System.setProperty(PROP_IGNORE_USER_CONFIGURATION, Boolean.TRUE.toString());
            return sharedConfig.toURL();
        }
        return null;
    }

    private long[] getLastKnownBundlesInfoBaseTimestamp(File configFolder) {
        long[] result = new long[]{-1L, -1L};
        File storedSharedTimestamp = new File(configFolder, BASE_TIMESTAMP_FILE_BUNDLESINFO);
        if (!storedSharedTimestamp.exists()) {
            return result;
        }
        Properties p = new Properties();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(storedSharedTimestamp));){
                p.load(is);
                if (p.get(KEY_BUNDLESINFO_TIMESTAMP) != null) {
                    result[0] = Long.valueOf((String)p.get(KEY_BUNDLESINFO_TIMESTAMP));
                }
                if (p.get(KEY_EXT_TIMESTAMP) != null) {
                    result[1] = Long.valueOf((String)p.get(KEY_EXT_TIMESTAMP));
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return result;
        }
        return result;
    }

    public static long[] getCurrentBundlesInfoBaseTimestamp(File sharedBundlesInfo) {
        if (!sharedBundlesInfo.exists()) {
            return new long[]{-1L, -1L};
        }
        long lastModified = SimpleConfiguratorUtils.getFileLastModified(sharedBundlesInfo);
        long extLastModified = SimpleConfiguratorUtils.getExtendedTimeStamp();
        return new long[]{lastModified, extLastModified};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyConfiguration(URL url) throws IOException {
        Object object = configurationLock;
        synchronized (object) {
            if (Activator.DEBUG) {
                System.out.println("applyConfiguration() URL=" + String.valueOf(url));
            }
            if (url == null) {
                return;
            }
            configurationURL = url;
            if (this.configApplier == null) {
                this.configApplier = new ConfigApplier(this.context, this.bundle);
            }
            this.configApplier.install(url, this.isExclusiveInstallation());
        }
    }

    private boolean isExclusiveInstallation() {
        String value = this.context.getProperty("org.eclipse.equinox.simpleconfigurator.exclusiveInstallation");
        if (value == null || value.trim().length() == 0) {
            value = "true";
        }
        return Boolean.parseBoolean(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyConfiguration() throws IOException {
        Object object = configurationLock;
        synchronized (object) {
            configurationURL = this.getConfigurationURL();
            this.applyConfiguration(configurationURL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getUrlInUse() {
        Object object = configurationLock;
        synchronized (object) {
            return configurationURL;
        }
    }
}

