/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.internal.support;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swtchart.extensions.core.MappedSeriesSettings;

public class MappingsFilter
extends ViewerFilter {
    private String searchText;
    private boolean caseSensitive;

    public void setSearchText(String searchText, boolean caseSensitive) {
        this.searchText = searchText;
        this.caseSensitive = caseSensitive;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.searchText == null || this.searchText.equals("")) {
            return true;
        }
        if (element instanceof MappedSeriesSettings) {
            MappedSeriesSettings mappedSeriesSettings = (MappedSeriesSettings)element;
            String mappingsType = mappedSeriesSettings.getMappingsType().label();
            String identifier = mappedSeriesSettings.getIdentifier();
            String description = mappedSeriesSettings.getDescription();
            if (!this.caseSensitive) {
                this.searchText = this.searchText.toLowerCase();
                mappingsType = mappingsType.toLowerCase();
                identifier = identifier.toLowerCase();
                description = description.toLowerCase();
            }
            if (mappingsType.contains(this.searchText)) {
                return true;
            }
            if (identifier.contains(this.searchText)) {
                return true;
            }
            if (description.contains(this.searchText)) {
                return true;
            }
        }
        return false;
    }
}

