/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.events;

import org.eclipse.swt.widgets.Event;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.extensions.core.BaseChart;
import org.eclipse.swtchart.extensions.core.ISeriesSettings;
import org.eclipse.swtchart.extensions.core.ScrollableChart;
import org.eclipse.swtchart.extensions.events.AbstractHandledEventProcessor;
import org.eclipse.swtchart.extensions.events.IHandledEventProcessor;
import org.eclipse.swtchart.extensions.piecharts.CircularSeriesLegend;
import org.eclipse.swtchart.internal.series.CircularSeries;
import org.eclipse.swtchart.model.Node;

public class CircularMouseDownEvent
extends AbstractHandledEventProcessor
implements IHandledEventProcessor {
    private ScrollableChart scrollableChart;
    private boolean redrawOnClick = true;
    private boolean fillEntireSpace = false;

    public CircularMouseDownEvent(ScrollableChart scrollableChart) {
        this.scrollableChart = scrollableChart;
    }

    @Override
    public int getEvent() {
        return 3;
    }

    @Override
    public int getButton() {
        return 1;
    }

    @Override
    public int getStateMask() {
        return 0;
    }

    public void setRedrawOnClick(boolean redraw) {
        this.redrawOnClick = redraw;
    }

    public void setFillEntireSpace(boolean fillEntireSpace) {
        this.fillEntireSpace = fillEntireSpace;
    }

    @Override
    public void handleEvent(BaseChart baseChart, Event event) {
        ISeries[] iSeriesArray = baseChart.getSeriesSet().getSeries();
        int n = iSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries series = iSeriesArray[n2];
            if (series instanceof CircularSeries) {
                String[] labels;
                ISeries[] iSeriesArray2;
                String nodeId;
                CircularSeries circularSeries = (CircularSeries)series;
                double primaryValueX = baseChart.getSelectedPrimaryAxisValue(event.x, "X_AXIS");
                double primaryValueY = baseChart.getSelectedPrimaryAxisValue(event.y, "Y_AXIS");
                Node node = circularSeries.getPieSliceFromPosition(primaryValueX, primaryValueY);
                if (!this.redrawOnClick) {
                    circularSeries.setHighlightedNode(node);
                    if (this.scrollableChart.getLinkedScrollableCharts().isEmpty()) break;
                    nodeId = null;
                    if (node != null) {
                        nodeId = node.getId();
                    }
                    for (ScrollableChart linkedChart : this.scrollableChart.getLinkedScrollableCharts()) {
                        iSeriesArray2 = linkedChart.getBaseChart().getSeriesSet().getSeries();
                        int n3 = iSeriesArray2.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ISeries linkedSeries = iSeriesArray2[n4];
                            if (linkedSeries instanceof CircularSeries) {
                                Node correspondingNode = ((CircularSeries)linkedSeries).getNodeById(nodeId);
                                ((CircularSeries)linkedSeries).setHighlightedNode(correspondingNode);
                            }
                            ++n4;
                        }
                    }
                    break;
                }
                if (node != null) {
                    if (circularSeries.getRootPointer() == node) {
                        if (!this.fillEntireSpace) {
                            circularSeries.getNodeDataModel().setRootPointer(node.getParent());
                        } else {
                            circularSeries.setRootPointer(node.getParent());
                        }
                    } else if (!this.fillEntireSpace) {
                        circularSeries.getNodeDataModel().setRootPointer(node);
                    } else {
                        circularSeries.setRootPointer(node);
                    }
                } else {
                    circularSeries.setRootPointer(((CircularSeries)series).getRootNode());
                }
                if (!this.scrollableChart.getLinkedScrollableCharts().isEmpty()) {
                    CircularSeries circularSeriesLinked;
                    nodeId = null;
                    if (node != null) {
                        nodeId = node.getId();
                        for (ScrollableChart linkedChart : this.scrollableChart.getLinkedScrollableCharts()) {
                            iSeriesArray2 = linkedChart.getBaseChart().getSeriesSet().getSeries();
                            int n5 = iSeriesArray2.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                ISeries linkedSeries = iSeriesArray2[n6];
                                if (linkedSeries instanceof CircularSeries) {
                                    circularSeriesLinked = (CircularSeries)linkedSeries;
                                    Node correspondingNode = circularSeriesLinked.getNodeById(nodeId);
                                    if (circularSeriesLinked.getRootPointer() == correspondingNode) {
                                        if (!this.fillEntireSpace) {
                                            circularSeriesLinked.getNodeDataModel().setRootPointer(correspondingNode.getParent());
                                        } else {
                                            circularSeriesLinked.setRootPointer(correspondingNode.getParent());
                                        }
                                    } else if (!this.fillEntireSpace) {
                                        circularSeriesLinked.getNodeDataModel().setRootPointer(correspondingNode);
                                    } else {
                                        circularSeriesLinked.setRootPointer(correspondingNode);
                                    }
                                }
                                ++n6;
                            }
                        }
                    } else {
                        for (ScrollableChart linkedChart : this.scrollableChart.getLinkedScrollableCharts()) {
                            iSeriesArray2 = linkedChart.getBaseChart().getSeriesSet().getSeries();
                            int n7 = iSeriesArray2.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                ISeries linkedSeries = iSeriesArray2[n8];
                                if (linkedSeries instanceof CircularSeries) {
                                    circularSeriesLinked = (CircularSeries)linkedSeries;
                                    circularSeries.setRootPointer(circularSeriesLinked.getRootNode());
                                }
                                ++n8;
                            }
                        }
                    }
                }
                if ((labels = circularSeries.getLabels()) != null) {
                    String[] stringArray = labels;
                    int n9 = labels.length;
                    int n10 = 0;
                    while (n10 < n9) {
                        String label = stringArray[n10];
                        ISeriesSettings seriesSettings = baseChart.getSeriesSettings(label);
                        baseChart.applySeriesSettings((ISeries<?>)new CircularSeriesLegend(circularSeries.getNodeById(label), circularSeries.getNodeDataModel()), seriesSettings);
                        ++n10;
                    }
                }
            }
            ++n2;
        }
    }
}

