/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.core;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBinaryStreamListener;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IBinaryStreamMonitor;
import org.eclipse.debug.internal.core.StreamDecoder;

public class OutputStreamMonitor
implements IBinaryStreamMonitor {
    private static final int BUFFER_SIZE = 8192;
    private final InputStream fStream;
    private final ListenerList<IStreamListener> fListeners = new ListenerList();
    private final ListenerList<IBinaryStreamListener> fBinaryListeners = new ListenerList();
    private ByteArrayOutputStream fContents;
    private StreamDecoder fBufferedDecoder;
    private String fCachedDecodedContents;
    private Thread fThread;
    private boolean fKilled = false;
    private final Charset fCharset;
    private final StreamDecoder fDecoder;
    private final AtomicBoolean fDone;

    public OutputStreamMonitor(InputStream stream, Charset charset) {
        this.fStream = stream instanceof BufferedInputStream ? stream : new BufferedInputStream(stream);
        this.fCharset = charset;
        this.fDecoder = new StreamDecoder(charset == null ? Charset.defaultCharset() : charset);
        this.fDone = new AtomicBoolean(false);
        this.setBuffered(true);
    }

    @Deprecated
    public OutputStreamMonitor(InputStream stream, String encoding) {
        this(stream, Charset.forName(encoding));
    }

    @Override
    public synchronized void addListener(IStreamListener listener) {
        this.fListeners.add((Object)listener);
    }

    @Override
    public synchronized void addBinaryListener(IBinaryStreamListener listener) {
        this.fBinaryListeners.add((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        Thread thread = null;
        OutputStreamMonitor outputStreamMonitor = this;
        synchronized (outputStreamMonitor) {
            thread = this.fThread;
            this.fThread = null;
        }
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.fListeners.clear();
            this.fBinaryListeners.clear();
        }
    }

    private void fireStreamAppended(byte[] data, int offset, int length) {
        if (!this.fListeners.isEmpty()) {
            String text = this.fDecoder.decode(data, offset, length);
            for (Object listener : this.fListeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable((IStreamListener)listener, text){
                    private final /* synthetic */ IStreamListener val$listener;
                    private final /* synthetic */ String val$text;
                    {
                        this.val$listener = iStreamListener;
                        this.val$text = string;
                    }

                    public void run() throws Exception {
                        this.val$listener.streamAppended(this.val$text, OutputStreamMonitor.this);
                    }

                    public void handleException(Throwable exception) {
                        DebugPlugin.log(exception);
                    }
                });
            }
        }
        if (!this.fBinaryListeners.isEmpty()) {
            byte[] validData;
            if (offset > 0 || length < data.length) {
                validData = new byte[length];
                System.arraycopy(data, offset, validData, 0, length);
            } else {
                validData = data;
            }
            for (Object listener : this.fBinaryListeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable((IBinaryStreamListener)listener, validData){
                    private final /* synthetic */ IBinaryStreamListener val$listener;
                    private final /* synthetic */ byte[] val$validData;
                    {
                        this.val$listener = iBinaryStreamListener;
                        this.val$validData = byArray;
                    }

                    public void run() throws Exception {
                        this.val$listener.streamAppended(this.val$validData, OutputStreamMonitor.this);
                    }

                    public void handleException(Throwable exception) {
                        DebugPlugin.log(exception);
                    }
                });
            }
        }
    }

    @Override
    public synchronized String getContents() {
        if (!this.isBuffered()) {
            return "";
        }
        if (this.fCachedDecodedContents != null) {
            return this.fCachedDecodedContents;
        }
        byte[] data = this.getData();
        this.fCachedDecodedContents = this.fBufferedDecoder.decode(data, 0, data.length);
        return this.fCachedDecodedContents;
    }

    @Override
    public synchronized byte[] getData() {
        return this.isBuffered() ? this.fContents.toByteArray() : new byte[]{};
    }

    private void read() {
        try {
            this.internalRead();
        }
        finally {
            this.fDone.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void internalRead() {
        long lastSleep;
        long currentTime = lastSleep = System.currentTimeMillis();
        byte[] buffer = new byte[8192];
        int read = 0;
        try {
            while (read >= 0) {
                block24: {
                    try {
                        if (this.fKilled) {
                            break;
                        }
                        read = this.fStream.read(buffer);
                        if (read <= 0) break block24;
                        OutputStreamMonitor outputStreamMonitor = this;
                        synchronized (outputStreamMonitor) {
                            if (this.isBuffered()) {
                                this.fCachedDecodedContents = null;
                                this.fContents.write(buffer, 0, read);
                            }
                            this.fireStreamAppended(buffer, 0, read);
                        }
                    }
                    catch (IOException ioe) {
                        if (!this.fKilled) {
                            DebugPlugin.log(ioe);
                        }
                        try {
                            this.fStream.close();
                        }
                        catch (IOException e) {
                            DebugPlugin.log(e);
                        }
                        return;
                    }
                    catch (NullPointerException e) {
                        block25: {
                            if (this.fKilled || this.fThread == null) break block25;
                            DebugPlugin.log(e);
                        }
                        try {
                            this.fStream.close();
                        }
                        catch (IOException e2) {
                            DebugPlugin.log(e2);
                        }
                        return;
                    }
                }
                if ((currentTime = System.currentTimeMillis()) - lastSleep <= 1000L) continue;
                lastSleep = currentTime;
                Thread.yield();
                continue;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            try {
                this.fStream.close();
            }
            catch (IOException e) {
                DebugPlugin.log(e);
            }
        }
    }

    protected void kill() {
        this.fKilled = true;
    }

    @Override
    public synchronized void removeListener(IStreamListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public synchronized void removeBinaryListener(IBinaryStreamListener listener) {
        this.fBinaryListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startMonitoring(String name) {
        OutputStreamMonitor outputStreamMonitor = this;
        synchronized (outputStreamMonitor) {
            if (this.fThread == null) {
                this.fDone.set(false);
                this.fThread = new Thread(this::read, name);
                this.fThread.setDaemon(true);
                this.fThread.setPriority(1);
                this.fThread.start();
            }
        }
    }

    @Override
    public synchronized void setBuffered(boolean buffer) {
        if (this.isBuffered() != buffer) {
            this.fCachedDecodedContents = null;
            if (buffer) {
                this.fContents = new ByteArrayOutputStream();
                this.fBufferedDecoder = new StreamDecoder(this.fCharset == null ? Charset.defaultCharset() : this.fCharset);
            } else {
                this.fContents = null;
                this.fBufferedDecoder = null;
            }
        }
    }

    @Override
    public synchronized void flushContents() {
        if (this.isBuffered()) {
            this.fCachedDecodedContents = null;
            this.fContents.reset();
        }
    }

    @Override
    public synchronized boolean isBuffered() {
        return this.fContents != null;
    }

    public boolean isReadingDone() {
        return this.fDone.get();
    }
}

