/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceDomainType;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.GetLoggerInfoDialog;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.dialogs.TraceControlDialogFactory;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.BaseControlViewHandler;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.handlers.CommandParameter;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.messages.Messages;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.BaseLoggerComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TargetNodeComponent;
import org.eclipse.tracecompass.internal.lttng2.control.ui.views.model.impl.TraceSessionComponent;
import org.eclipse.ui.IWorkbenchPage;

public class AssignLoggerHandler
extends BaseControlViewHandler {
    private Parameter fParam;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Parameter tmpParam = null;
        this.fLock.lock();
        try {
            tmpParam = this.fParam;
            if (tmpParam == null) {
                return null;
            }
            tmpParam = new Parameter(tmpParam);
        }
        finally {
            this.fLock.unlock();
        }
        final Parameter param = tmpParam;
        final GetLoggerInfoDialog dialog = TraceControlDialogFactory.getInstance().getGetLoggerInfoDialog();
        dialog.setSessions(param.getSessions());
        dialog.setLoggerDomain(param.getLoggerDomain());
        if (dialog.open() != 0) {
            return null;
        }
        Job job = new Job(Messages.TraceControl_EnableLoggersDialogTitle){

            protected IStatus run(IProgressMonitor monitor) {
                ExecutionException error = null;
                TraceSessionComponent session = dialog.getSession();
                try {
                    ArrayList<String> loggerNames = new ArrayList<String>();
                    List<BaseLoggerComponent> loggers = param.getLoggers();
                    for (BaseLoggerComponent logger : loggers) {
                        loggerNames.add(logger.getName());
                    }
                    if (dialog.getLogLevel() != null) {
                        session.enableLogLevel(loggerNames, dialog.getLogLevelType(), dialog.getLogLevel(), null, param.getLoggerDomain(), monitor);
                    } else {
                        session.enableEvents(loggerNames, param.getLoggerDomain(), null, null, monitor);
                    }
                }
                catch (ExecutionException e) {
                    error = e;
                }
                AssignLoggerHandler.this.refresh(new CommandParameter(session));
                if (error != null) {
                    return new Status(4, "org.eclipse.tracecompass.lttng2.control.ui", Messages.TraceControl_EnableEventsFailure, (Throwable)error);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
        return null;
    }

    public boolean isEnabled() {
        boolean isEnabled;
        @NonNull ArrayList<@NonNull BaseLoggerComponent> loggers = new ArrayList<BaseLoggerComponent>();
        @NonNull TraceSessionComponent[] sessions = null;
        TraceDomainType domain = null;
        IWorkbenchPage page = this.getWorkbenchPage();
        if (page == null) {
            return false;
        }
        ISelection selection = page.getSelection("org.eclipse.linuxtools.internal.lttng2.ui.views.control");
        if (selection instanceof StructuredSelection) {
            StructuredSelection structered = (StructuredSelection)selection;
            for (Object element : structered) {
                if (!(element instanceof BaseLoggerComponent)) continue;
                BaseLoggerComponent logger = (BaseLoggerComponent)element;
                if (domain == null) {
                    domain = logger.getDomain();
                } else if (!domain.equals((Object)logger.getDomain())) {
                    loggers.clear();
                    break;
                }
                loggers.add(logger);
                if (sessions != null) continue;
                TargetNodeComponent root = (TargetNodeComponent)logger.getParent().getParent().getParent();
                sessions = root.getSessions();
            }
        }
        boolean bl = isEnabled = !loggers.isEmpty() && sessions != null && sessions.length > 0;
        if (domain == null) {
            return false;
        }
        this.fLock.lock();
        try {
            this.fParam = null;
            if (isEnabled) {
                this.fParam = new Parameter((TraceSessionComponent[])NonNullUtils.checkNotNull(sessions), loggers, domain);
            }
        }
        finally {
            this.fLock.unlock();
        }
        return isEnabled;
    }

    @NonNullByDefault
    private static final class Parameter {
        private final List<BaseLoggerComponent> fLoggers;
        private final @NonNull TraceSessionComponent[] fSessions;
        private final TraceDomainType fDomain;

        public Parameter(@NonNull TraceSessionComponent[] sessions, List<BaseLoggerComponent> loggers, TraceDomainType domain) {
            this.fSessions = (TraceSessionComponent[])NonNullUtils.checkNotNull((Object)Arrays.copyOf(sessions, sessions.length));
            this.fLoggers = new ArrayList<BaseLoggerComponent>();
            this.fLoggers.addAll(loggers);
            this.fDomain = domain;
        }

        public Parameter(Parameter other) {
            this(other.fSessions, other.fLoggers, other.fDomain);
        }

        public TraceSessionComponent[] getSessions() {
            return this.fSessions;
        }

        public List<BaseLoggerComponent> getLoggers() {
            return this.fLoggers;
        }

        public TraceDomainType getLoggerDomain() {
            return this.fDomain;
        }
    }
}

