/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.variant;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.CTFException;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMemberMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.JsonStructureFieldMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeDeclaratorParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeSpecifierListParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class VariantDeclarationParser
extends AbstractScopedCommonTreeParser {
    public static final VariantDeclarationParser INSTANCE = new VariantDeclarationParser();

    private VariantDeclarationParser() {
    }

    @Override
    public VariantDeclaration parse(ICTFMetadataNode declaration, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        VariantDeclaration variant = ((Param)param).fVariant;
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        CTFTrace trace = ((Param)param).fTrace;
        if (declaration instanceof JsonStructureFieldMetadataNode) {
            List<ICTFMetadataNode> children = declaration.getChildren();
            if (children.isEmpty()) {
                throw new ParseException("Cannot have a variant with no fields");
            }
            for (ICTFMetadataNode child : children) {
                IDeclaration decl;
                JsonStructureFieldMemberMetadataNode member = (JsonStructureFieldMemberMetadataNode)child;
                JsonElement fieldClass = member.getFieldClass();
                String name = member.getName();
                if (fieldClass.isJsonObject()) {
                    String type = fieldClass.getAsJsonObject().get("type").getAsString();
                    if ("structure".equals(type)) {
                        JsonStructureFieldMetadataNode structureFieldClass = Objects.requireNonNull((JsonStructureFieldMetadataNode)new Gson().fromJson((JsonElement)fieldClass.getAsJsonObject(), JsonStructureFieldMetadataNode.class));
                        try {
                            structureFieldClass.initialize();
                        }
                        catch (CTFException e) {
                            throw new ParseException("Variant declaration does not match CTF2 Json format");
                        }
                        decl = TypeSpecifierListParser.INSTANCE.parse(structureFieldClass, new TypeSpecifierListParser.Param(trace, null, null, scope));
                    } else {
                        decl = TypeAliasParser.INSTANCE.parse(member, new TypeAliasParser.Param(trace, scope));
                    }
                } else {
                    throw new ParseException("Field class aliases are not yet supported by trace compass");
                }
                VariantDeclarationParser.addVariantField(variant, scope, decl, name);
            }
        } else {
            ICTFMetadataNode typeSpecifierListNode = declaration.getFirstChildWithType(CTFParser.tokenNames[117]);
            if (typeSpecifierListNode == null) {
                throw new ParseException("Variant need type specifiers");
            }
            ICTFMetadataNode typeDeclaratorListNode = declaration.getFirstChildWithType(CTFParser.tokenNames[116]);
            if (typeDeclaratorListNode == null) {
                throw new ParseException("Cannot have empty variant");
            }
            List<ICTFMetadataNode> typeDeclaratorList = typeDeclaratorListNode.getChildren();
            for (ICTFMetadataNode typeDeclaratorNode : typeDeclaratorList) {
                StringBuilder identifierSB = new StringBuilder();
                IDeclaration decl = TypeDeclaratorParser.INSTANCE.parse(typeDeclaratorNode, new TypeDeclaratorParser.Param(trace, typeSpecifierListNode, scope, identifierSB));
                String name = identifierSB.toString();
                VariantDeclarationParser.addVariantField(variant, scope, decl, name);
            }
        }
        return variant;
    }

    private static void addVariantField(VariantDeclaration variant, DeclarationScope scope, IDeclaration decl, String name) throws ParseException {
        if (variant.hasField(name)) {
            throw new ParseException("variant: duplicate field " + name);
        }
        scope.registerIdentifier(name, decl);
        variant.addField(name, decl);
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final VariantDeclaration fVariant;
        private final DeclarationScope fDeclarationScope;
        private final CTFTrace fTrace;

        public Param(VariantDeclaration variant, CTFTrace trace, DeclarationScope scope) {
            this.fVariant = variant;
            this.fTrace = trace;
            this.fDeclarationScope = scope;
        }
    }
}

