/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.protocol.pcap;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.pcap.core.packet.BadPacketException;
import org.eclipse.tracecompass.internal.pcap.core.protocol.pcap.PcapPacket;
import org.eclipse.tracecompass.internal.pcap.core.trace.PcapOldFile;
import org.eclipse.tracecompass.internal.pcap.core.util.ConversionHelper;

public class PcapOldPacket
extends PcapPacket {
    private static final long TIMESTAMP_MICROSECOND_MAX = 1000000L;
    private static final long TIMESTAMP_NANOSECOND_MAX = 1000000000L;

    public PcapOldPacket(PcapOldFile file, ByteBuffer header, @Nullable ByteBuffer payload, long index) throws BadPacketException {
        super(file);
        if (header.limit() < 16) {
            throw new BadPacketException("The Pcap packet header is too small.");
        }
        this.setIndex(index);
        header.order(this.getPcapFile().getByteOrder());
        header.position(0);
        long timestampMostSignificant = ConversionHelper.unsignedIntToLong(header.getInt());
        long timestampLeastSignificant = ConversionHelper.unsignedIntToLong(header.getInt());
        switch (this.getTimestampScale()) {
            case MICROSECOND: {
                if (timestampLeastSignificant > 1000000L) {
                    throw new BadPacketException("The timestamp is erroneous.");
                }
                this.setTimeStamp(1000000L * timestampMostSignificant + timestampLeastSignificant);
                break;
            }
            case NANOSECOND: {
                if (timestampMostSignificant > 1000000000L) {
                    throw new BadPacketException("The timestamp is erroneous.");
                }
                this.setTimeStamp(1000000000L * timestampMostSignificant + timestampLeastSignificant);
                break;
            }
            default: {
                throw new IllegalArgumentException("The timestamp precision is not valid!");
            }
        }
        this.setIncludedLength(ConversionHelper.unsignedIntToLong(header.getInt()));
        this.setOriginalLength(ConversionHelper.unsignedIntToLong(header.getInt()));
        ByteBuffer pcapPacket = payload;
        if (pcapPacket == null) {
            return;
        }
        pcapPacket.order(ByteOrder.BIG_ENDIAN);
        pcapPacket.position(0);
        this.setPayload(pcapPacket);
        this.setChildPacket(this.findChildPacket());
    }

    @Override
    public PcapOldFile getPcapFile() {
        return (PcapOldFile)super.getPcapFile();
    }

    @Override
    public long getDataLinkType() {
        return this.getPcapFile().getDataLinkType();
    }
}

